/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.CassandraOperationCategory;
import com.netflix.astyanax.CassandraOperationTracer;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.KeyspaceTracerFactory;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.IsRetryableException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.connectionpool.exceptions.OperationException;
import com.netflix.astyanax.cql.ConsistencyLevelMapping;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.CqlOperationResultImpl;
import com.netflix.astyanax.cql.retrypolicies.JavaDriverBasedRetryPolicy;
import com.netflix.astyanax.cql.util.AsyncOperationResult;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CqlAbstractExecutionImpl<R>
implements Execution<R> {
    private static final Logger LOG = LoggerFactory.getLogger(CqlAbstractExecutionImpl.class);
    protected final Session session;
    protected final String keyspace;
    protected final ColumnFamily<?, ?> cf;
    protected final KeyspaceTracerFactory tracerFactory;
    protected final RetryPolicy retry;
    protected final com.datastax.driver.core.ConsistencyLevel clLevel;

    public CqlAbstractExecutionImpl(CqlKeyspaceImpl.KeyspaceContext ksContext, CFQueryContext<?, ?> cfContext) {
        this.session = ksContext.getSession();
        this.keyspace = ksContext.getKeyspace();
        this.cf = cfContext != null ? cfContext.getColumnFamily() : null;
        this.tracerFactory = ksContext.getTracerFactory();
        RetryPolicy retryPolicy = ksContext.getConfig().getRetryPolicy();
        this.retry = retryPolicy != null ? retryPolicy : this.getRetryPolicy(cfContext.getRetryPolicy());
        this.clLevel = this.resolveConsistencyLevel(ksContext, cfContext);
    }

    public CqlAbstractExecutionImpl(CqlKeyspaceImpl.KeyspaceContext ksContext, RetryPolicy retryPolicy) {
        this.session = ksContext.getSession();
        this.keyspace = ksContext.getKeyspace();
        this.cf = null;
        this.tracerFactory = ksContext.getTracerFactory();
        this.retry = retryPolicy != null ? retryPolicy : this.getRetryPolicy(ksContext.getConfig().getRetryPolicy());
        this.clLevel = this.resolveConsistencyLevel(ksContext, null);
    }

    public OperationResult<R> execute() throws ConnectionException {
        Object lastException = null;
        this.retry.begin();
        do {
            try {
                return this.executeOp();
            }
            catch (RuntimeException ex) {
                lastException = new OperationException((Throwable)ex);
            }
            catch (ConnectionException ex) {
                if (ex instanceof IsRetryableException) {
                    lastException = ex;
                    continue;
                }
                throw ex;
            }
        } while (this.retry.allowRetry());
        throw lastException;
    }

    private OperationResult<R> executeOp() throws ConnectionException {
        CassandraOperationTracer tracer = null;
        tracer = this.cf != null ? this.tracerFactory.newTracer(this.getOperationType(), this.cf) : this.tracerFactory.newTracer(this.getOperationType());
        tracer.start();
        Statement query = this.getQuery();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query: " + query);
        }
        query.setConsistencyLevel(this.clLevel);
        if (this.retry instanceof JavaDriverBasedRetryPolicy) {
            JavaDriverBasedRetryPolicy jdRetryPolicy = (JavaDriverBasedRetryPolicy)this.retry;
            query.setRetryPolicy(jdRetryPolicy.getJDRetryPolicy());
        }
        ResultSet resultSet = this.session.execute(query);
        R result = this.parseResultSet(resultSet);
        CqlOperationResultImpl<R> opResult = new CqlOperationResultImpl<R>(resultSet, result);
        opResult.setAttemptsCount(this.retry.getAttemptCount());
        tracer.success();
        return opResult;
    }

    public ListenableFuture<OperationResult<R>> executeAsync() throws ConnectionException {
        final CassandraOperationTracer tracer = this.tracerFactory.newTracer(this.getOperationType());
        tracer.start();
        Statement query = this.getQuery();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query: " + query);
        }
        ResultSetFuture rsFuture = this.session.executeAsync(query);
        return new AsyncOperationResult<R>(rsFuture){

            @Override
            public OperationResult<R> getOperationResult(ResultSet resultSet) {
                Object result = null;
                try {
                    result = CqlAbstractExecutionImpl.this.parseResultSet(resultSet);
                }
                catch (NotFoundException e) {
                    e.printStackTrace();
                }
                tracer.success();
                CqlOperationResultImpl<Object> opResult = new CqlOperationResultImpl<Object>(resultSet, result);
                opResult.setAttemptsCount(CqlAbstractExecutionImpl.this.retry.getAttemptCount());
                return opResult;
            }
        };
    }

    private RetryPolicy getRetryPolicy(RetryPolicy policy) {
        if (policy != null) {
            return policy.duplicate();
        }
        return null;
    }

    private ConsistencyLevel getDefaultCL(CqlKeyspaceImpl.KeyspaceContext ksContext) {
        ConsistencyLevel clLevel = ksContext.getConfig().getDefaultReadConsistencyLevel();
        CassandraOperationCategory op = this.getOperationType().getCategory();
        switch (op) {
            case READ: {
                clLevel = ksContext.getConfig().getDefaultReadConsistencyLevel();
                break;
            }
            case WRITE: {
                clLevel = ksContext.getConfig().getDefaultWriteConsistencyLevel();
            }
            default: {
                clLevel = ksContext.getConfig().getDefaultReadConsistencyLevel();
            }
        }
        return clLevel;
    }

    private com.datastax.driver.core.ConsistencyLevel resolveConsistencyLevel(CqlKeyspaceImpl.KeyspaceContext ksContext, CFQueryContext<?, ?> cfContext) {
        ConsistencyLevel clLevel = null;
        if (cfContext != null) {
            clLevel = cfContext.getConsistencyLevel();
        }
        if (clLevel == null) {
            clLevel = this.getDefaultCL(ksContext);
        }
        return ConsistencyLevelMapping.getCL(clLevel);
    }

    public abstract CassandraOperationType getOperationType();

    public abstract Statement getQuery();

    public abstract R parseResultSet(ResultSet var1) throws NotFoundException;
}

