/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.mapping;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.mapping.AnnotationSet;
import com.netflix.astyanax.mapping.Coercions;
import com.netflix.astyanax.mapping.DefaultAnnotationSet;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
public class Mapping<T> {
    private final ImmutableMap<String, Field> fields;
    private final String idFieldName;
    private final Class<T> clazz;
    public static final String DEFAULT_ID_COLUMN_NAME = "ID";

    public static <T> Mapping<T> make(Class<T> clazz, boolean includeParentFields) {
        return new Mapping<T>(clazz, new DefaultAnnotationSet(), includeParentFields);
    }

    public static <T> Mapping<T> make(Class<T> clazz) {
        return new Mapping<T>(clazz, new DefaultAnnotationSet(), false);
    }

    public static <T> Mapping<T> make(Class<T> clazz, AnnotationSet<?, ?> annotationSet, boolean includeParentFields) {
        return new Mapping<T>(clazz, annotationSet, includeParentFields);
    }

    public static <T> Mapping<T> make(Class<T> clazz, AnnotationSet<?, ?> annotationSet) {
        return new Mapping<T>(clazz, annotationSet, false);
    }

    public Mapping(Class<T> clazz, boolean includeParentFields) {
        this(clazz, new DefaultAnnotationSet(), includeParentFields);
    }

    public Mapping(Class<T> clazz) {
        this(clazz, new DefaultAnnotationSet(), false);
    }

    public Mapping(Class<T> clazz, AnnotationSet<?, ?> annotationSet, boolean includeParentFields) {
        this.clazz = clazz;
        String localKeyFieldName = null;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        AtomicBoolean isKey = new AtomicBoolean();
        HashSet usedNames = Sets.newHashSet();
        List<Field> allFields = this.getFields(clazz, includeParentFields);
        for (Field field : allFields) {
            String name = this.mapField(field, annotationSet, (ImmutableMap.Builder<String, Field>)builder, usedNames, isKey);
            if (!isKey.get()) continue;
            Preconditions.checkArgument((localKeyFieldName == null ? 1 : 0) != 0);
            localKeyFieldName = name;
        }
        Preconditions.checkNotNull(localKeyFieldName);
        this.fields = builder.build();
        this.idFieldName = localKeyFieldName;
    }

    public Mapping(Class<T> clazz, AnnotationSet<?, ?> annotationSet) {
        this(clazz, annotationSet, false);
    }

    private List<Field> getFields(Class clazz, boolean recursuvely) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        if (clazz.getDeclaredFields() != null && clazz.getDeclaredFields().length > 0) {
            for (Field field : clazz.getDeclaredFields()) {
                allFields.add(field);
            }
            if (recursuvely && clazz.getSuperclass() != null) {
                allFields.addAll(this.getFields(clazz.getSuperclass(), true));
            }
        }
        return allFields;
    }

    public <V> V getIdValue(T instance, Class<V> valueClass) {
        return this.getColumnValue(instance, this.idFieldName, valueClass);
    }

    public <V> V getColumnValue(T instance, String columnName, Class<V> valueClass) {
        Field field = (Field)this.fields.get((Object)columnName);
        if (field == null) {
            throw new IllegalArgumentException("Column not found: " + columnName);
        }
        try {
            return valueClass.cast(field.get(instance));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public <V> void setIdValue(T instance, V value) {
        this.setColumnValue(instance, this.idFieldName, value);
    }

    public <V> void setColumnValue(T instance, String columnName, V value) {
        Field field = (Field)this.fields.get((Object)columnName);
        if (field == null) {
            throw new IllegalArgumentException("Column not found: " + columnName);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void fillMutation(T instance, ColumnListMutation<String> mutation) {
        for (String fieldName : this.getNames()) {
            Coercions.setColumnMutationFromField(instance, (Field)this.fields.get((Object)fieldName), fieldName, mutation);
        }
    }

    public T newInstance(ColumnList<String> columns) throws IllegalAccessException, InstantiationException {
        return this.initInstance(this.clazz.newInstance(), columns);
    }

    public T initInstance(T instance, ColumnList<String> columns) {
        for (Column column : columns) {
            Field field = (Field)this.fields.get(column.getName());
            if (field == null) continue;
            Coercions.setFieldFromColumn(instance, field, column);
        }
        return instance;
    }

    public List<T> getAll(Rows<?, String> rows) throws InstantiationException, IllegalAccessException {
        ArrayList list = Lists.newArrayList();
        for (Row row : rows) {
            if (row.getColumns().isEmpty()) continue;
            list.add(this.newInstance(row.getColumns()));
        }
        return list;
    }

    public Collection<String> getNames() {
        return this.fields.keySet();
    }

    Class<?> getIdFieldClass() {
        return ((Field)this.fields.get((Object)this.idFieldName)).getType();
    }

    private <ID extends Annotation, COLUMN extends Annotation> String mapField(Field field, AnnotationSet<ID, COLUMN> annotationSet, ImmutableMap.Builder<String, Field> builder, Set<String> usedNames, AtomicBoolean isKey) {
        String mappingName = null;
        ID idAnnotation = field.getAnnotation(annotationSet.getIdAnnotation());
        COLUMN columnAnnotation = field.getAnnotation(annotationSet.getColumnAnnotation());
        if (idAnnotation != null && columnAnnotation != null) {
            throw new IllegalStateException("A field cannot be marked as both an ID and a Column: " + field.getName());
        }
        if (idAnnotation != null) {
            mappingName = annotationSet.getIdName(field, idAnnotation);
            isKey.set(true);
        } else {
            isKey.set(false);
        }
        if (columnAnnotation != null) {
            mappingName = annotationSet.getColumnName(field, columnAnnotation);
        }
        if (mappingName != null) {
            Preconditions.checkArgument((!usedNames.contains(mappingName.toLowerCase()) ? 1 : 0) != 0, (Object)(mappingName + " has already been used for this column family"));
            usedNames.add(mappingName.toLowerCase());
            field.setAccessible(true);
            builder.put((Object)mappingName, (Object)field);
        }
        return mappingName;
    }
}

