/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.google.common.collect.Lists;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.connectionpool.exceptions.NotFoundException;
import com.netflix.astyanax.model.ByteBufferRange;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.model.RangeEndpoint;
import com.netflix.astyanax.recipes.locks.BusyLockException;
import com.netflix.astyanax.recipes.queue.DuplicateMessageException;
import com.netflix.astyanax.recipes.queue.Message;
import com.netflix.astyanax.recipes.queue.MessageConsumer;
import com.netflix.astyanax.recipes.queue.MessageContext;
import com.netflix.astyanax.recipes.queue.MessageHistory;
import com.netflix.astyanax.recipes.queue.MessageMetadataEntry;
import com.netflix.astyanax.recipes.queue.MessageMetadataEntryType;
import com.netflix.astyanax.recipes.queue.MessageQueueEntry;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryState;
import com.netflix.astyanax.recipes.queue.MessageQueueEntryType;
import com.netflix.astyanax.recipes.queue.MessageQueueException;
import com.netflix.astyanax.recipes.queue.MessageQueueHooks;
import com.netflix.astyanax.recipes.queue.MessageQueueShard;
import com.netflix.astyanax.recipes.queue.MessageStatus;
import com.netflix.astyanax.recipes.queue.ShardLock;
import com.netflix.astyanax.recipes.queue.ShardedDistributedMessageQueue;
import com.netflix.astyanax.recipes.queue.triggers.Trigger;
import com.netflix.astyanax.util.RangeBuilder;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageConsumerImpl
implements MessageConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MessageConsumerImpl.class);
    private final ShardedDistributedMessageQueue queue;

    public MessageConsumerImpl(ShardedDistributedMessageQueue q) {
        this.queue = q;
    }

    @Override
    public List<MessageContext> readMessages(int itemsToPop) throws MessageQueueException, BusyLockException, InterruptedException {
        return this.readMessages(itemsToPop, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageContext> readMessages(int itemsToPop, long timeout, TimeUnit units) throws MessageQueueException, BusyLockException, InterruptedException {
        long timeoutTime = timeout == 0L ? 0L : System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, units);
        List<MessageContext> messages = null;
        while (true) {
            MessageQueueShard partition;
            if ((partition = this.queue.shardReaderPolicy.nextShard()) != null) {
                try {
                    messages = this.readAndReturnShard(partition, itemsToPop);
                    if (messages != null && !messages.isEmpty()) {
                        List<MessageContext> list = messages;
                        this.queue.shardReaderPolicy.releaseShard(partition, messages == null ? 0 : messages.size());
                        return list;
                    }
                    this.queue.shardReaderPolicy.releaseShard(partition, messages == null ? 0 : messages.size());
                }
                catch (Throwable throwable) {
                    this.queue.shardReaderPolicy.releaseShard(partition, messages == null ? 0 : messages.size());
                    throw throwable;
                }
            }
            if (timeoutTime != 0L && System.currentTimeMillis() > timeoutTime) {
                return Lists.newLinkedList();
            }
            Thread.sleep(this.queue.shardReaderPolicy.getPollInterval());
        }
    }

    public List<Message> peekMessages(int itemsToPeek) throws MessageQueueException {
        return this.queue.peekMessages(itemsToPeek);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MessageContext> readAndReturnShard(MessageQueueShard shard, int itemsToPop) throws MessageQueueException, BusyLockException, InterruptedException {
        List<MessageContext> messages = null;
        try {
            messages = this.readMessagesFromShard(shard.getName(), itemsToPop);
        }
        finally {
            if (messages == null || messages.isEmpty()) {
                this.queue.stats.incEmptyPartitionCount();
            }
        }
        return messages;
    }

    @Override
    public List<MessageContext> readMessagesFromShard(String shardName, int itemsToPop) throws MessageQueueException, BusyLockException {
        if (this.queue.lockManager != null) {
            return this.readMessagesFromShardUsingLockManager(shardName, itemsToPop);
        }
        return this.readMessagesFromShardUsingDefaultLock(shardName, itemsToPop);
    }

    List<MessageContext> readMessagesFromShardUsingLockManager(String shardName, int itemToPop) throws MessageQueueException, BusyLockException {
        ShardLock lock = null;
        try {
            lock = this.queue.lockManager.acquireLock(shardName);
            MutationBatch m = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
            ColumnListMutation rowMutation = m.withRow(this.queue.queueColumnFamily, (Object)shardName);
            long curTimeMicros = TimeUUIDUtils.getMicrosTimeFromUUID((UUID)TimeUUIDUtils.getUniqueTimeUUIDinMicros());
            List<MessageContext> list = this.readMessagesInternal(shardName, itemToPop, 0, null, (ColumnListMutation<MessageQueueEntry>)rowMutation, m, curTimeMicros);
            return list;
        }
        catch (BusyLockException e) {
            this.queue.stats.incLockContentionCount();
            throw e;
        }
        catch (Exception e) {
            LOG.error("Error reading shard " + shardName, (Throwable)e);
            throw new MessageQueueException("Error", e);
        }
        finally {
            this.queue.lockManager.releaseLock(lock);
        }
    }

    List<MessageContext> readMessagesFromShardUsingDefaultLock(String shardName, int itemsToPop) throws MessageQueueException, BusyLockException {
        long curTimeMicros;
        MutationBatch m = null;
        MessageQueueEntry lockColumn = null;
        ColumnListMutation rowMutation = null;
        int lockColumnCount = 0;
        try {
            lockColumn = MessageQueueEntry.newLockEntry(MessageQueueEntryState.None);
            curTimeMicros = TimeUUIDUtils.getTimeFromUUID((UUID)lockColumn.getTimestamp());
            m = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
            m.withRow(this.queue.queueColumnFamily, (Object)shardName).putColumn((Object)lockColumn, curTimeMicros + this.queue.lockTimeout, Integer.valueOf(this.queue.lockTtl));
            m.execute();
            ColumnList result = (ColumnList)this.queue.keyspace.prepareQuery(this.queue.queueColumnFamily).setConsistencyLevel(this.queue.consistencyLevel).getKey((Object)shardName).withColumnRange((ByteBufferRange)ShardedDistributedMessageQueue.entrySerializer.buildRange().greaterThanEquals((Object)((byte)MessageQueueEntryType.Lock.ordinal())).lessThanEquals((Object)((byte)MessageQueueEntryType.Lock.ordinal())).build()).execute().getResult();
            m = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
            rowMutation = m.withRow(this.queue.queueColumnFamily, (Object)shardName);
            rowMutation.deleteColumn((Object)lockColumn);
            int lockCount = 0;
            boolean lockAcquired = false;
            lockColumnCount = result.size();
            for (Column column : result) {
                MessageQueueEntry lock = (MessageQueueEntry)column.getName();
                if (lock.getType() != MessageQueueEntryType.Lock) continue;
                ++lockColumnCount;
                if (column.getLongValue() < curTimeMicros) {
                    this.queue.stats.incExpiredLockCount();
                    rowMutation.deleteColumn((Object)lock);
                } else {
                    if (lock.getState() == MessageQueueEntryState.Acquired) {
                        throw new BusyLockException("Not first lock");
                    }
                    if (++lockCount == 1 && lock.getTimestamp().equals(lockColumn.getTimestamp())) {
                        lockAcquired = true;
                    }
                }
                if (!lockAcquired) {
                    throw new BusyLockException("Not first lock");
                }
                lockColumn = MessageQueueEntry.newLockEntry(lockColumn.getTimestamp(), MessageQueueEntryState.Acquired);
                rowMutation.putColumn((Object)lockColumn, curTimeMicros + this.queue.lockTimeout, Integer.valueOf(this.queue.lockTtl));
            }
        }
        catch (BusyLockException e) {
            this.queue.stats.incLockContentionCount();
            throw e;
        }
        catch (ConnectionException e) {
            LOG.error("Error reading shard " + shardName, (Throwable)e);
            throw new MessageQueueException("Error", e);
        }
        finally {
            try {
                m.execute();
            }
            catch (Exception e) {
                throw new MessageQueueException("Error committing lock", e);
            }
        }
        curTimeMicros = TimeUUIDUtils.getMicrosTimeFromUUID((UUID)lockColumn.getTimestamp());
        m = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
        rowMutation = m.withRow(this.queue.queueColumnFamily, (Object)shardName);
        rowMutation.deleteColumn((Object)lockColumn);
        return this.readMessagesInternal(shardName, itemsToPop, lockColumnCount, lockColumn, (ColumnListMutation<MessageQueueEntry>)rowMutation, m, curTimeMicros);
    }

    @Override
    public void ackMessage(MessageContext context) throws MessageQueueException {
        MutationBatch mb = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
        this.fillAckMutation(context, mb);
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to ack message", e);
        }
    }

    @Override
    public void ackMessages(Collection<MessageContext> messages) throws MessageQueueException {
        MutationBatch mb = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
        for (MessageContext context : messages) {
            this.fillAckMutation(context, mb);
        }
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            throw new MessageQueueException("Failed to ack messages", e);
        }
    }

    private void fillAckMutation(MessageContext context, MutationBatch mb) {
        this.queue.stats.incAckMessageCount();
        Message message = context.getMessage();
        if (message.getToken() != null) {
            MessageQueueEntry entry = MessageQueueEntry.newBusyEntry(message);
            mb.withRow(this.queue.queueColumnFamily, (Object)this.queue.getShardKey(message)).deleteColumn((Object)entry);
            if (message.hasKey()) {
                mb.withRow(this.queue.keyIndexColumnFamily, (Object)this.queue.getCompositeKey(this.queue.getName(), message.getKey())).putEmptyColumn((Object)MessageMetadataEntry.newMessageId(this.queue.getCompositeKey(this.queue.getShardKey(message), entry.getMessageId())), Integer.valueOf(this.queue.metadataDeleteTTL));
                if (message.isKeepHistory()) {
                    MessageHistory history = context.getHistory();
                    if (history.getStatus() == MessageStatus.RUNNING) {
                        history.setStatus(MessageStatus.DONE);
                    }
                    history.setEndTime(TimeUnit.MICROSECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS));
                    try {
                        mb.withRow(this.queue.historyColumnFamily, (Object)message.getKey()).putColumn((Object)history.getToken(), this.queue.serializeToString(context.getHistory()), this.queue.metadata.getHistoryTtl());
                    }
                    catch (Exception e) {
                        LOG.warn("Error serializing message history for " + message.getKey(), (Throwable)e);
                    }
                }
            }
            for (MessageQueueHooks hook : this.queue.hooks) {
                hook.beforeAckMessage(message, mb);
            }
        }
        if (context.getNextMessage() != null) {
            try {
                this.queue.fillMessageMutation(mb, context.getNextMessage());
            }
            catch (MessageQueueException e) {
                LOG.warn("Error filling nextMessage for " + message.getKey(), (Throwable)e);
            }
        }
    }

    @Override
    public void ackPoisonMessage(MessageContext context) throws MessageQueueException {
        MutationBatch mb = this.queue.keyspace.prepareMutationBatch().setConsistencyLevel(this.queue.consistencyLevel);
        this.fillAckMutation(context, mb);
        try {
            mb.execute();
        }
        catch (ConnectionException e) {
            this.queue.stats.incPersistError();
            throw new MessageQueueException("Failed to ack messages", e);
        }
    }

    private List<MessageContext> readMessagesInternal(String shardName, int itemsToPop, int lockColumnCount, MessageQueueEntry lockColumn, ColumnListMutation<MessageQueueEntry> rowMutation, MutationBatch m, long curTimeMicros) throws BusyLockException, MessageQueueException {
        try {
            ArrayList entries = Lists.newArrayList();
            RangeEndpoint re = ShardedDistributedMessageQueue.entrySerializer.makeEndpoint((Object)((byte)MessageQueueEntryType.Message.ordinal()), Equality.EQUAL).append((Object)0, Equality.EQUAL);
            if (lockColumn != null) {
                re.append((Object)lockColumn.getTimestamp(), Equality.LESS_THAN_EQUALS);
            } else {
                re.append((Object)TimeUUIDUtils.getMicrosTimeUUID((long)curTimeMicros), Equality.LESS_THAN_EQUALS);
            }
            ColumnList result = (ColumnList)this.queue.keyspace.prepareQuery(this.queue.queueColumnFamily).setConsistencyLevel(this.queue.consistencyLevel).getKey((Object)shardName).withColumnRange(new RangeBuilder().setLimit(itemsToPop + (lockColumn == null ? 0 : lockColumnCount + 1)).setEnd(re.toBytes()).build()).execute().getResult();
            for (Column column : result) {
                if (itemsToPop == 0) break;
                MessageQueueEntry entry = (MessageQueueEntry)column.getName();
                switch (entry.getType()) {
                    case Lock: {
                        if (lockColumn == null || entry.getState() != MessageQueueEntryState.Acquired || entry.getTimestamp().equals(lockColumn.getTimestamp())) break;
                        throw new BusyLockException("Someone else snuck in");
                    }
                    case Message: {
                        try {
                            --itemsToPop;
                            String messageId = this.queue.getCompositeKey(shardName, entry.getMessageId());
                            rowMutation.deleteColumn((Object)entry);
                            Message message = this.queue.extractMessageFromColumn((Column<MessageQueueEntry>)column);
                            if (message != null) {
                                MessageContext context = new MessageContext();
                                context.setMessage(message);
                                if (message.hasTrigger()) {
                                    String groupRowKey = this.queue.getCompositeKey(this.queue.getName(), message.getKey());
                                    try {
                                        ColumnList columns = (ColumnList)this.queue.keyspace.prepareQuery(this.queue.keyIndexColumnFamily).getRow((Object)groupRowKey).withColumnRange((ByteBufferRange)ShardedDistributedMessageQueue.metadataSerializer.buildRange().greaterThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).lessThanEquals((Object)((byte)MessageMetadataEntryType.MessageId.ordinal())).build()).execute().getResult();
                                        MessageMetadataEntry mostRecentMessageMetadata = null;
                                        long mostRecentTriggerTime = 0L;
                                        for (Column currMessageEntry : columns) {
                                            MessageQueueEntry pendingMessageEntry = MessageQueueEntry.fromMetadata((MessageMetadataEntry)currMessageEntry.getName());
                                            if (currMessageEntry.getTtl() != 0) continue;
                                            long currMessageTriggerTime = pendingMessageEntry.getTimestamp(TimeUnit.MICROSECONDS);
                                            if (mostRecentMessageMetadata == null) {
                                                mostRecentMessageMetadata = (MessageMetadataEntry)currMessageEntry.getName();
                                                mostRecentTriggerTime = currMessageTriggerTime;
                                                continue;
                                            }
                                            if (currMessageTriggerTime > mostRecentTriggerTime) {
                                                LOG.warn("Need to discard : " + entry.getMessageId() + " => " + mostRecentMessageMetadata.getName());
                                                m.withRow(this.queue.keyIndexColumnFamily, (Object)this.queue.getCompositeKey(this.queue.getName(), message.getKey())).putEmptyColumn((Object)mostRecentMessageMetadata, Integer.valueOf(this.queue.metadataDeleteTTL));
                                                mostRecentTriggerTime = currMessageTriggerTime;
                                                mostRecentMessageMetadata = (MessageMetadataEntry)currMessageEntry.getName();
                                                continue;
                                            }
                                            LOG.warn("Need to discard : " + entry.getMessageId() + " => " + currMessageEntry.getName());
                                            m.withRow(this.queue.keyIndexColumnFamily, (Object)this.queue.getCompositeKey(this.queue.getName(), message.getKey())).putEmptyColumn(currMessageEntry.getName(), Integer.valueOf(this.queue.metadataDeleteTTL));
                                        }
                                        if (mostRecentMessageMetadata != null && !mostRecentMessageMetadata.getName().endsWith(entry.getMessageId())) {
                                            throw new DuplicateMessageException("Duplicate trigger for " + messageId);
                                        }
                                    }
                                    catch (NotFoundException e) {
                                    }
                                    catch (ConnectionException e) {
                                        throw new MessageQueueException("Error fetching row " + groupRowKey, e);
                                    }
                                    Trigger trigger = message.getTrigger().nextTrigger();
                                    if (trigger != null) {
                                        Message nextMessage = message.clone();
                                        nextMessage.setTrigger(trigger);
                                        context.setNextMessage(nextMessage);
                                        if (message.isAutoCommitTrigger()) {
                                            this.queue.fillMessageMutation(m, nextMessage);
                                        }
                                    }
                                }
                                if (message.hasKey()) {
                                    m.withRow(this.queue.keyIndexColumnFamily, (Object)this.queue.getCompositeKey(this.queue.getName(), message.getKey())).putEmptyColumn((Object)MessageMetadataEntry.newMessageId(messageId), Integer.valueOf(this.queue.metadataDeleteTTL));
                                    LOG.debug("Removing from key  :  " + this.queue.getCompositeKey(this.queue.getName(), message.getKey()) + " : " + messageId);
                                    if (message.isKeepHistory()) {
                                        MessageHistory history = context.getHistory();
                                        history.setToken(entry.getTimestamp());
                                        history.setStartTime(curTimeMicros);
                                        history.setTriggerTime(message.getTrigger().getTriggerTime());
                                        history.setStatus(MessageStatus.RUNNING);
                                        try {
                                            m.withRow(this.queue.historyColumnFamily, (Object)message.getKey()).putColumn((Object)entry.getTimestamp(), this.queue.serializeToString(history), this.queue.metadata.getHistoryTtl());
                                        }
                                        catch (Exception e) {
                                            LOG.warn("Error serializing history for key '" + message.getKey() + "'", (Throwable)e);
                                        }
                                    }
                                }
                                if (message.getTimeout() > 0) {
                                    MessageQueueEntry timeoutEntry = MessageQueueEntry.newMessageEntry((byte)0, TimeUUIDUtils.getMicrosTimeUUID((long)(curTimeMicros + TimeUnit.MICROSECONDS.convert(message.getTimeout(), TimeUnit.SECONDS) + this.queue.counter.incrementAndGet() % 1000L)), MessageQueueEntryState.Busy);
                                    message.setToken(timeoutEntry.getTimestamp());
                                    message.setRandom(timeoutEntry.getRandom());
                                    m.withRow(this.queue.queueColumnFamily, (Object)this.queue.getShardKey(message)).putColumn((Object)timeoutEntry, column.getStringValue(), this.queue.metadata.getRetentionTimeout());
                                    MessageMetadataEntry messageIdEntry = MessageMetadataEntry.newMessageId(this.queue.getCompositeKey(this.queue.getShardKey(message), timeoutEntry.getMessageId()));
                                    if (message.hasKey()) {
                                        m.withRow(this.queue.keyIndexColumnFamily, (Object)this.queue.getCompositeKey(this.queue.getName(), message.getKey())).putEmptyColumn((Object)messageIdEntry, this.queue.metadata.getRetentionTimeout());
                                    }
                                    context.setAckMessageId(messageIdEntry.getName());
                                } else {
                                    message.setToken(null);
                                }
                                switch (entry.getState()) {
                                    case Waiting: {
                                        this.queue.stats.incProcessCount();
                                        break;
                                    }
                                    case Busy: {
                                        this.queue.stats.incReprocessCount();
                                        break;
                                    }
                                    default: {
                                        LOG.warn("Unknown message state: " + (Object)((Object)entry.getState()));
                                    }
                                }
                                entries.add(context);
                                break;
                            }
                            this.queue.stats.incInvalidMessageCount();
                        }
                        catch (DuplicateMessageException e) {}
                        break;
                    }
                }
            }
            ArrayList arrayList = entries;
            return arrayList;
        }
        catch (BusyLockException e) {
            this.queue.stats.incLockContentionCount();
            throw e;
        }
        catch (Exception e) {
            throw new MessageQueueException("Error processing queue shard : " + shardName, e);
        }
        finally {
            try {
                m.execute();
            }
            catch (Exception e) {
                throw new MessageQueueException("Error processing queue shard : " + shardName, e);
            }
        }
    }
}

