/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.recipes.queue;

import com.google.common.collect.Maps;
import com.netflix.astyanax.recipes.queue.triggers.Trigger;
import com.netflix.astyanax.util.TimeUUIDUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.annotate.JsonIgnore;

public class Message {
    private static final int DEFAULT_TIMEOUT_SECONDS = 120;
    private UUID token;
    private UUID random;
    private Trigger trigger;
    private Map<String, Object> parameters;
    private byte priority = 0;
    private int timeout = 120;
    private String key;
    private String taskClass;
    private boolean isKeepHistory = false;
    private boolean hasUniqueKey = false;
    private boolean isAutoCommitTrigger = false;

    public Message() {
    }

    public Message(UUID token, UUID random) {
        this.token = token;
        this.random = random;
    }

    public UUID getToken() {
        return this.token;
    }

    public Message setToken(UUID token) {
        this.token = token;
        return this;
    }

    @JsonIgnore
    public long getTokenTime() {
        return TimeUUIDUtils.getMicrosTimeFromUUID((UUID)this.token);
    }

    public UUID getRandom() {
        return this.random;
    }

    public Message setRandom(UUID random) {
        this.random = random;
        return this;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public Message setTrigger(Trigger trigger) {
        this.trigger = trigger;
        return this;
    }

    public boolean hasTrigger() {
        return this.trigger != null;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Message setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Message addParameter(String key, Object value) {
        if (this.parameters == null) {
            this.parameters = Maps.newHashMap();
        }
        this.parameters.put(key, value);
        return this;
    }

    public byte getPriority() {
        return this.priority;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != 0;
    }

    public Message setPriority(byte priority) {
        this.priority = priority;
        return this;
    }

    public Message setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Message setTimeout(long timeout, TimeUnit units) {
        this.timeout = (int)TimeUnit.SECONDS.convert(timeout, units);
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public Message setKey(String key) {
        this.key = key;
        return this;
    }

    public Message setUniqueKey(String key) {
        this.key = key;
        this.hasUniqueKey = true;
        return this;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean hasUniqueKey() {
        return this.key != null && this.hasUniqueKey;
    }

    public String getTaskClass() {
        return this.taskClass;
    }

    public Message setTaskClass(String taskClass) {
        this.taskClass = taskClass;
        return this;
    }

    public boolean hasTaskClass() {
        return this.taskClass != null;
    }

    public boolean isKeepHistory() {
        return this.isKeepHistory;
    }

    public Message setKeepHistory(Boolean isKeepHistory) {
        this.isKeepHistory = isKeepHistory;
        return this;
    }

    public Message clone() {
        Message message = new Message();
        message.token = this.token;
        message.trigger = this.trigger;
        message.parameters = this.parameters;
        message.priority = this.priority;
        message.timeout = this.timeout;
        message.key = this.key;
        message.taskClass = this.taskClass;
        message.isKeepHistory = this.isKeepHistory;
        return message;
    }

    public boolean isAutoCommitTrigger() {
        return this.isAutoCommitTrigger;
    }

    public Message setAutoCommitTrigger(boolean isAutoCommitTrigger) {
        this.isAutoCommitTrigger = isAutoCommitTrigger;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message[");
        if (this.token != null) {
            sb.append("token=" + this.token + " (" + TimeUUIDUtils.getMicrosTimeFromUUID((UUID)this.token) + ")");
        }
        if (this.random != null) {
            sb.append(", random=" + this.random);
        }
        if (this.trigger != null) {
            sb.append(", trigger=" + this.trigger);
        }
        if (this.parameters != null) {
            sb.append(", parameters=" + this.parameters);
        }
        sb.append(", priority=" + this.priority);
        sb.append(", timeout=" + this.timeout);
        if (this.key != null) {
            sb.append(", key=" + this.key);
        }
        if (this.hasUniqueKey) {
            sb.append(", hasUniqueKey=" + this.hasUniqueKey);
        }
        if (this.taskClass != null) {
            sb.append(", taskClass=" + this.taskClass);
        }
        if (this.isKeepHistory) {
            sb.append(", isKeepHistory=" + this.isKeepHistory);
        }
        sb.append("]");
        return sb.toString();
    }
}

