/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.tag;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.netflix.servo.tag.Tag;
import com.netflix.servo.tag.TagList;
import com.netflix.servo.tag.Tags;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;

public final class SortedTagList
implements TagList {
    public static final SortedTagList EMPTY = new Builder().build();
    private final SortedMap<String, Tag> tagSortedMap;
    private final int size;

    private SortedTagList(Builder builder) {
        this.tagSortedMap = ImmutableSortedMap.copyOf((Map)builder.data);
        this.size = this.tagSortedMap.size();
    }

    @Override
    public Tag getTag(String key) {
        return (Tag)this.tagSortedMap.get(key);
    }

    @Override
    public String getValue(String key) {
        Tag t = (Tag)this.tagSortedMap.get(key);
        return t == null ? null : t.getValue();
    }

    @Override
    public boolean containsKey(String key) {
        return this.tagSortedMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.tagSortedMap.isEmpty();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Tag> iterator() {
        return this.tagSortedMap.values().iterator();
    }

    @Override
    public Map<String, String> asMap() {
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>(this.size);
        for (Tag t : this.tagSortedMap.values()) {
            stringMap.put(t.getKey(), t.getValue());
        }
        return stringMap;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        return obj instanceof SortedTagList && this.tagSortedMap.equals(((SortedTagList)obj).tagSortedMap);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagSortedMap});
    }

    public String toString() {
        return Joiner.on((String)",").join(this.tagSortedMap.values());
    }

    public static final class Builder {
        private final Map<String, Tag> data = Maps.newHashMap();

        public Builder withTags(Collection<Tag> tagsCollection) {
            for (Tag tag : tagsCollection) {
                Tag t = Tags.internCustom(tag);
                this.data.put(t.getKey(), t);
            }
            return this;
        }

        public Builder withTags(TagList tags) {
            for (Tag tag : tags) {
                Tag t = Tags.internCustom(tag);
                this.data.put(t.getKey(), t);
            }
            return this;
        }

        public Builder withTag(Tag tag) {
            Tag t = Tags.internCustom(tag);
            this.data.put(t.getKey(), t);
            return this;
        }

        public Builder withTag(String key, String value) {
            return this.withTag(Tags.newTag(key, value));
        }

        public SortedTagList build() {
            return new SortedTagList(this);
        }
    }
}

