/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class BasicStopwatch
implements Stopwatch {
    private final AtomicLong startTime = new AtomicLong(0L);
    private final AtomicLong endTime = new AtomicLong(0L);

    @Override
    public void start() {
        this.startTime.set(System.nanoTime());
    }

    @Override
    public void stop() {
        this.endTime.set(System.nanoTime());
    }

    @Override
    public void reset() {
        this.startTime.set(0L);
        this.endTime.set(0L);
    }

    @Override
    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.getDuration(), TimeUnit.NANOSECONDS);
    }

    @Override
    public long getDuration() {
        return this.endTime.get() - this.startTime.get();
    }
}

