/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.ToStringUtils;

public class TermsQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermsQuery.class);
    static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    private static Term[] toTermArray(String field, List<BytesRef> termBytes) {
        Term[] array = new Term[termBytes.size()];
        int i = 0;
        for (BytesRef t : termBytes) {
            array[i++] = new Term(field, t);
        }
        return array;
    }

    public TermsQuery(List<Term> terms) {
        Term[] sortedTerms = terms.toArray(new Term[terms.size()]);
        ArrayUtil.timSort((Comparable[])sortedTerms);
        PrefixCodedTerms.Builder builder = new PrefixCodedTerms.Builder();
        Term previous = null;
        for (Term term : sortedTerms) {
            if (!term.equals(previous)) {
                builder.add(term);
            }
            previous = term;
        }
        this.termData = builder.finish();
        this.termDataHashCode = this.termData.hashCode();
    }

    public TermsQuery(String field, List<BytesRef> terms) {
        this(TermsQuery.toTermArray(field, terms));
    }

    public TermsQuery(String field, BytesRef ... terms) {
        this(field, Arrays.asList(terms));
    }

    public TermsQuery(Term ... terms) {
        this(Arrays.asList(terms));
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
        if (this.termData.size() <= (long)threshold) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
            BytesRef term = iterator.next();
            while (term != null) {
                bq.add((Query)new TermQuery(new Term(iterator.field(), BytesRef.deepCopyOf((BytesRef)term))), BooleanClause.Occur.SHOULD);
                term = iterator.next();
            }
            return new ConstantScoreQuery((Query)bq.build());
        }
        return super.rewrite(reader);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TermsQuery that = (TermsQuery)((Object)obj);
        return this.termDataHashCode == that.termDataHashCode && this.termData.equals((Object)that.termData);
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.termDataHashCode;
    }

    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(new Term(iterator.field(), term).toString());
            term = iterator.next();
        }
        builder.append(ToStringUtils.boost((float)this.getBoost()));
        return builder.toString();
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.termData.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public Weight createWeight(final IndexSearcher searcher, final boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            public void extractTerms(Set<Term> terms) {
            }

            private WeightOrDocIdSet rewrite(LeafReaderContext context) throws IOException {
                LeafReader reader = context.reader();
                int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
                assert (TermsQuery.this.termData.size() > (long)threshold) : "Query should have been rewritten";
                ArrayList<TermAndState> matchingTerms = new ArrayList<TermAndState>(threshold);
                DocIdSetBuilder builder = null;
                Fields fields = reader.fields();
                String lastField = null;
                Terms terms = null;
                TermsEnum termsEnum = null;
                PostingsEnum docs = null;
                PrefixCodedTerms.TermIterator iterator = TermsQuery.this.termData.iterator();
                BytesRef term = iterator.next();
                while (term != null) {
                    String field = iterator.field();
                    if (field != lastField) {
                        terms = fields.terms(field);
                        termsEnum = terms == null ? null : terms.iterator();
                        lastField = field;
                    }
                    if (termsEnum != null && termsEnum.seekExact(term)) {
                        if (matchingTerms == null) {
                            docs = termsEnum.postings(docs, 0);
                            builder.add((DocIdSetIterator)docs);
                        } else if (matchingTerms.size() < threshold) {
                            matchingTerms.add(new TermAndState(field, termsEnum));
                        } else {
                            assert (matchingTerms.size() == threshold);
                            builder = new DocIdSetBuilder(reader.maxDoc());
                            docs = termsEnum.postings(docs, 0);
                            builder.add((DocIdSetIterator)docs);
                            for (TermAndState t : matchingTerms) {
                                t.termsEnum.seekExact(t.term, t.state);
                                docs = t.termsEnum.postings(docs, 0);
                                builder.add((DocIdSetIterator)docs);
                            }
                            matchingTerms = null;
                        }
                    }
                    term = iterator.next();
                }
                if (matchingTerms != null) {
                    assert (builder == null);
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    for (TermAndState t : matchingTerms) {
                        TermContext termContext = new TermContext(searcher.getTopReaderContext());
                        termContext.register(t.state, context.ord, t.docFreq, t.totalTermFreq);
                        bq.add((Query)new TermQuery(new Term(t.field, t.term), termContext), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery q = new ConstantScoreQuery((Query)bq.build());
                    Weight weight = searcher.rewrite((Query)q).createWeight(searcher, needsScores);
                    weight.normalize(1.0f, this.score());
                    return new WeightOrDocIdSet(weight);
                }
                assert (builder != null);
                return new WeightOrDocIdSet(builder.build());
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), disi);
            }

            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.bulkScorer(context);
                }
                Scorer scorer = this.scorer(weightOrBitSet.set);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.scorer(context);
                }
                return this.scorer(weightOrBitSet.set);
            }
        };
    }

    private static class WeightOrDocIdSet {
        final Weight weight;
        final DocIdSet set;

        WeightOrDocIdSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.set = null;
        }

        WeightOrDocIdSet(DocIdSet bitset) {
            this.set = bitset;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final String field;
        final TermsEnum termsEnum;
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(String field, TermsEnum termsEnum) throws IOException {
            this.field = field;
            this.termsEnum = termsEnum;
            this.term = BytesRef.deepCopyOf((BytesRef)termsEnum.term());
            this.state = termsEnum.termState();
            this.docFreq = termsEnum.docFreq();
            this.totalTermFreq = termsEnum.totalTermFreq();
        }
    }
}

