/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CLibrary {
    private static final Logger logger = LoggerFactory.getLogger(CLibrary.class);
    private static final int MCL_CURRENT = 1;
    private static final int MCL_FUTURE = 2;
    private static final int ENOMEM = 12;
    private static final int F_GETFL = 3;
    private static final int F_SETFL = 4;
    private static final int F_NOCACHE = 48;
    private static final int O_DIRECT = 16384;
    private static final int O_RDONLY = 0;
    private static final int POSIX_FADV_NORMAL = 0;
    private static final int POSIX_FADV_RANDOM = 1;
    private static final int POSIX_FADV_SEQUENTIAL = 2;
    private static final int POSIX_FADV_WILLNEED = 3;
    private static final int POSIX_FADV_DONTNEED = 4;
    private static final int POSIX_FADV_NOREUSE = 5;
    static boolean jnaAvailable = false;
    static boolean jnaLockable = false;

    private static native int mlockall(int var0) throws LastErrorException;

    private static native int munlockall() throws LastErrorException;

    private static native int link(String var0, String var1) throws LastErrorException;

    public static native int fcntl(int var0, int var1, long var2) throws LastErrorException;

    public static native int posix_fadvise(int var0, long var1, int var3, int var4) throws LastErrorException;

    public static native int open(String var0, int var1) throws LastErrorException;

    public static native int fsync(int var0) throws LastErrorException;

    public static native int close(int var0) throws LastErrorException;

    private static int errno(RuntimeException e) {
        assert (e instanceof LastErrorException);
        try {
            return ((LastErrorException)e).getErrorCode();
        }
        catch (NoSuchMethodError x) {
            logger.warn("Obsolete version of JNA present; unable to read errno. Upgrade to JNA 3.2.7 or later");
            return 0;
        }
    }

    private CLibrary() {
    }

    public static boolean jnaAvailable() {
        return jnaAvailable;
    }

    public static boolean jnaMemoryLockable() {
        return jnaLockable;
    }

    public static void tryMlockall() {
        block5: {
            try {
                CLibrary.mlockall(1);
                jnaLockable = true;
                logger.info("JNA mlockall successful");
            }
            catch (UnsatisfiedLinkError e) {
            }
            catch (RuntimeException e) {
                if (!(e instanceof LastErrorException)) {
                    throw e;
                }
                if (CLibrary.errno(e) == 12 && System.getProperty("os.name").toLowerCase().contains("linux")) {
                    logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out, especially with mmapped I/O enabled. Increase RLIMIT_MEMLOCK or run Cassandra as root.");
                }
                if (System.getProperty("os.name").toLowerCase().contains("mac")) break block5;
                logger.warn("Unknown mlockall error " + CLibrary.errno(e));
            }
        }
    }

    public static void createHardLink(File sourceFile, File destinationFile) throws IOException {
        try {
            CLibrary.link(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError e) {
            CLibrary.createHardLinkWithExec(sourceFile, destinationFile);
        }
        catch (RuntimeException e) {
            logger.error("Unable to create hard link", (Throwable)e);
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            throw new IOException(String.format("Unable to create hard link from %s to %s (errno %d)", sourceFile, destinationFile, CLibrary.errno(e)));
        }
    }

    public static void createHardLinkWithExec(File sourceFile, File destinationFile) throws IOException {
        ProcessBuilder pb;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            float osversion = Float.parseFloat(System.getProperty("os.version"));
            pb = osversion >= 6.0f ? new ProcessBuilder("cmd", "/c", "mklink", "/H", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath()) : new ProcessBuilder("fsutil", "hardlink", "create", destinationFile.getAbsolutePath(), sourceFile.getAbsolutePath());
        } else {
            pb = new ProcessBuilder("ln", sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath());
            pb.redirectErrorStream(true);
        }
        try {
            FBUtilities.exec(pb);
        }
        catch (IOException ex) {
            String st = osname.startsWith("Windows") ? "Unable to create hard link.  This probably means your data directory path is too long.  Exception follows:" : "Unable to create hard link with exec.  Suggest installing JNA to avoid the need to exec entirely.  Exception follows: ";
            logger.error(st, (Throwable)ex);
            throw ex;
        }
    }

    public static void trySkipCache(int fd, long offset, int len) {
        if (fd < 0) {
            return;
        }
        try {
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                CLibrary.posix_fadvise(fd, offset, len, 4);
            }
        }
        catch (UnsatisfiedLinkError e) {
            // empty catch block
        }
    }

    public static int tryFcntl(int fd, int command, int flags) {
        int result = -1;
        try {
            result = CLibrary.fcntl(fd, command, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("fcntl(%d, %d, %d) failed, errno (%d).", fd, command, flags, CLibrary.errno(e)));
        }
        return result;
    }

    public static int tryOpenDirectory(String path) {
        int fd = -1;
        try {
            return CLibrary.open(path, 0);
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("open(%s, O_RDONLY) failed, errno (%d).", path, CLibrary.errno(e)));
        }
        return fd;
    }

    public static void trySync(int fd) {
        if (fd == -1) {
            return;
        }
        try {
            CLibrary.fsync(fd);
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("fsync(%d) failed, errno (%d).", fd, CLibrary.errno(e)));
        }
    }

    public static void tryCloseFD(int fd) {
        if (fd == -1) {
            return;
        }
        try {
            CLibrary.close(fd);
        }
        catch (UnsatisfiedLinkError e) {
        }
        catch (RuntimeException e) {
            if (!(e instanceof LastErrorException)) {
                throw e;
            }
            logger.warn(String.format("close(%d) failed, errno (%d).", fd, CLibrary.errno(e)));
        }
    }

    public static int getfd(FileDescriptor descriptor) {
        Field field = FBUtilities.getProtectedField(descriptor.getClass(), "fd");
        if (field == null) {
            return -1;
        }
        try {
            return field.getInt(descriptor);
        }
        catch (Exception e) {
            logger.warn("unable to read fd field from FileDescriptor");
            return -1;
        }
    }

    static {
        try {
            Native.register((String)"c");
            jnaAvailable = true;
        }
        catch (NoClassDefFoundError e) {
            logger.info("JNA not found. Native methods will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.info("JNA link failure, one or more native method will be unavailable.");
            logger.debug("JNA link failure details: " + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            logger.warn("Obsolete version of JNA present; unable to register C library. Upgrade to JNA 3.2.7 or later");
        }
    }
}

