/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.UUIDSerializer;

public class StreamReply {
    public static final IVersionedSerializer<StreamReply> serializer = new FileStatusSerializer();
    public final UUID sessionId;
    public final String file;
    public final Status action;

    public StreamReply(String file, UUID sessionId, Status action) {
        this.file = file;
        this.action = action;
        this.sessionId = sessionId;
    }

    public MessageOut<StreamReply> createMessage() {
        return new MessageOut<StreamReply>(MessagingService.Verb.STREAM_REPLY, this, serializer);
    }

    public String toString() {
        return "StreamReply(sessionId=" + this.sessionId + ", file='" + this.file + '\'' + ", action=" + (Object)((Object)this.action) + ')';
    }

    private static class FileStatusSerializer
    implements IVersionedSerializer<StreamReply> {
        private FileStatusSerializer() {
        }

        @Override
        public void serialize(StreamReply reply, DataOutput dos, int version) throws IOException {
            UUIDSerializer.serializer.serialize(reply.sessionId, dos, 6);
            dos.writeUTF(reply.file);
            dos.writeInt(reply.action.ordinal());
        }

        @Override
        public StreamReply deserialize(DataInput dis, int version) throws IOException {
            UUID sessionId = UUIDSerializer.serializer.deserialize(dis, 6);
            String targetFile = dis.readUTF();
            Status action = Status.values()[dis.readInt()];
            return new StreamReply(targetFile, sessionId, action);
        }

        @Override
        public long serializedSize(StreamReply reply, int version) {
            return TypeSizes.NATIVE.sizeof(reply.sessionId) + TypeSizes.NATIVE.sizeof(reply.file) + TypeSizes.NATIVE.sizeof(reply.action.ordinal());
        }
    }

    static enum Status {
        FILE_FINISHED,
        FILE_RETRY,
        SESSION_FINISHED,
        SESSION_FAILURE;

    }
}

