/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandoffMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintedHandoffMetrics.class);
    private final MetricNameFactory factory;
    private final LoadingCache<InetAddress, DifferencingCounter> notStored = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<InetAddress, DifferencingCounter>(){

        public DifferencingCounter load(InetAddress address) {
            return new DifferencingCounter(address);
        }
    });

    public HintedHandoffMetrics() {
        this.factory = new DefaultNameFactory("HintedHandOffManager");
    }

    public void incrPastWindow(InetAddress address) {
        try {
            ((DifferencingCounter)this.notStored.get((Object)address)).mark();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void log() {
        for (Map.Entry entry : this.notStored.asMap().entrySet()) {
            long diffrence = ((DifferencingCounter)entry.getValue()).diffrence();
            if (diffrence == 0L) continue;
            logger.warn("{} has {} dropped hints, because node is down past configured hint window.", entry.getKey(), (Object)diffrence);
            SystemTable.updateHintsDropped((InetAddress)entry.getKey(), UUIDGen.getTimeUUID(), (int)diffrence);
        }
    }

    public class DifferencingCounter {
        private final Counter meter;
        private long reported = 0L;

        public DifferencingCounter(InetAddress address) {
            this.meter = Metrics.newCounter((MetricName)HintedHandoffMetrics.this.factory.createMetricName("Hints_not_stored-" + address.toString()));
        }

        public long diffrence() {
            long current = this.meter.count();
            long diffrence = current - this.reported;
            this.reported = current;
            return diffrence;
        }

        public long count() {
            return this.meter.count();
        }

        public void mark() {
            this.meter.inc();
        }
    }
}

