/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import org.apache.cassandra.db.commitlog.CommitLogAllocator;
import org.apache.cassandra.db.commitlog.ICommitLogExecutorService;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class CommitLogMetrics {
    public static final MetricNameFactory factory = new DefaultNameFactory("CommitLog");
    public final Gauge<Long> completedTasks;
    public final Gauge<Long> pendingTasks;
    public final Gauge<Long> totalCommitLogSize;

    public CommitLogMetrics(final ICommitLogExecutorService executor, final CommitLogAllocator allocator) {
        this.completedTasks = Metrics.newGauge((MetricName)factory.createMetricName("CompletedTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getCompletedTasks();
            }
        });
        this.pendingTasks = Metrics.newGauge((MetricName)factory.createMetricName("PendingTasks"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return executor.getPendingTasks();
            }
        });
        this.totalCommitLogSize = Metrics.newGauge((MetricName)factory.createMetricName("TotalCommitLogSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return allocator.bytesUsed();
            }
        });
    }
}

