/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.ISSTableColumnIterator;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SSTableSliceIterator;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryFilter
implements IDiskAtomFilter {
    private static final Logger logger = LoggerFactory.getLogger(SliceQueryFilter.class);
    public static final Serializer serializer = new Serializer();
    public final ColumnSlice[] slices;
    public final boolean reversed;
    public volatile int count;
    private final int compositesToGroup;
    private final int countMutliplierForCompatibility;
    private ColumnCounter columnCounter;

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        this(new ColumnSlice[]{new ColumnSlice(start, finish)}, reversed, count);
    }

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count, int compositesToGroup) {
        this(new ColumnSlice[]{new ColumnSlice(start, finish)}, reversed, count, compositesToGroup, 1);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count) {
        this(slices, reversed, count, -1, 1);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count, int compositesToGroup, int countMutliplierForCompatibility) {
        this.slices = slices;
        this.reversed = reversed;
        this.count = count;
        this.compositesToGroup = compositesToGroup;
        this.countMutliplierForCompatibility = countMutliplierForCompatibility;
    }

    public SliceQueryFilter withUpdatedCount(int newCount) {
        return new SliceQueryFilter(this.slices, this.reversed, newCount, this.compositesToGroup, this.countMutliplierForCompatibility);
    }

    public SliceQueryFilter withUpdatedSlices(ColumnSlice[] newSlices) {
        return new SliceQueryFilter(newSlices, this.reversed, this.count, this.compositesToGroup, this.countMutliplierForCompatibility);
    }

    @Override
    public OnDiskAtomIterator getMemtableColumnIterator(ColumnFamily cf, DecoratedKey key) {
        return Memtable.getSliceIterator(key, cf, this);
    }

    @Override
    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableSliceIterator(sstable, key, this.slices, this.reversed);
    }

    @Override
    public ISSTableColumnIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return new SSTableSliceIterator(sstable, file, key, this.slices, this.reversed, indexEntry);
    }

    @Override
    public SuperColumn filterSuperColumn(SuperColumn superColumn, int gcBefore) {
        Iterator<IColumn> subcolumns;
        SuperColumn scFiltered = superColumn.cloneMeShallow();
        if (this.reversed) {
            ArrayList<IColumn> columnsAsList = new ArrayList<IColumn>(superColumn.getSubColumns());
            subcolumns = Lists.reverse(columnsAsList).iterator();
        } else {
            subcolumns = superColumn.getSubColumns().iterator();
        }
        final Comparator<ByteBuffer> comparator = this.reversed ? superColumn.getComparator().reverseComparator : superColumn.getComparator();
        AbstractIterator<IColumn> results = new AbstractIterator<IColumn>(){

            protected IColumn computeNext() {
                while (subcolumns.hasNext()) {
                    IColumn subcolumn = (IColumn)subcolumns.next();
                    if (comparator.compare(subcolumn.name(), SliceQueryFilter.this.start()) < 0) continue;
                    if (SliceQueryFilter.this.finish().remaining() > 0 && comparator.compare(subcolumn.name(), SliceQueryFilter.this.finish()) > 0) break;
                    return subcolumn;
                }
                return (IColumn)this.endOfData();
            }
        };
        this.collectReducedColumns(scFiltered, (Iterator<IColumn>)results, gcBefore);
        return scFiltered;
    }

    @Override
    public Comparator<IColumn> getColumnComparator(AbstractType<?> comparator) {
        return this.reversed ? comparator.columnReverseComparator : comparator.columnComparator;
    }

    @Override
    public void collectReducedColumns(IColumnContainer container, Iterator<IColumn> reducedColumns, int gcBefore) {
        this.columnCounter = this.getColumnCounter(container);
        while (reducedColumns.hasNext()) {
            IColumn column = reducedColumns.next();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("collecting %s of %s: %s", this.columnCounter.live(), this.count, column.getString(container.getComparator())));
            }
            this.columnCounter.count(column, container);
            if (this.columnCounter.live() > this.count) break;
            if (!QueryFilter.isRelevant(column, container, gcBefore)) continue;
            container.addColumn(column);
        }
        Tracing.trace("Read {} live and {} tombstoned cells", this.columnCounter.live(), this.columnCounter.ignored());
        if (this.columnCounter.ignored() > DatabaseDescriptor.getTombstoneDebugThreshold()) {
            logger.debug("Read {} live and {} tombstoned cells", (Object)this.columnCounter.live(), (Object)this.columnCounter.ignored());
        }
    }

    @Override
    public int getLiveCount(ColumnFamily cf) {
        ColumnCounter counter = this.getColumnCounter(cf);
        for (IColumn column : cf) {
            counter.count(column, cf);
        }
        return counter.live();
    }

    private ColumnCounter getColumnCounter(IColumnContainer container) {
        AbstractType<?> comparator = container.getComparator();
        if (this.compositesToGroup < 0) {
            return new ColumnCounter();
        }
        if (this.compositesToGroup == 0) {
            return new ColumnCounter.GroupByPrefix(null, 0);
        }
        return new ColumnCounter.GroupByPrefix((CompositeType)comparator, this.compositesToGroup);
    }

    public void trim(ColumnFamily cf, int trimTo) {
        ColumnCounter counter = this.getColumnCounter(cf);
        HashSet<ByteBuffer> toRemove = null;
        boolean trimRemaining = false;
        Collection<IColumn> columns = this.reversed ? cf.getReverseSortedColumns() : cf.getSortedColumns();
        for (IColumn column : columns) {
            if (trimRemaining) {
                toRemove.add(column.name());
                continue;
            }
            counter.count(column, cf);
            if (counter.live() <= trimTo) continue;
            toRemove = new HashSet<ByteBuffer>();
            toRemove.add(column.name());
            trimRemaining = true;
        }
        if (toRemove != null) {
            for (ByteBuffer columnName : toRemove) {
                cf.remove(columnName);
            }
        }
    }

    public ByteBuffer start() {
        return this.slices[0].start;
    }

    public ByteBuffer finish() {
        return this.slices[this.slices.length - 1].finish;
    }

    public void setStart(ByteBuffer start) {
        assert (this.slices.length == 1);
        this.slices[0] = new ColumnSlice(start, this.slices[0].finish);
    }

    public int lastCounted() {
        return this.columnCounter == null ? 0 : this.columnCounter.live();
    }

    public int lastIgnored() {
        return this.columnCounter == null ? 0 : this.columnCounter.ignored();
    }

    public int lastLive() {
        return this.columnCounter == null ? 0 : this.columnCounter.live();
    }

    public String toString() {
        return "SliceQueryFilter [reversed=" + this.reversed + ", slices=" + Arrays.toString(this.slices) + ", count=" + this.count + ", toGroup = " + this.compositesToGroup + "]";
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
        this.count = newLimit;
    }

    public boolean includes(Comparator<ByteBuffer> cmp, ByteBuffer name) {
        for (ColumnSlice slice : this.slices) {
            if (!slice.includes(cmp, name)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements IVersionedSerializer<SliceQueryFilter> {
        @Override
        public void serialize(SliceQueryFilter f, DataOutput dos, int version) throws IOException {
            if (version < 6) {
                ColumnSlice slice = new ColumnSlice(f.start(), f.finish());
                ColumnSlice.serializer.serialize(slice, dos, version);
            } else {
                dos.writeInt(f.slices.length);
                for (ColumnSlice slice : f.slices) {
                    ColumnSlice.serializer.serialize(slice, dos, version);
                }
            }
            dos.writeBoolean(f.reversed);
            int count = f.count;
            if (f.compositesToGroup > 0 && version < 6) {
                count *= f.countMutliplierForCompatibility;
            }
            dos.writeInt(count);
            if (version < 6) {
                return;
            }
            dos.writeInt(f.compositesToGroup);
        }

        @Override
        public SliceQueryFilter deserialize(DataInput dis, int version) throws IOException {
            ColumnSlice[] slices;
            if (version < 6) {
                slices = new ColumnSlice[]{ColumnSlice.serializer.deserialize(dis, version)};
            } else {
                slices = new ColumnSlice[dis.readInt()];
                for (int i = 0; i < slices.length; ++i) {
                    slices[i] = ColumnSlice.serializer.deserialize(dis, version);
                }
            }
            boolean reversed = dis.readBoolean();
            int count = dis.readInt();
            int compositesToGroup = -1;
            if (version >= 6) {
                compositesToGroup = dis.readInt();
            }
            return new SliceQueryFilter(slices, reversed, count, compositesToGroup, 1);
        }

        @Override
        public long serializedSize(SliceQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = 0;
            if (version < 6) {
                size = (int)((long)size + ColumnSlice.serializer.serializedSize(new ColumnSlice(f.start(), f.finish()), version));
            } else {
                size += sizes.sizeof(f.slices.length);
                for (ColumnSlice slice : f.slices) {
                    size = (int)((long)size + ColumnSlice.serializer.serializedSize(slice, version));
                }
            }
            size += sizes.sizeof(f.reversed);
            size += sizes.sizeof(f.count);
            if (version >= 6) {
                size += sizes.sizeof(f.compositesToGroup);
            }
            return size;
        }
    }
}

