/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.cassandra.db.AbstractThreadUnsafeSortedColumns;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public class ArrayBackedSortedColumns
extends AbstractThreadUnsafeSortedColumns
implements ISortedColumns {
    private final AbstractType<?> comparator;
    private final boolean reversed;
    private final ArrayList<IColumn> columns;
    public static final ISortedColumns.Factory factory = new ISortedColumns.Factory(){

        @Override
        public ISortedColumns create(AbstractType<?> comparator, boolean insertReversed) {
            return new ArrayBackedSortedColumns(comparator, insertReversed);
        }

        @Override
        public ISortedColumns fromSorted(SortedMap<ByteBuffer, IColumn> sortedMap, boolean insertReversed) {
            return new ArrayBackedSortedColumns(sortedMap.values(), (AbstractType)sortedMap.comparator(), insertReversed);
        }
    };

    public static ISortedColumns.Factory factory() {
        return factory;
    }

    private ArrayBackedSortedColumns(AbstractType<?> comparator, boolean reversed) {
        this.comparator = comparator;
        this.reversed = reversed;
        this.columns = new ArrayList();
    }

    private ArrayBackedSortedColumns(Collection<IColumn> columns, AbstractType<?> comparator, boolean reversed) {
        this.comparator = comparator;
        this.reversed = reversed;
        this.columns = new ArrayList<IColumn>(columns);
    }

    @Override
    public ISortedColumns.Factory getFactory() {
        return ArrayBackedSortedColumns.factory();
    }

    @Override
    public AbstractType<?> getComparator() {
        return this.comparator;
    }

    @Override
    public ISortedColumns cloneMe() {
        return new ArrayBackedSortedColumns(this.columns, this.comparator, this.reversed);
    }

    @Override
    public boolean isInsertReversed() {
        return this.reversed;
    }

    private Comparator<ByteBuffer> internalComparator() {
        return this.reversed ? this.comparator.reverseComparator : this.comparator;
    }

    @Override
    public IColumn getColumn(ByteBuffer name) {
        int pos = this.binarySearch(name);
        return pos >= 0 ? this.columns.get(pos) : null;
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        if (this.columns.isEmpty()) {
            this.columns.add(column);
            return;
        }
        int c = this.internalComparator().compare(this.columns.get(this.size() - 1).name(), column.name());
        assert (c <= 0) : "Added column does not sort as the " + (this.reversed ? "first" : "last") + " column";
        if (c < 0) {
            this.columns.add(column);
        } else if (c == 0) {
            this.resolveAgainst(this.size() - 1, column, allocator);
        } else {
            int pos = this.binarySearch(column.name());
            if (pos >= 0) {
                this.resolveAgainst(pos, column, allocator);
            } else {
                this.columns.add(-pos - 1, column);
            }
        }
    }

    private void resolveAgainst(int i, IColumn column, Allocator allocator) {
        IColumn oldColumn = this.columns.get(i);
        if (oldColumn instanceof SuperColumn) {
            assert (column instanceof SuperColumn);
            ((SuperColumn)oldColumn).putColumn((SuperColumn)column, allocator);
        } else {
            IColumn reconciledColumn = column.reconcile(oldColumn, allocator);
            this.columns.set(i, reconciledColumn);
        }
    }

    private int binarySearch(ByteBuffer name) {
        return ArrayBackedSortedColumns.binarySearch(this.columns, this.internalComparator(), name, 0);
    }

    private static int binarySearch(List<IColumn> columns, Comparator<ByteBuffer> comparator, ByteBuffer name, int start) {
        int low = start;
        int mid = columns.size();
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = comparator.compare(name, columns.get(mid).name());
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    @Override
    public long addAllWithSizeDelta(ISortedColumns cm, Allocator allocator, Function<IColumn, IColumn> transformation, SecondaryIndexManager.Updater indexer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addAll(ISortedColumns cm, Allocator allocator, Function<IColumn, IColumn> transformation) {
        this.delete(cm.getDeletionInfo());
        if (cm.isEmpty()) {
            return;
        }
        IColumn[] copy = this.columns.toArray(new IColumn[this.size()]);
        int idx = 0;
        Iterator<Object> other = this.reversed ? cm.reverseIterator(ColumnSlice.ALL_COLUMNS_ARRAY) : cm.iterator();
        IColumn otherColumn = (IColumn)other.next();
        this.columns.clear();
        while (idx < copy.length && otherColumn != null) {
            int c = this.internalComparator().compare(copy[idx].name(), otherColumn.name());
            if (c < 0) {
                this.columns.add(copy[idx]);
                ++idx;
                continue;
            }
            if (c > 0) {
                this.columns.add((IColumn)transformation.apply((Object)otherColumn));
                otherColumn = other.hasNext() ? (IColumn)other.next() : null;
                continue;
            }
            this.columns.add(copy[idx]);
            this.resolveAgainst(this.size() - 1, (IColumn)transformation.apply((Object)otherColumn), allocator);
            ++idx;
            otherColumn = other.hasNext() ? (IColumn)other.next() : null;
        }
        while (idx < copy.length) {
            this.columns.add(copy[idx++]);
        }
        while (otherColumn != null) {
            this.columns.add((IColumn)transformation.apply((Object)otherColumn));
            otherColumn = other.hasNext() ? (IColumn)other.next() : null;
        }
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        if (!oldColumn.name().equals(newColumn.name())) {
            throw new IllegalArgumentException();
        }
        int pos = this.binarySearch(oldColumn.name());
        if (pos >= 0) {
            this.columns.set(pos, newColumn);
        }
        return pos >= 0;
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.reversed ? new ReverseSortedCollection() : this.columns;
    }

    @Override
    public Collection<IColumn> getReverseSortedColumns() {
        return this.reversed ? new ForwardSortedCollection() : new ReverseSortedCollection();
    }

    @Override
    public void removeColumn(ByteBuffer name) {
        int pos = this.binarySearch(name);
        if (pos >= 0) {
            this.columns.remove(pos);
        }
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public void clear() {
        this.setDeletionInfo(DeletionInfo.live());
        this.columns.clear();
    }

    @Override
    public SortedSet<ByteBuffer> getColumnNames() {
        return new ColumnNamesSet();
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.reversed ? Lists.reverse(this.columns).iterator() : this.columns.iterator();
    }

    @Override
    public Iterator<IColumn> iterator(ColumnSlice[] slices) {
        return new SlicesIterator(this.columns, this.comparator, slices, this.reversed);
    }

    @Override
    public Iterator<IColumn> reverseIterator(ColumnSlice[] slices) {
        return new SlicesIterator(this.columns, this.comparator, slices, !this.reversed);
    }

    private class ColumnNamesSet
    extends AbstractSet<ByteBuffer>
    implements SortedSet<ByteBuffer> {
        private ColumnNamesSet() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.columns.size();
        }

        @Override
        public Iterator<ByteBuffer> iterator() {
            final Iterator<IColumn> outerIterator = ArrayBackedSortedColumns.this.iterator();
            return new Iterator<ByteBuffer>(){

                @Override
                public boolean hasNext() {
                    return outerIterator.hasNext();
                }

                @Override
                public ByteBuffer next() {
                    return ((IColumn)outerIterator.next()).name();
                }

                @Override
                public void remove() {
                    outerIterator.remove();
                }
            };
        }

        @Override
        public Comparator<ByteBuffer> comparator() {
            return ArrayBackedSortedColumns.this.getComparator();
        }

        @Override
        public ByteBuffer first() {
            ArrayBackedSortedColumns outerList = ArrayBackedSortedColumns.this;
            if (outerList.isEmpty()) {
                throw new NoSuchElementException();
            }
            return ((IColumn)outerList.columns.get(outerList.reversed ? this.size() - 1 : 0)).name();
        }

        @Override
        public ByteBuffer last() {
            ArrayBackedSortedColumns outerList = ArrayBackedSortedColumns.this;
            if (outerList.isEmpty()) {
                throw new NoSuchElementException();
            }
            return ((IColumn)outerList.columns.get(outerList.reversed ? 0 : this.size() - 1)).name();
        }

        @Override
        public SortedSet<ByteBuffer> headSet(ByteBuffer fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<ByteBuffer> tailSet(ByteBuffer toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedSet<ByteBuffer> subSet(ByteBuffer fromElement, ByteBuffer toElement) {
            throw new UnsupportedOperationException();
        }
    }

    private class ForwardSortedCollection
    extends AbstractCollection<IColumn> {
        private ForwardSortedCollection() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.columns.size();
        }

        @Override
        public Iterator<IColumn> iterator() {
            return ArrayBackedSortedColumns.this.columns.iterator();
        }
    }

    private class ReverseSortedCollection
    extends AbstractCollection<IColumn> {
        private ReverseSortedCollection() {
        }

        @Override
        public int size() {
            return ArrayBackedSortedColumns.this.columns.size();
        }

        @Override
        public Iterator<IColumn> iterator() {
            return new Iterator<IColumn>(){
                int idx;
                {
                    this.idx = ReverseSortedCollection.this.size() - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.idx >= 0;
                }

                @Override
                public IColumn next() {
                    return (IColumn)ArrayBackedSortedColumns.this.columns.get(this.idx--);
                }

                @Override
                public void remove() {
                    ArrayBackedSortedColumns.this.columns.remove(this.idx--);
                }
            };
        }
    }

    private static class SlicesIterator
    extends AbstractIterator<IColumn> {
        private final List<IColumn> list;
        private final ColumnSlice[] slices;
        private final Comparator<ByteBuffer> comparator;
        private int idx = 0;
        private int previousSliceEnd = 0;
        private Iterator<IColumn> currentSlice;

        public SlicesIterator(List<IColumn> list, AbstractType<?> comparator, ColumnSlice[] slices, boolean reversed) {
            this.list = reversed ? Lists.reverse(list) : list;
            this.slices = slices;
            this.comparator = reversed ? comparator.reverseComparator : comparator;
        }

        protected IColumn computeNext() {
            if (this.currentSlice == null) {
                int finishIdx;
                int startIdx;
                if (this.idx >= this.slices.length) {
                    return (IColumn)this.endOfData();
                }
                ColumnSlice slice = this.slices[this.idx++];
                int n = startIdx = slice.start.remaining() == 0 ? 0 : ArrayBackedSortedColumns.binarySearch(this.list, this.comparator, slice.start, this.previousSliceEnd);
                if (startIdx < 0) {
                    startIdx = -startIdx - 1;
                }
                int n2 = finishIdx = slice.finish.remaining() == 0 ? this.list.size() - 1 : ArrayBackedSortedColumns.binarySearch(this.list, this.comparator, slice.finish, this.previousSliceEnd);
                finishIdx = finishIdx >= 0 ? ++finishIdx : -finishIdx - 1;
                this.currentSlice = startIdx == 0 && finishIdx == this.list.size() ? this.list.iterator() : this.list.subList(startIdx, finishIdx).iterator();
                int n3 = this.previousSliceEnd = finishIdx > 0 ? finishIdx - 1 : 0;
            }
            if (this.currentSlice.hasNext()) {
                return this.currentSlice.next();
            }
            this.currentSlice = null;
            return this.computeNext();
        }
    }
}

