/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.utils;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TestUtils {
    public static ColumnFamily<String, String> CF_COLUMN_RANGE_TEST = ColumnFamily.newColumnFamily((String)"columnrange", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get(), (Serializer)IntegerSerializer.get());

    public static List<TestTokenRange> getTestTokenRanges() {
        ArrayList<TestTokenRange> tokenRanges = new ArrayList<TestTokenRange>();
        tokenRanges.add(new TestTokenRange("-8692134701444027338", "-7912594386904524724", "C", "T", "M"));
        tokenRanges.add(new TestTokenRange("-7311855499978618814", "-4942250469937744623", "X", "J", "W"));
        tokenRanges.add(new TestTokenRange("-4837624800923759386", "-2875471597373478633", "B", "H", "K"));
        tokenRanges.add(new TestTokenRange("-1884162317724288694", "-422884050476930919", "O", "Q", "Y"));
        tokenRanges.add(new TestTokenRange("-300136452241384611", "243126998722523514", "L", "P", "A"));
        tokenRanges.add(new TestTokenRange("576608558731393772", "3625209262381227179", "V", "G", "F"));
        tokenRanges.add(new TestTokenRange("3846318681772828433", "4834152074310082538", "R", "N", "I"));
        tokenRanges.add(new TestTokenRange("4943864740760620945", "8086064298967168788", "S", "E", "Z"));
        tokenRanges.add(new TestTokenRange("8889191829175541774", "9176724567785656400", "D", "U"));
        return tokenRanges;
    }

    public static void createColumnFamilyForColumnRange(Keyspace keyspace) throws Exception {
        keyspace.createColumnFamily(CF_COLUMN_RANGE_TEST, null);
    }

    public static void populateRowsForColumnRange(Keyspace keyspace) throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String rowKey = Character.toString(keyName);
            ColumnListMutation colMutation = m.withRow(CF_COLUMN_RANGE_TEST, (Object)rowKey);
            for (char cName = 'a'; cName <= 'z'; cName = (char)(cName + '\u0001')) {
                colMutation.putColumn((Object)Character.toString(cName), cName - 97 + 1, null);
            }
            m.withCaching(true);
            m.execute();
            m.discardMutations();
        }
    }

    public static void deleteRowsForColumnRange(Keyspace keyspace) throws Exception {
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            MutationBatch m = keyspace.prepareMutationBatch();
            String rowKey = Character.toString(keyName);
            m.withRow(CF_COLUMN_RANGE_TEST, (Object)rowKey).delete();
            m.execute();
            m.discardMutations();
        }
    }

    public static class TestTokenRange {
        public String startToken;
        public String endToken;
        public List<String> expectedRowKeys = new ArrayList<String>();

        public TestTokenRange(String start, String end, String ... expectedKeys) {
            this.startToken = start;
            this.endToken = end;
            this.expectedRowKeys.addAll(Arrays.asList(expectedKeys));
        }
    }
}

