/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.cql.test.utils.ReadTests;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SingleRowQueryTests
extends ReadTests {
    private int TestRowCount = 10;

    @BeforeClass
    public static void init() throws Exception {
        SingleRowQueryTests.initContext();
        keyspace.createColumnFamily(CF_USER_INFO, null);
        CF_USER_INFO.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_USER_INFO);
    }

    @Test
    public void runAllTests() throws Exception {
        this.populateRows(this.TestRowCount);
        Thread.sleep(1000L);
        boolean rowDeleted = false;
        this.testSingleRowAllColumnsQuery(rowDeleted);
        this.testSingleRowSingleColumnQuery(rowDeleted);
        this.testSingleRowColumnSliceQueryWithCollection(rowDeleted);
        this.testSingleRowColumnSliceQueryVarArgs(rowDeleted);
        this.testSingleRowAllColumnsColumnCountQuery(rowDeleted);
        this.testSingleRowColumnSliceCollectionColumnCountQuery(rowDeleted);
        this.testSingleRowColumnSliceVarArgsColumnCountQuery(rowDeleted);
        this.deleteRows(this.TestRowCount);
        Thread.sleep(1000L);
        rowDeleted = true;
        this.testSingleRowAllColumnsQuery(rowDeleted);
        this.testSingleRowSingleColumnQuery(rowDeleted);
        this.testSingleRowColumnSliceQueryWithCollection(rowDeleted);
        this.testSingleRowColumnSliceQueryVarArgs(rowDeleted);
        this.testSingleRowAllColumnsColumnCountQuery(rowDeleted);
        this.testSingleRowColumnSliceCollectionColumnCountQuery(rowDeleted);
        this.testSingleRowColumnSliceVarArgsColumnCountQuery(rowDeleted);
    }

    private void testSingleRowAllColumnsQuery(boolean rowDeleted) throws Exception {
        String[] arr = new String[]{"firstname", "lastname", "address", "age", "ageShort", "ageLong", "percentile", "married", "single", "birthdate", "bytes", "uuid", "empty"};
        ArrayList<String> columnNames = new ArrayList<String>(Arrays.asList(arr));
        Collections.sort(columnNames);
        for (int i = 0; i < this.TestRowCount; ++i) {
            ColumnList response = (ColumnList)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)response.isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)response.isEmpty());
            ArrayList columnNameList = new ArrayList(response.getColumnNames());
            Collections.sort(columnNameList);
            Assert.assertEquals(columnNames, columnNameList);
            Date date = OriginalDate.plusMinutes(i).toDate();
            this.testColumnValue((ColumnList<String>)response, "firstname", columnNames, "john_" + i);
            this.testColumnValue((ColumnList<String>)response, "lastname", columnNames, "smith_" + i);
            this.testColumnValue((ColumnList<String>)response, "address", columnNames, "john smith address " + i);
            this.testColumnValue((ColumnList<String>)response, "age", columnNames, 30 + i);
            this.testColumnValue((ColumnList<String>)response, "ageShort", columnNames, new Integer(30 + i).shortValue());
            this.testColumnValue((ColumnList<String>)response, "ageLong", columnNames, new Integer(30 + i).longValue());
            this.testColumnValue((ColumnList<String>)response, "percentile", columnNames, 30.1);
            this.testColumnValue((ColumnList<String>)response, "married", columnNames, true);
            this.testColumnValue((ColumnList<String>)response, "single", columnNames, false);
            this.testColumnValue((ColumnList<String>)response, "birthdate", columnNames, date);
            this.testColumnValue((ColumnList<String>)response, "bytes", columnNames, TestBytes);
            this.testColumnValue((ColumnList<String>)response, "uuid", columnNames, TestUUID);
            this.testColumnValue((ColumnList<String>)response, "empty", columnNames, null);
            Iterator iter = response.iterator();
            Iterator columnNameIter = columnNames.iterator();
            while (iter.hasNext()) {
                Column col = (Column)iter.next();
                String columnName = (String)columnNameIter.next();
                Assert.assertEquals((String)columnName, (String)((String)col.getName()));
            }
        }
    }

    private void testSingleRowSingleColumnQuery(boolean rowDeleted) throws Exception {
        for (int i = 0; i < this.TestRowCount; ++i) {
            Date date = OriginalDate.plusMinutes(i).toDate();
            Column column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"firstname").execute().getResult();
            if (rowDeleted) {
                Assert.assertNull((Object)column);
                continue;
            }
            Assert.assertTrue((boolean)column.hasValue());
            this.testColumnValue((Column<String>)column, "john_" + i);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"lastname").execute().getResult();
            this.testColumnValue((Column<String>)column, "smith_" + i);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"address").execute().getResult();
            this.testColumnValue((Column<String>)column, "john smith address " + i);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"age").execute().getResult();
            this.testColumnValue((Column<String>)column, 30 + i);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"ageShort").execute().getResult();
            this.testColumnValue((Column<String>)column, new Integer(30 + i).shortValue());
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"ageLong").execute().getResult();
            this.testColumnValue((Column<String>)column, new Integer(30 + i).longValue());
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"percentile").execute().getResult();
            this.testColumnValue((Column<String>)column, 30.1);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"married").execute().getResult();
            this.testColumnValue((Column<String>)column, true);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"single").execute().getResult();
            this.testColumnValue((Column<String>)column, false);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"birthdate").execute().getResult();
            this.testColumnValue((Column<String>)column, date);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"bytes").execute().getResult();
            this.testColumnValue((Column<String>)column, TestBytes);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"uuid").execute().getResult();
            this.testColumnValue((Column<String>)column, TestUUID);
            column = (Column)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getColumn((Object)"empty").execute().getResult();
            this.testColumnValue((Column<String>)column, null);
        }
    }

    private void testSingleRowColumnSliceQueryWithCollection(boolean rowDeleted) throws Exception {
        for (int i = 0; i < this.TestRowCount; ++i) {
            Date date = OriginalDate.plusMinutes(i).toDate();
            ColumnList response = (ColumnList)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).withColumnSlice((Collection)columnNames).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)response.isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)response.isEmpty());
            this.testColumnValue((ColumnList<String>)response, "firstname", columnNames, "john_" + i);
            this.testColumnValue((ColumnList<String>)response, "lastname", columnNames, "smith_" + i);
            this.testColumnValue((ColumnList<String>)response, "address", columnNames, "john smith address " + i);
            this.testColumnValue((ColumnList<String>)response, "age", columnNames, 30 + i);
            this.testColumnValue((ColumnList<String>)response, "ageShort", columnNames, new Integer(30 + i).shortValue());
            this.testColumnValue((ColumnList<String>)response, "ageLong", columnNames, new Integer(30 + i).longValue());
            this.testColumnValue((ColumnList<String>)response, "percentile", columnNames, 30.1);
            this.testColumnValue((ColumnList<String>)response, "married", columnNames, true);
            this.testColumnValue((ColumnList<String>)response, "single", columnNames, false);
            this.testColumnValue((ColumnList<String>)response, "birthdate", columnNames, date);
            this.testColumnValue((ColumnList<String>)response, "bytes", columnNames, TestBytes);
            this.testColumnValue((ColumnList<String>)response, "uuid", columnNames, TestUUID);
            this.testColumnValue((ColumnList<String>)response, "empty", columnNames, null);
        }
    }

    private void testSingleRowColumnSliceQueryVarArgs(boolean rowDeleted) throws Exception {
        for (int i = 0; i < this.TestRowCount; ++i) {
            Date date = OriginalDate.plusMinutes(i).toDate();
            ColumnList response = (ColumnList)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).withColumnSlice((Object[])new String[]{"firstname", "lastname", "address", "age", "ageShort", "ageLong", "percentile", "married", "single", "birthdate", "bytes", "uuid", "empty"}).execute().getResult();
            if (rowDeleted) {
                Assert.assertTrue((boolean)response.isEmpty());
                continue;
            }
            Assert.assertFalse((boolean)response.isEmpty());
            this.testColumnValue((ColumnList<String>)response, "firstname", columnNames, "john_" + i);
            this.testColumnValue((ColumnList<String>)response, "lastname", columnNames, "smith_" + i);
            this.testColumnValue((ColumnList<String>)response, "address", columnNames, "john smith address " + i);
            this.testColumnValue((ColumnList<String>)response, "age", columnNames, 30 + i);
            this.testColumnValue((ColumnList<String>)response, "ageShort", columnNames, new Integer(30 + i).shortValue());
            this.testColumnValue((ColumnList<String>)response, "ageLong", columnNames, new Integer(30 + i).longValue());
            this.testColumnValue((ColumnList<String>)response, "percentile", columnNames, 30.1);
            this.testColumnValue((ColumnList<String>)response, "married", columnNames, true);
            this.testColumnValue((ColumnList<String>)response, "single", columnNames, false);
            this.testColumnValue((ColumnList<String>)response, "birthdate", columnNames, date);
            this.testColumnValue((ColumnList<String>)response, "bytes", columnNames, TestBytes);
            this.testColumnValue((ColumnList<String>)response, "uuid", columnNames, TestUUID);
            this.testColumnValue((ColumnList<String>)response, "empty", columnNames, null);
        }
    }

    private void testSingleRowAllColumnsColumnCountQuery(boolean rowDeleted) throws Exception {
        int expected = rowDeleted ? 0 : columnNames.size();
        for (int i = 0; i < this.TestRowCount; ++i) {
            int count = (Integer)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).getCount().execute().getResult();
            Assert.assertEquals((int)expected, (int)count);
        }
    }

    private void testSingleRowColumnSliceCollectionColumnCountQuery(boolean rowDeleted) throws Exception {
        int expected = rowDeleted ? 0 : columnNames.size();
        for (int i = 0; i < this.TestRowCount; ++i) {
            int count = (Integer)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).withColumnSlice((Collection)columnNames).getCount().execute().getResult();
            Assert.assertEquals((int)expected, (int)count);
        }
    }

    private void testSingleRowColumnSliceVarArgsColumnCountQuery(boolean rowDeleted) throws Exception {
        int expected = rowDeleted ? 0 : columnNames.size();
        for (int i = 0; i < this.TestRowCount; ++i) {
            int count = (Integer)keyspace.prepareQuery(CF_USER_INFO).getRow((Object)("acct_" + i)).withColumnSlice((Object[])new String[]{"firstname", "lastname", "address", "age", "ageShort", "ageLong", "percentile", "married", "single", "birthdate", "bytes", "uuid", "empty"}).getCount().execute().getResult();
            Assert.assertEquals((int)expected, (int)count);
        }
    }

    private <T> void testColumnValue(ColumnList<String> response, String columnName, List<String> columnNames, T value) {
        Column column = response.getColumnByName((Object)columnName);
        Assert.assertEquals((String)columnName, (String)((String)column.getName()));
        this.testColumnValue((Column<String>)column, value);
    }

    private <T> void testColumnValue(Column<String> column, T value) {
        if (value != null) {
            Assert.assertTrue((boolean)column.hasValue());
            if (value instanceof String) {
                Assert.assertEquals(value, (Object)column.getStringValue());
            } else if (value instanceof Integer) {
                Assert.assertEquals(value, (Object)column.getIntegerValue());
            } else if (value instanceof Short) {
                Assert.assertEquals(value, (Object)column.getShortValue());
            } else if (value instanceof Long) {
                Assert.assertEquals(value, (Object)column.getLongValue());
            } else if (value instanceof Double) {
                Assert.assertEquals(value, (Object)column.getDoubleValue());
            } else if (value instanceof Boolean) {
                Assert.assertEquals(value, (Object)column.getBooleanValue());
            } else if (value instanceof Date) {
                Assert.assertEquals(value, (Object)column.getDateValue());
            } else if (value instanceof byte[]) {
                ByteBuffer bbuf = column.getByteBufferValue();
                String result = new String(BytesArraySerializer.get().fromByteBuffer(bbuf));
                Assert.assertEquals((String)new String((byte[])value), (String)result);
            } else if (value instanceof UUID) {
                Assert.assertEquals(value, (Object)column.getUUIDValue());
            } else {
                Assert.fail((String)("Value not recognized for column: " + (String)column.getName()));
            }
        } else {
            Assert.assertFalse((boolean)column.hasValue());
        }
    }
}

