/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SingleColumnMutationTests
extends KeyspaceTests {
    public static ColumnFamily<Long, String> CF_SINGLE_COLUMN = ColumnFamily.newColumnFamily((String)"cfsinglecolmutation", (Serializer)LongSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        SingleColumnMutationTests.initContext();
        keyspace.createColumnFamily(CF_SINGLE_COLUMN, null);
        CF_SINGLE_COLUMN.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_SINGLE_COLUMN);
    }

    @Test
    public void testSingleColumnMutation() throws Exception {
        keyspace.prepareColumnMutation(CF_SINGLE_COLUMN, (Object)1L, (Object)"1").putValue("11", null).execute();
        keyspace.prepareColumnMutation(CF_SINGLE_COLUMN, (Object)1L, (Object)"2").putValue("22", null).execute();
        keyspace.prepareColumnMutation(CF_SINGLE_COLUMN, (Object)1L, (Object)"3").putValue("33", null).execute();
        ColumnList result = (ColumnList)keyspace.prepareQuery(CF_SINGLE_COLUMN).getRow((Object)1L).execute().getResult();
        Assert.assertTrue((3 == result.size() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"11", (Object)result.getColumnByName((Object)"1").getStringValue());
        Assert.assertEquals((Object)"22", (Object)result.getColumnByName((Object)"2").getStringValue());
        Assert.assertEquals((Object)"33", (Object)result.getColumnByName((Object)"3").getStringValue());
        keyspace.prepareColumnMutation(CF_SINGLE_COLUMN, (Object)1L, (Object)"2").putEmptyColumn(null).execute();
        keyspace.prepareColumnMutation(CF_SINGLE_COLUMN, (Object)1L, (Object)"3").deleteColumn().execute();
        result = (ColumnList)keyspace.prepareQuery(CF_SINGLE_COLUMN).getRow((Object)1L).execute().getResult();
        Assert.assertTrue((2 == result.size() ? 1 : 0) != 0);
        Assert.assertEquals((Object)"11", (Object)result.getColumnByName((Object)"1").getStringValue());
        Assert.assertNull((Object)result.getColumnByName((Object)"2").getStringValue());
    }
}

