/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.cql.test.utils.ReadTests;
import com.netflix.astyanax.cql.test.utils.TestUtils;
import com.netflix.astyanax.model.ColumnFamily;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ColumnCountQueryTests
extends ReadTests {
    private static ColumnFamily<String, String> CF_COLUMN_RANGE_TEST = TestUtils.CF_COLUMN_RANGE_TEST;

    @BeforeClass
    public static void init() throws Exception {
        ColumnCountQueryTests.initContext();
        keyspace.createColumnFamily(CF_COLUMN_RANGE_TEST, null);
        CF_COLUMN_RANGE_TEST.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_COLUMN_RANGE_TEST);
    }

    @Test
    public void runAllTests() throws Exception {
        CF_COLUMN_RANGE_TEST.describe(keyspace);
        boolean rowDeleted = false;
        this.populateRowsForColumnRange();
        Thread.sleep(1000L);
        this.testColumnCountSingleRowAndAllColumns(rowDeleted);
        this.testColumnCountSingleRowAndColumnSet(rowDeleted);
        this.testColumnCountSingleRowAndColumnRange(rowDeleted);
        this.testColumnCountMultipleRowKeysAndAllColumns(rowDeleted);
        this.testColumnCountMultipleRowKeysAndColumnSet(rowDeleted);
        this.testColumnCountMultipleRowKeysAndColumnRange(rowDeleted);
        this.testColumnCountRowRangeAndAllColumns(rowDeleted);
        this.testColumnCountRowRangeAndColumnSet(rowDeleted);
        this.testColumnCountRowRangeAndColumnRange(rowDeleted);
        this.deleteRowsForColumnRange();
        Thread.sleep(1000L);
        rowDeleted = true;
        this.testColumnCountSingleRowAndAllColumns(rowDeleted);
        this.testColumnCountSingleRowAndColumnSet(rowDeleted);
        this.testColumnCountSingleRowAndColumnRange(rowDeleted);
        this.testColumnCountMultipleRowKeysAndAllColumns(rowDeleted);
        this.testColumnCountMultipleRowKeysAndColumnSet(rowDeleted);
        this.testColumnCountMultipleRowKeysAndColumnRange(rowDeleted);
        this.testColumnCountRowRangeAndAllColumns(rowDeleted);
        this.testColumnCountRowRangeAndColumnSet(rowDeleted);
        this.testColumnCountRowRangeAndColumnRange(rowDeleted);
    }

    private void testColumnCountSingleRowAndAllColumns(boolean rowDeleted) throws Exception {
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String rowKey = String.valueOf(ch);
            Integer columnCount = (Integer)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getKey((Object)rowKey).getCount().execute().getResult();
            int expected = rowDeleted ? 0 : 26;
            Assert.assertTrue((String)("expected: " + expected + " colCount: " + columnCount), (expected == columnCount ? 1 : 0) != 0);
        }
    }

    private void testColumnCountSingleRowAndColumnSet(boolean rowDeleted) throws Exception {
        Random random = new Random();
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String rowKey = String.valueOf(ch);
            int numColumns = random.nextInt(26) + 1;
            Integer columnCount = (Integer)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getKey((Object)rowKey).withColumnSlice(this.getRandomColumns(numColumns)).getCount().execute().getResult();
            int expected = rowDeleted ? 0 : numColumns;
            Assert.assertTrue((String)("expected: " + expected + " colCount: " + columnCount), (expected == columnCount ? 1 : 0) != 0);
        }
    }

    private void testColumnCountSingleRowAndColumnRange(boolean rowDeleted) throws Exception {
        Random random = new Random();
        for (char ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            String rowKey = String.valueOf(ch);
            int rand = random.nextInt(26);
            char randCH = (char)(97 + rand);
            String startCol = String.valueOf(randCH);
            Integer columnCount = (Integer)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getKey((Object)rowKey).withColumnRange((Object)startCol, (Object)"z", false, -1).getCount().execute().getResult();
            int charOffset = startCol.charAt(0) - 97 + 1;
            int expected = rowDeleted ? 0 : 26 - charOffset + 1;
            Assert.assertTrue((String)("expected: " + expected + " colCount: " + columnCount), (expected == columnCount ? 1 : 0) != 0);
        }
    }

    private void testColumnCountMultipleRowKeysAndAllColumns(boolean rowDeleted) throws Exception {
        Collection<String> rowKeys = this.getRandomRowKeys();
        Map columnCountsPerRowKey = (Map)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowSlice(rowKeys).getColumnCounts().execute().getResult();
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        if (!rowDeleted) {
            for (String key : rowKeys) {
                expected.put(key, 26);
            }
        }
        Assert.assertEquals((String)("expected: " + expected + " colCount: " + columnCountsPerRowKey), expected, (Object)columnCountsPerRowKey);
    }

    private void testColumnCountMultipleRowKeysAndColumnSet(boolean rowDeleted) throws Exception {
        Collection<String> rowKeys = this.getRandomRowKeys();
        Collection<String> columns = this.getRandomColumns(new Random().nextInt(26) + 1);
        Map columnCountsPerRowKey = (Map)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowSlice(rowKeys).withColumnSlice(columns).getColumnCounts().execute().getResult();
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        if (!rowDeleted) {
            for (String key : rowKeys) {
                expected.put(key, columns.size());
            }
        }
        Assert.assertEquals((String)("expected: " + expected + " colCount: " + columnCountsPerRowKey), expected, (Object)columnCountsPerRowKey);
    }

    private void testColumnCountMultipleRowKeysAndColumnRange(boolean rowDeleted) throws Exception {
        Collection<String> rowKeys = this.getRandomRowKeys();
        int rand = new Random().nextInt(26);
        char randCH = (char)(97 + rand);
        String startCol = String.valueOf(randCH);
        Map columnCountsPerRowKey = (Map)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowSlice(rowKeys).withColumnRange((Object)startCol, (Object)"z", false, -1).getColumnCounts().execute().getResult();
        int charOffset = startCol.charAt(0) - 97 + 1;
        int expectedColCount = 26 - charOffset + 1;
        HashMap<String, Integer> expected = new HashMap<String, Integer>();
        if (!rowDeleted) {
            for (String key : rowKeys) {
                expected.put(key, expectedColCount);
            }
        }
        Assert.assertEquals((String)("expected: " + expected + " colCount: " + columnCountsPerRowKey), expected, (Object)columnCountsPerRowKey);
    }

    private void testColumnCountRowRangeAndAllColumns(boolean rowDeleted) throws Exception {
        List<TestUtils.TestTokenRange> testRanges = TestUtils.getTestTokenRanges();
        Map<Object, Object> expectedRowCounts = rowDeleted ? new HashMap() : this.getExpectedRowCountsForTokenRanges(testRanges, 26);
        HashMap resultRowCounts = new HashMap();
        for (TestUtils.TestTokenRange testRange : testRanges) {
            Map rowCounts = (Map)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowRange(null, null, testRange.startToken, testRange.endToken, -1).getColumnCounts().execute().getResult();
            resultRowCounts.putAll(rowCounts);
        }
        Assert.assertEquals(expectedRowCounts, resultRowCounts);
    }

    private void testColumnCountRowRangeAndColumnSet(boolean rowDeleted) throws Exception {
        Collection<String> columns = this.getRandomColumns(new Random().nextInt(26) + 1);
        List<TestUtils.TestTokenRange> testRanges = TestUtils.getTestTokenRanges();
        HashMap expectedRowCounts = rowDeleted ? new HashMap() : this.getExpectedRowCountsForTokenRanges(testRanges, columns.size());
        HashMap resultRowCounts = new HashMap();
        for (TestUtils.TestTokenRange testRange : testRanges) {
            Map rowCounts = (Map)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowRange(null, null, testRange.startToken, testRange.endToken, -1).withColumnSlice(columns).getColumnCounts().execute().getResult();
            resultRowCounts.putAll(rowCounts);
        }
        Assert.assertEquals(expectedRowCounts, resultRowCounts);
    }

    private void testColumnCountRowRangeAndColumnRange(boolean rowDeleted) throws Exception {
        int rand = new Random().nextInt(26);
        char randCH = (char)(97 + rand);
        String startColumn = String.valueOf(randCH);
        int expectedColCount = 122 - startColumn.charAt(0) + 1;
        List<TestUtils.TestTokenRange> testRanges = TestUtils.getTestTokenRanges();
        Map<Object, Object> expectedRowCounts = rowDeleted ? new HashMap() : this.getExpectedRowCountsForTokenRanges(testRanges, expectedColCount);
        HashMap resultRowCounts = new HashMap();
        for (TestUtils.TestTokenRange testRange : testRanges) {
            Map rowCounts = (Map)keyspace.prepareQuery(CF_COLUMN_RANGE_TEST).getRowRange(null, null, testRange.startToken, testRange.endToken, -1).withColumnRange((Object)startColumn, (Object)"z", false, -1).getColumnCounts().execute().getResult();
            resultRowCounts.putAll(rowCounts);
        }
        Assert.assertEquals(expectedRowCounts, resultRowCounts);
    }

    private void populateRowsForColumnRange() throws Exception {
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String rowKey = Character.toString(keyName);
            ColumnListMutation colMutation = m.withRow(CF_COLUMN_RANGE_TEST, (Object)rowKey);
            for (char cName = 'a'; cName <= 'z'; cName = (char)(cName + '\u0001')) {
                colMutation.putColumn((Object)Character.toString(cName), cName - 97 + 1, null);
            }
            m.withCaching(true);
            m.execute();
            m.discardMutations();
        }
    }

    private void deleteRowsForColumnRange() throws Exception {
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            MutationBatch m = keyspace.prepareMutationBatch();
            String rowKey = Character.toString(keyName);
            m.withRow(CF_COLUMN_RANGE_TEST, (Object)rowKey).delete();
            m.execute();
            m.discardMutations();
        }
    }

    private Collection<String> getRandomRowKeys() {
        Random random = new Random();
        int numRowKeys = random.nextInt(26) + 1;
        HashSet<String> hashSet = new HashSet<String>();
        while (hashSet.size() < numRowKeys) {
            int pick = random.nextInt(26);
            char ch = (char)(65 + pick);
            hashSet.add(String.valueOf(ch));
        }
        return hashSet;
    }

    private Map<String, Integer> getExpectedRowCountsForTokenRanges(List<TestUtils.TestTokenRange> testRanges, int expectedColumnCountForEachRow) {
        HashMap<String, Integer> expectedRowCounts = new HashMap<String, Integer>();
        for (TestUtils.TestTokenRange range : testRanges) {
            for (String rowKey : range.expectedRowKeys) {
                expectedRowCounts.put(rowKey, expectedColumnCountForEachRow);
            }
        }
        return expectedRowCounts;
    }
}

