/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

class ReqExclScorer
extends Scorer {
    private final Scorer reqScorer;
    private final DocIdSetIterator reqApproximation;
    private final DocIdSetIterator exclApproximation;
    private final TwoPhaseIterator reqTwoPhaseIterator;
    private final TwoPhaseIterator exclTwoPhaseIterator;

    public ReqExclScorer(Scorer reqScorer, Scorer exclScorer) {
        super(reqScorer.weight);
        this.reqScorer = reqScorer;
        this.reqTwoPhaseIterator = reqScorer.asTwoPhaseIterator();
        this.reqApproximation = this.reqTwoPhaseIterator == null ? reqScorer : this.reqTwoPhaseIterator.approximation();
        this.exclTwoPhaseIterator = exclScorer.asTwoPhaseIterator();
        this.exclApproximation = this.exclTwoPhaseIterator == null ? exclScorer : this.exclTwoPhaseIterator.approximation();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.toNonExcluded(this.reqApproximation.nextDoc());
    }

    private static boolean matches(TwoPhaseIterator it) throws IOException {
        return it == null || it.matches();
    }

    private static boolean matches(int doc, int exclDoc, TwoPhaseIterator reqTwoPhaseIterator, TwoPhaseIterator exclTwoPhaseIterator) throws IOException {
        assert (exclDoc >= doc);
        if (doc == exclDoc && ReqExclScorer.matches(exclTwoPhaseIterator)) {
            return false;
        }
        return ReqExclScorer.matches(reqTwoPhaseIterator);
    }

    private int toNonExcluded(int doc) throws IOException {
        int exclDoc = this.exclApproximation.docID();
        while (doc != Integer.MAX_VALUE) {
            if (exclDoc < doc) {
                exclDoc = this.exclApproximation.advance(doc);
            }
            if (ReqExclScorer.matches(doc, exclDoc, this.reqTwoPhaseIterator, this.exclTwoPhaseIterator)) {
                return doc;
            }
            doc = this.reqApproximation.nextDoc();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public int freq() throws IOException {
        return this.reqScorer.freq();
    }

    @Override
    public long cost() {
        return this.reqScorer.cost();
    }

    @Override
    public float score() throws IOException {
        return this.reqScorer.score();
    }

    @Override
    public Collection<Scorer.ChildScorer> getChildren() {
        return Collections.singleton(new Scorer.ChildScorer(this.reqScorer, "MUST"));
    }

    @Override
    public int advance(int target) throws IOException {
        return this.toNonExcluded(this.reqApproximation.advance(target));
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        if (this.reqTwoPhaseIterator == null) {
            return null;
        }
        return new TwoPhaseIterator(this.reqApproximation){

            @Override
            public boolean matches() throws IOException {
                int doc = ReqExclScorer.this.reqApproximation.docID();
                int exclDoc = ReqExclScorer.this.exclApproximation.docID();
                if (exclDoc < doc) {
                    exclDoc = ReqExclScorer.this.exclApproximation.advance(doc);
                }
                return ReqExclScorer.matches(doc, exclDoc, ReqExclScorer.this.reqTwoPhaseIterator, ReqExclScorer.this.exclTwoPhaseIterator);
            }

            @Override
            public float matchCost() {
                return ReqExclScorer.this.reqTwoPhaseIterator.matchCost();
            }
        };
    }
}

