/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;

public abstract class ValuesSourceAggregatorFactory<VS extends ValuesSource>
extends AggregatorFactory {
    protected ValuesSourceConfig<VS> config;

    protected ValuesSourceAggregatorFactory(String name, String type, ValuesSourceConfig<VS> config) {
        super(name, type);
        this.config = config;
    }

    @Override
    public Aggregator createInternal(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        VS vs = context.valuesSource(this.config, context.searchContext());
        if (vs == null) {
            return this.createUnmapped(context, parent, pipelineAggregators, metaData);
        }
        return this.doCreateInternal(vs, context, parent, collectsFromSingleBucket, pipelineAggregators, metaData);
    }

    @Override
    public void doValidate() {
        if (this.config == null || !this.config.valid()) {
            this.resolveValuesSourceConfigFromAncestors(this.name, this.parent, this.config.valueSourceType());
        }
    }

    protected abstract Aggregator createUnmapped(AggregationContext var1, Aggregator var2, List<PipelineAggregator> var3, Map<String, Object> var4) throws IOException;

    protected abstract Aggregator doCreateInternal(VS var1, AggregationContext var2, Aggregator var3, boolean var4, List<PipelineAggregator> var5, Map<String, Object> var6) throws IOException;

    private void resolveValuesSourceConfigFromAncestors(String aggName, AggregatorFactory parent, Class<VS> requiredValuesSourceType) {
        while (parent != null) {
            ValuesSourceConfig<VS> config;
            if (parent instanceof ValuesSourceAggregatorFactory && (config = ((ValuesSourceAggregatorFactory)parent).config) != null && config.valid() && (requiredValuesSourceType == null || requiredValuesSourceType.isAssignableFrom(config.valueSourceType))) {
                ValueFormat format = config.format;
                this.config = config;
                if (this.config.formatPattern != null && format != null && format instanceof ValueFormat.Patternable) {
                    this.config.format = ((ValueFormat.Patternable)format).create(this.config.formatPattern);
                }
                return;
            }
            parent = parent.parent();
        }
        throw new AggregationExecutionException("could not find the appropriate value context to perform aggregation [" + aggName + "]");
    }

    public static abstract class LeafOnly<VS extends ValuesSource>
    extends ValuesSourceAggregatorFactory<VS> {
        protected LeafOnly(String name, String type, ValuesSourceConfig<VS> valuesSourceConfig) {
            super(name, type, valuesSourceConfig);
        }

        @Override
        public AggregatorFactory subFactories(AggregatorFactories subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.type + "] cannot accept sub-aggregations");
        }
    }
}

