/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.movavg.models;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.EwmaModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltLinearModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.HoltWintersModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.LinearModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.MovAvgModel;
import org.elasticsearch.search.aggregations.pipeline.movavg.models.SimpleModel;

public class MovAvgModelParserMapper {
    protected Map<String, MovAvgModel.AbstractModelParser> movAvgParsers;

    @Inject
    public MovAvgModelParserMapper(Set<MovAvgModel.AbstractModelParser> parsers) {
        HashMap<String, MovAvgModel.AbstractModelParser> map = new HashMap<String, MovAvgModel.AbstractModelParser>();
        this.add(map, new SimpleModel.SimpleModelParser());
        this.add(map, new LinearModel.LinearModelParser());
        this.add(map, new EwmaModel.SingleExpModelParser());
        this.add(map, new HoltLinearModel.DoubleExpModelParser());
        this.add(map, new HoltWintersModel.HoltWintersModelParser());
        for (MovAvgModel.AbstractModelParser parser : parsers) {
            this.add(map, parser);
        }
        this.movAvgParsers = Collections.unmodifiableMap(map);
    }

    @Nullable
    public MovAvgModel.AbstractModelParser get(String parserName) {
        return this.movAvgParsers.get(parserName);
    }

    public Set<String> getAllNames() {
        return this.movAvgParsers.keySet();
    }

    private void add(Map<String, MovAvgModel.AbstractModelParser> map, MovAvgModel.AbstractModelParser parser) {
        map.put(parser.getName(), parser);
    }
}

