/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.max.InternalMax;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SimpleValue;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public class InternalSimpleValue
extends InternalNumericMetricsAggregation.SingleValue
implements SimpleValue {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("simple_value");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalSimpleValue readResult(StreamInput in) throws IOException {
            InternalSimpleValue result = new InternalSimpleValue();
            result.readFrom(in);
            return result;
        }
    };
    private double value;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    protected InternalSimpleValue() {
    }

    public InternalSimpleValue(String name, double value, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.valueFormatter = formatter;
        this.value = value;
    }

    @Override
    public double value() {
        return this.value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalMax doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.valueFormatter = ValueFormatterStreams.readOptional(in);
        this.value = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.valueFormatter, out);
        out.writeDouble(this.value);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean hasValue = !Double.isInfinite(this.value) && !Double.isNaN(this.value);
        builder.field(InternalAggregation.CommonFields.VALUE, hasValue ? Double.valueOf(this.value) : null);
        if (hasValue && !(this.valueFormatter instanceof ValueFormatter.Raw)) {
            builder.field(InternalAggregation.CommonFields.VALUE_AS_STRING, this.valueFormatter.format(this.value));
        }
        return builder;
    }
}

