/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles.tdigest;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.AbstractTDigestPercentilesAggregator;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.InternalTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class TDigestPercentileRanksAggregator
extends AbstractTDigestPercentilesAggregator {
    public TDigestPercentileRanksAggregator(String name, ValuesSource.Numeric valuesSource, AggregationContext context, Aggregator parent, double[] percents, double compression, boolean keyed, ValueFormatter formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, valuesSource, context, parent, percents, compression, keyed, formatter, pipelineAggregators, metaData);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentileRanks(this.name, this.keys, state, this.keyed, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalTDigestPercentileRanks(this.name, this.keys, new TDigestState(this.compression), this.keyed, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return InternalTDigestPercentileRanks.percentileRank(state, Double.valueOf(name));
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        private final double[] values;
        private final double compression;
        private final boolean keyed;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double[] values, double compression, boolean keyed) {
            super(name, InternalTDigestPercentiles.TYPE.name(), valuesSourceConfig);
            this.values = values;
            this.compression = compression;
            this.keyed = keyed;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new TDigestPercentileRanksAggregator(this.name, null, aggregationContext, parent, this.values, this.compression, this.keyed, this.config.formatter(), pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource.Numeric valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new TDigestPercentileRanksAggregator(this.name, valuesSource, aggregationContext, parent, this.values, this.compression, this.keyed, this.config.formatter(), pipelineAggregators, metaData);
        }
    }
}

