/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filters.FiltersParser;
import org.elasticsearch.search.aggregations.bucket.filters.InternalFilters;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class FiltersAggregationBuilder
extends AggregationBuilder<FiltersAggregationBuilder> {
    private Map<String, QueryBuilder> keyedFilters = null;
    private List<QueryBuilder> nonKeyedFilters = null;
    private Boolean otherBucket;
    private String otherBucketKey;

    public FiltersAggregationBuilder(String name) {
        super(name, InternalFilters.TYPE.name());
    }

    public FiltersAggregationBuilder filter(String key, QueryBuilder filter) {
        if (this.keyedFilters == null) {
            this.keyedFilters = new LinkedHashMap<String, QueryBuilder>();
        }
        this.keyedFilters.put(key, filter);
        return this;
    }

    public FiltersAggregationBuilder filter(QueryBuilder filter) {
        if (this.nonKeyedFilters == null) {
            this.nonKeyedFilters = new ArrayList<QueryBuilder>();
        }
        this.nonKeyedFilters.add(filter);
        return this;
    }

    public FiltersAggregationBuilder otherBucket(boolean otherBucket) {
        this.otherBucket = otherBucket;
        return this;
    }

    public FiltersAggregationBuilder otherBucketKey(String otherBucketKey) {
        this.otherBucketKey = otherBucketKey;
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.keyedFilters == null && this.nonKeyedFilters == null) {
            throw new SearchSourceBuilderException("At least one filter must be set on filter aggregation [" + this.getName() + "]");
        }
        if (this.keyedFilters != null && this.nonKeyedFilters != null) {
            throw new SearchSourceBuilderException("Cannot add both keyed and non-keyed filters to filters aggregation");
        }
        if (this.keyedFilters != null) {
            builder.startObject(FiltersParser.FILTERS_FIELD.getPreferredName());
            for (Map.Entry entry : this.keyedFilters.entrySet()) {
                builder.field((String)entry.getKey());
                ((QueryBuilder)entry.getValue()).toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.nonKeyedFilters != null) {
            builder.startArray(FiltersParser.FILTERS_FIELD.getPreferredName());
            for (QueryBuilder queryBuilder : this.nonKeyedFilters) {
                queryBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.otherBucketKey != null) {
            builder.field(FiltersParser.OTHER_BUCKET_KEY_FIELD.getPreferredName(), this.otherBucketKey);
        }
        if (this.otherBucket != null) {
            builder.field(FiltersParser.OTHER_BUCKET_FIELD.getPreferredName(), (Object)this.otherBucket);
        }
        return builder.endObject();
    }
}

