/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.ObjectSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.query.TemplateQueryParser;
import org.elasticsearch.index.search.stats.ShardSearchStats;
import org.elasticsearch.index.search.stats.StatsGroupsParseElement;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.cache.request.IndicesRequestCache;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.Template;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.fetch.ShardFetchRequest;
import org.elasticsearch.search.internal.DefaultSearchContext;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.profile.Profilers;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchService
extends AbstractLifecycleComponent<SearchService> {
    public static final String NORMS_LOADING_KEY = "index.norms.loading";
    public static final String DEFAULT_KEEPALIVE_KEY = "search.default_keep_alive";
    public static final String KEEPALIVE_INTERVAL_KEY = "search.keep_alive_interval";
    public static final String DEFAULT_SEARCH_TIMEOUT = "search.default_search_timeout";
    public static final TimeValue NO_TIMEOUT = TimeValue.timeValueMillis(-1L);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final IndicesWarmer indicesWarmer;
    private final ScriptService scriptService;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final DfsPhase dfsPhase;
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private final IndicesRequestCache indicesQueryCache;
    private final long defaultKeepAlive;
    private volatile TimeValue defaultSearchTimeout;
    private final ScheduledFuture<?> keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final ImmutableMap<String, SearchParseElement> elementParsers;
    private final ParseFieldMatcher parseFieldMatcher;
    private static final int[] EMPTY_DOC_IDS = new int[0];

    @Inject
    public SearchService(Settings settings, NodeSettingsService nodeSettingsService, ClusterService clusterService, IndicesService indicesService, IndicesWarmer indicesWarmer, ThreadPool threadPool, ScriptService scriptService, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, DfsPhase dfsPhase, QueryPhase queryPhase, FetchPhase fetchPhase, IndicesRequestCache indicesQueryCache) {
        super(settings);
        this.parseFieldMatcher = new ParseFieldMatcher(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        indicesService.indicesLifecycle().addListener(new IndicesLifecycle.Listener(){

            @Override
            public void afterIndexClosed(Index index, Settings indexSettings) {
                IndexMetaData idxMeta = SearchService.this.clusterService.state().metaData().index(index.getName());
                if (idxMeta != null && idxMeta.getState() == IndexMetaData.State.CLOSE) {
                    this.afterIndexDeleted(index, indexSettings);
                }
            }

            @Override
            public void afterIndexDeleted(Index index, Settings indexSettings) {
                SearchService.this.freeAllContextForIndex(index);
            }
        });
        this.indicesWarmer = indicesWarmer;
        this.scriptService = scriptService;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays;
        this.dfsPhase = dfsPhase;
        this.queryPhase = queryPhase;
        this.fetchPhase = fetchPhase;
        this.indicesQueryCache = indicesQueryCache;
        TimeValue keepAliveInterval = settings.getAsTime(KEEPALIVE_INTERVAL_KEY, TimeValue.timeValueMinutes(1L));
        this.defaultKeepAlive = settings.getAsTime(DEFAULT_KEEPALIVE_KEY, TimeValue.timeValueMinutes(5L)).millis();
        HashMap<String, ? extends SearchParseElement> elementParsers = new HashMap<String, SearchParseElement>();
        elementParsers.putAll(dfsPhase.parseElements());
        elementParsers.putAll(queryPhase.parseElements());
        elementParsers.putAll(fetchPhase.parseElements());
        elementParsers.put("stats", new StatsGroupsParseElement());
        this.elementParsers = ImmutableMap.copyOf(elementParsers);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval);
        this.indicesWarmer.addListener(new NormsWarmer());
        this.indicesWarmer.addListener(new FieldDataWarmer());
        this.indicesWarmer.addListener(new SearchWarmer());
        this.defaultSearchTimeout = settings.getAsTime(DEFAULT_SEARCH_TIMEOUT, NO_TIMEOUT);
        nodeSettingsService.addListener(new SearchSettingsListener());
    }

    protected void putContext(SearchContext context) {
        SearchContext previous = this.activeContexts.put(context.id(), context);
        assert (previous == null);
    }

    protected SearchContext removeContext(long id) {
        return this.activeContexts.remove(id);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context.id());
        }
    }

    @Override
    protected void doClose() {
        this.doStop();
        FutureUtils.cancel(this.keepAliveReaper);
    }

    public DfsSearchResult executeDfsPhase(ShardSearchRequest request) {
        SearchContext context = this.createAndPutContext(request);
        try {
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Dfs phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    @Deprecated
    public QuerySearchResult executeScan(ShardSearchRequest request) {
        SearchContext context = this.createAndPutContext(request);
        int originalSize = context.size();
        try {
            if (context.aggregations() != null) {
                throw new IllegalArgumentException("aggregations are not supported with search_type=scan");
            }
            if (context.scrollContext() == null || context.scrollContext().scroll == null) {
                throw new ElasticsearchException("Scroll must be provided when scanning...", new Object[0]);
            }
            assert (context.searchType() == SearchType.SCAN);
            context.searchType(SearchType.QUERY_THEN_FETCH);
            context.size(0);
            assert (context.searchType() == SearchType.QUERY_THEN_FETCH);
            this.contextProcessing(context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Scan phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            context.size(originalSize);
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeScan(InternalScrollSearchRequest request) {
        SearchContext context = this.findContext(request.id());
        ShardSearchStats shardSearchStats = context.indexShard().searchService();
        this.contextProcessing(context);
        try {
            this.processScroll(request, context);
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                if (context.searchType() == SearchType.QUERY_THEN_FETCH) {
                    context.searchType(SearchType.SCAN);
                    context.from(0);
                }
                this.queryPhase.execute(context);
            }
            catch (Throwable e) {
                shardSearchStats.onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long queryFinishTime = System.nanoTime();
            shardSearchStats.onQueryPhase(context, queryFinishTime - time);
            shardSearchStats.onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoadForScanning(context);
                this.fetchPhase.execute(context);
                if (context.scrollContext() == null || context.fetchResult().hits().hits().length < context.size()) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                shardSearchStats.onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            shardSearchStats.onFetchPhase(context, System.nanoTime() - queryFinishTime);
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Scan phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private void loadOrExecuteQueryPhase(ShardSearchRequest request, SearchContext context, QueryPhase queryPhase) throws Exception {
        boolean canCache = this.indicesQueryCache.canCache(request, context);
        if (canCache) {
            this.indicesQueryCache.loadIntoContext(request, context, queryPhase);
        } else {
            queryPhase.execute(context);
        }
    }

    public QuerySearchResultProvider executeQueryPhase(ShardSearchRequest request) {
        SearchContext context = this.createAndPutContext(request);
        ShardSearchStats shardSearchStats = context.indexShard().searchService();
        try {
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.loadOrExecuteQueryPhase(request, context, this.queryPhase);
            if (context.queryResult().topDocs().scoreDocs.length == 0 && context.scrollContext() == null) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            shardSearchStats.onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                e = e.getCause();
            }
            shardSearchStats.onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQuerySearchResult executeQueryPhase(InternalScrollSearchRequest request) {
        SearchContext context = this.findContext(request.id());
        ShardSearchStats shardSearchStats = context.indexShard().searchService();
        try {
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.processScroll(request, context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            shardSearchStats.onQueryPhase(context, System.nanoTime() - time);
            ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
            return scrollQuerySearchResult;
        }
        catch (Throwable e) {
            shardSearchStats.onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(QuerySearchRequest request) {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        context.searcher().setAggregatedDfs(request.dfs());
        IndexShard indexShard = context.indexShard();
        ShardSearchStats shardSearchStats = indexShard.searchService();
        try {
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            this.queryPhase.execute(context);
            if (context.queryResult().topDocs().scoreDocs.length == 0 && context.scrollContext() == null) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            shardSearchStats.onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (Throwable e) {
            shardSearchStats.onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private boolean fetchPhaseShouldFreeContext(SearchContext context) {
        if (context.scrollContext() == null) {
            return true;
        }
        return context.scrollContext().scroll == null;
    }

    public QueryFetchSearchResult executeFetchPhase(ShardSearchRequest request) {
        SearchContext context = this.createAndPutContext(request);
        this.contextProcessing(context);
        try {
            ShardSearchStats shardSearchStats = context.indexShard().searchService();
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.loadOrExecuteQueryPhase(request, context, this.queryPhase);
            }
            catch (Throwable e) {
                shardSearchStats.onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long time2 = System.nanoTime();
            shardSearchStats.onQueryPhase(context, time2 - time);
            shardSearchStats.onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (this.fetchPhaseShouldFreeContext(context)) {
                    this.freeContext(context.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                shardSearchStats.onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            shardSearchStats.onFetchPhase(context, System.nanoTime() - time2);
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(QuerySearchRequest request) {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        context.searcher().setAggregatedDfs(request.dfs());
        try {
            ShardSearchStats shardSearchStats = context.indexShard().searchService();
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (Throwable e) {
                shardSearchStats.onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long time2 = System.nanoTime();
            shardSearchStats.onQueryPhase(context, time2 - time);
            shardSearchStats.onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (this.fetchPhaseShouldFreeContext(context)) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                shardSearchStats.onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            shardSearchStats.onFetchPhase(context, System.nanoTime() - time2);
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeFetchPhase(InternalScrollSearchRequest request) {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            ShardSearchStats shardSearchStats = context.indexShard().searchService();
            this.processScroll(request, context);
            shardSearchStats.onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (Throwable e) {
                shardSearchStats.onFailedQueryPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            long time2 = System.nanoTime();
            shardSearchStats.onQueryPhase(context, time2 - time);
            shardSearchStats.onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (this.fetchPhaseShouldFreeContext(context)) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (Throwable e) {
                shardSearchStats.onFailedFetchPhase(context);
                throw ExceptionsHelper.convertToRuntime(e);
            }
            shardSearchStats.onFetchPhase(context, System.nanoTime() - time2);
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (Throwable e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    public FetchSearchResult executeFetchPhase(ShardFetchRequest request) {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        ShardSearchStats shardSearchStats = context.indexShard().searchService();
        try {
            if (request.lastEmittedDoc() != null) {
                context.scrollContext().lastEmittedDoc = request.lastEmittedDoc();
            }
            context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
            shardSearchStats.onPreFetchPhase(context);
            long time = System.nanoTime();
            this.fetchPhase.execute(context);
            if (this.fetchPhaseShouldFreeContext(context)) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            shardSearchStats.onFetchPhase(context, System.nanoTime() - time);
            FetchSearchResult fetchSearchResult = context.fetchResult();
            return fetchSearchResult;
        }
        catch (Throwable e) {
            shardSearchStats.onFailedFetchPhase(context);
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.processFailure(context, e);
            throw ExceptionsHelper.convertToRuntime(e);
        }
        finally {
            this.cleanContext(context);
        }
    }

    private SearchContext findContext(long id) throws SearchContextMissingException {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        SearchContext.setCurrent(context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SearchContext createAndPutContext(ShardSearchRequest request) {
        SearchContext context = this.createContext(request, null);
        boolean success = false;
        try {
            this.putContext(context);
            if (request.scroll() != null) {
                context.indexShard().searchService().onNewScrollContext(context);
            }
            context.indexShard().searchService().onNewContext(context);
            success = true;
            SearchContext searchContext = context;
            return searchContext;
        }
        finally {
            if (!success) {
                this.freeContext(context.id());
            }
        }
    }

    final SearchContext createContext(ShardSearchRequest request, @Nullable Engine.Searcher searcher) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.index(), request.shardId());
        Engine.Searcher engineSearcher = searcher == null ? indexShard.acquireSearcher("search") : searcher;
        DefaultSearchContext context = new DefaultSearchContext(this.idGenerator.incrementAndGet(), request, shardTarget, engineSearcher, indexService, indexShard, this.scriptService, this.pageCacheRecycler, this.bigArrays, this.threadPool.estimatedTimeInMillisCounter(), this.parseFieldMatcher, this.defaultSearchTimeout);
        SearchContext.setCurrent(context);
        try {
            if (request.scroll() != null) {
                context.scrollContext(new ScrollContext());
                context.scrollContext().scroll = request.scroll();
            }
            this.parseTemplate(request, context);
            this.parseSource(context, request.source());
            this.parseSource(context, request.extraSource());
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.searchType() == SearchType.COUNT) {
                context.searchType(SearchType.QUERY_THEN_FETCH);
                context.size(0);
            } else if (context.size() == -1) {
                context.size(10);
            }
            if (context.request().isProfile()) {
                context.setProfilers(new Profilers(context.searcher()));
            }
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            context.keepAlive(keepAlive);
        }
        catch (Throwable e) {
            context.close();
            throw ExceptionsHelper.convertToRuntime(e);
        }
        return context;
    }

    private void freeAllContextForIndex(Index index) {
        assert (index != null);
        for (SearchContext ctx : this.activeContexts.values()) {
            if (!index.equals(ctx.indexShard().shardId().index())) continue;
            this.freeContext(ctx.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeContext(long id) {
        SearchContext context = this.removeContext(id);
        if (context != null) {
            try {
                context.indexShard().searchService().onFreeContext(context);
                if (context.scrollContext() != null) {
                    context.indexShard().searchService().onFreeScrollContext(context);
                }
            }
            finally {
                context.close();
            }
            return true;
        }
        return false;
    }

    public void freeAllScrollContexts() {
        for (SearchContext searchContext : this.activeContexts.values()) {
            if (searchContext.scrollContext() == null) continue;
            this.freeContext(searchContext.id());
        }
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(this.threadPool.estimatedTimeInMillis());
    }

    private void cleanContext(SearchContext context) {
        assert (context == SearchContext.current());
        context.clearReleasables(SearchContext.Lifetime.PHASE);
        SearchContext.removeCurrent();
    }

    private void processFailure(SearchContext context, Throwable t) {
        this.freeContext(context.id());
        try {
            if (Lucene.isCorruptionException(t)) {
                context.indexShard().failShard("search execution corruption failure", t);
            }
        }
        catch (Throwable e) {
            this.logger.warn("failed to process shard failure to (potentially) send back shard failure on corruption", e, new Object[0]);
        }
    }

    private void parseTemplate(ShardSearchRequest request, SearchContext searchContext) {
        BytesReference processedQuery;
        block14: {
            Template template;
            XContentParser parser;
            block12: {
                block13: {
                    if (request.template() == null) break block13;
                    ExecutableScript executable = this.scriptService.executable(request.template(), ScriptContext.Standard.SEARCH, searchContext);
                    processedQuery = (BytesReference)executable.run();
                    break block14;
                }
                if (!Strings.hasLength(request.templateSource())) {
                    return;
                }
                parser = null;
                template = null;
                try {
                    parser = XContentFactory.xContent(request.templateSource()).createParser(request.templateSource());
                    template = TemplateQueryParser.parse(parser, searchContext.parseFieldMatcher(), "params", "template");
                    if (template.getType() == ScriptService.ScriptType.INLINE) {
                        ExecutableScript executable;
                        parser = null;
                        try {
                            ExecutableScript executable2 = this.scriptService.executable(template, ScriptContext.Standard.SEARCH, searchContext);
                            processedQuery = (BytesReference)executable2.run();
                            parser = XContentFactory.xContent(processedQuery).createParser(processedQuery);
                        }
                        catch (ElasticsearchParseException epe) {
                            template = new Template(template.getScript(), ScriptService.ScriptType.FILE, "mustache", null, template.getParams());
                            executable = this.scriptService.executable(template, ScriptContext.Standard.SEARCH, searchContext);
                            processedQuery = (BytesReference)executable.run();
                        }
                        if (parser == null) break block12;
                        try {
                            Template innerTemplate = TemplateQueryParser.parse(parser, searchContext.parseFieldMatcher());
                            if (Strings.hasLength(innerTemplate.getScript()) && !innerTemplate.getType().equals((Object)ScriptService.ScriptType.INLINE)) {
                                template = new Template(innerTemplate.getScript(), innerTemplate.getType(), "mustache", null, template.getParams());
                                executable = this.scriptService.executable(template, ScriptContext.Standard.SEARCH, searchContext);
                                processedQuery = (BytesReference)executable.run();
                            }
                            break block12;
                        }
                        catch (Script.ScriptParseException innerTemplate) {}
                        break block12;
                    }
                    ExecutableScript executable = this.scriptService.executable(template, ScriptContext.Standard.SEARCH, searchContext);
                    processedQuery = (BytesReference)executable.run();
                }
                catch (IOException e) {
                    try {
                        throw new ElasticsearchParseException("Failed to parse template", (Throwable)e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        Releasables.closeWhileHandlingException(parser);
                        throw throwable;
                    }
                }
            }
            Releasables.closeWhileHandlingException(parser);
            if (!Strings.hasLength(template.getScript())) {
                throw new ElasticsearchParseException("Template must have [template] field configured", new Object[0]);
            }
        }
        request.source(processedQuery);
    }

    private void parseSource(SearchContext context, BytesReference source) throws SearchParseException {
        if (source == null || source.length() == 0) {
            return;
        }
        try (XContentParser parser = null;){
            parser = XContentFactory.xContent(source).createParser(source);
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("failed to parse search source. source must be an object, but found [{}] instead", token.name());
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    SearchParseElement element = (SearchParseElement)this.elementParsers.get((Object)fieldName);
                    if (element == null) {
                        throw new SearchParseException(context, "failed to parse search source. unknown search element [" + fieldName + "]", parser.getTokenLocation());
                    }
                    element.parse(parser, context);
                    continue;
                }
                if (token == null) {
                    throw new ElasticsearchParseException("failed to parse search source. end of query source reached but query is not complete.", new Object[0]);
                }
                throw new ElasticsearchParseException("failed to parse search source. expected field name but got [{}]", new Object[]{token});
            }
        }
    }

    private void shortcutDocIdsToLoad(SearchContext context) {
        if (context.request().scroll() != null) {
            TopDocs topDocs = context.queryResult().topDocs();
            int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
            for (int i = 0; i < topDocs.scoreDocs.length; ++i) {
                docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
            }
            context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
        } else {
            TopDocs topDocs = context.queryResult().topDocs();
            if (topDocs.scoreDocs.length < context.from()) {
                context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
                return;
            }
            int totalSize = context.from() + context.size();
            int[] docIdsToLoad = new int[Math.min(topDocs.scoreDocs.length - context.from(), context.size())];
            int counter = 0;
            for (int i = context.from(); i < totalSize && i < topDocs.scoreDocs.length; ++i) {
                docIdsToLoad[counter] = topDocs.scoreDocs[i].doc;
                ++counter;
            }
            context.docIdsToLoad(docIdsToLoad, 0, counter);
        }
    }

    private void shortcutDocIdsToLoadForScanning(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs();
        if (topDocs.scoreDocs.length == 0) {
            context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
            return;
        }
        int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
        for (int i = 0; i < docIdsToLoad.length; ++i) {
            docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scrollContext().scroll = request.scroll();
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            context.keepAlive(request.scroll().keepAlive().millis());
        }
    }

    public int getActiveContexts() {
        return this.activeContexts.size();
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = SearchService.this.threadPool.estimatedTimeInMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                long lastAccessTime = context.lastAccessTime();
                if (lastAccessTime == -1L || time - lastAccessTime <= context.keepAlive()) continue;
                SearchService.this.logger.debug("freeing search context [{}], time [{}], lastAccessTime [{}], keepAlive [{}]", context.id(), time, lastAccessTime, context.keepAlive());
                SearchService.this.freeContext(context.id());
            }
        }
    }

    class SearchWarmer
    extends IndicesWarmer.Listener {
        SearchWarmer() {
        }

        @Override
        public IndicesWarmer.TerminationHandle warmNewReaders(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            return this.internalWarm(indexShard, indexMetaData, context, threadPool, false);
        }

        @Override
        public IndicesWarmer.TerminationHandle warmTopReader(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            return this.internalWarm(indexShard, indexMetaData, context, threadPool, true);
        }

        public IndicesWarmer.TerminationHandle internalWarm(final IndexShard indexShard, final IndexMetaData indexMetaData, final IndicesWarmer.WarmerContext warmerContext, ThreadPool threadPool, final boolean top) {
            IndexWarmersMetaData custom = (IndexWarmersMetaData)indexMetaData.custom("warmers");
            if (custom == null) {
                return IndicesWarmer.TerminationHandle.NO_WAIT;
            }
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(custom.entries().size());
            for (final IndexWarmersMetaData.Entry entry : custom.entries()) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SearchContext context = null;
                        try {
                            boolean canCache;
                            long now = System.nanoTime();
                            ShardSearchLocalRequest request = new ShardSearchLocalRequest(indexShard.shardId(), indexMetaData.getNumberOfShards(), SearchType.QUERY_THEN_FETCH, entry.source(), entry.types(), entry.requestCache());
                            context = SearchService.this.createContext(request, warmerContext.searcher());
                            if (context.sort() == null) {
                                context.size(0);
                            }
                            if ((canCache = SearchService.this.indicesQueryCache.canCache(request, context)) != top) {
                                return;
                            }
                            SearchService.this.loadOrExecuteQueryPhase(request, context, SearchService.this.queryPhase);
                            long took = System.nanoTime() - now;
                            if (indexShard.warmerService().logger().isTraceEnabled()) {
                                indexShard.warmerService().logger().trace("warmed [{}], took [{}]", entry.name(), TimeValue.timeValueNanos(took));
                            }
                        }
                        catch (Throwable t) {
                            indexShard.warmerService().logger().warn("warmer [{}] failed", t, entry.name());
                        }
                        finally {
                            try {
                                if (context != null) {
                                    SearchService.this.freeContext(context.id());
                                    SearchService.this.cleanContext(context);
                                }
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    }
                });
            }
            return new IndicesWarmer.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }
    }

    static class FieldDataWarmer
    extends IndicesWarmer.Listener {
        FieldDataWarmer() {
        }

        @Override
        public IndicesWarmer.TerminationHandle warmNewReaders(final IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            MapperService mapperService = indexShard.mapperService();
            HashMap<String, MappedFieldType> warmUp = new HashMap<String, MappedFieldType>();
            for (DocumentMapper docMapper : mapperService.docMappers(false)) {
                for (FieldMapper fieldMapper : docMapper.mappers()) {
                    String indexName;
                    FieldDataType fieldDataType;
                    if (fieldMapper instanceof ParentFieldMapper) {
                        MappedFieldType joinFieldType = ((ParentFieldMapper)fieldMapper).getChildJoinFieldType();
                        if (joinFieldType == null) continue;
                        fieldDataType = joinFieldType.fieldDataType();
                        indexName = fieldMapper.fieldType().names().indexName();
                    } else {
                        fieldDataType = fieldMapper.fieldType().fieldDataType();
                        indexName = fieldMapper.fieldType().names().indexName();
                    }
                    if (fieldDataType == null || fieldDataType.getLoading() == MappedFieldType.Loading.LAZY || warmUp.containsKey(indexName)) continue;
                    warmUp.put(indexName, fieldMapper.fieldType());
                }
            }
            final IndexFieldDataService indexFieldDataService = indexShard.indexFieldDataService();
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(context.searcher().reader().leaves().size() * warmUp.size());
            for (final LeafReaderContext ctx : context.searcher().reader().leaves()) {
                for (final MappedFieldType fieldType : warmUp.values()) {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                long start = System.nanoTime();
                                indexFieldDataService.getForField(fieldType).load(ctx);
                                if (indexShard.warmerService().logger().isTraceEnabled()) {
                                    indexShard.warmerService().logger().trace("warmed fielddata for [{}], took [{}]", fieldType.names().fullName(), TimeValue.timeValueNanos(System.nanoTime() - start));
                                }
                            }
                            catch (Throwable t) {
                                indexShard.warmerService().logger().warn("failed to warm-up fielddata for [{}]", t, fieldType.names().fullName());
                            }
                            finally {
                                latch.countDown();
                            }
                        }
                    });
                }
            }
            return new IndicesWarmer.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }

        @Override
        public IndicesWarmer.TerminationHandle warmTopReader(final IndexShard indexShard, IndexMetaData indexMetaData, final IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            MapperService mapperService = indexShard.mapperService();
            HashMap<String, MappedFieldType> warmUpGlobalOrdinals = new HashMap<String, MappedFieldType>();
            for (DocumentMapper docMapper : mapperService.docMappers(false)) {
                for (FieldMapper fieldMapper : docMapper.mappers()) {
                    String indexName;
                    FieldDataType fieldDataType;
                    if (fieldMapper instanceof ParentFieldMapper) {
                        MappedFieldType joinFieldType = ((ParentFieldMapper)fieldMapper).getChildJoinFieldType();
                        if (joinFieldType == null) continue;
                        fieldDataType = joinFieldType.fieldDataType();
                        indexName = fieldMapper.fieldType().names().indexName();
                    } else {
                        fieldDataType = fieldMapper.fieldType().fieldDataType();
                        indexName = fieldMapper.fieldType().names().indexName();
                    }
                    if (fieldDataType == null || fieldDataType.getLoading() != MappedFieldType.Loading.EAGER_GLOBAL_ORDINALS || warmUpGlobalOrdinals.containsKey(indexName)) continue;
                    warmUpGlobalOrdinals.put(indexName, fieldMapper.fieldType());
                }
            }
            final IndexFieldDataService indexFieldDataService = indexShard.indexFieldDataService();
            Executor executor = threadPool.executor(this.executor());
            final CountDownLatch latch = new CountDownLatch(warmUpGlobalOrdinals.size());
            for (final MappedFieldType fieldType : warmUpGlobalOrdinals.values()) {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long start = System.nanoTime();
                            IndexFieldData.Global ifd = (IndexFieldData.Global)indexFieldDataService.getForField(fieldType);
                            ifd.loadGlobal(context.getDirectoryReader());
                            if (indexShard.warmerService().logger().isTraceEnabled()) {
                                indexShard.warmerService().logger().trace("warmed global ordinals for [{}], took [{}]", fieldType.names().fullName(), TimeValue.timeValueNanos(System.nanoTime() - start));
                            }
                        }
                        catch (Throwable t) {
                            indexShard.warmerService().logger().warn("failed to warm-up global ordinals for [{}]", t, fieldType.names().fullName());
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            return new IndicesWarmer.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }
    }

    static class NormsWarmer
    extends IndicesWarmer.Listener {
        NormsWarmer() {
        }

        @Override
        public IndicesWarmer.TerminationHandle warmNewReaders(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            MappedFieldType.Loading defaultLoading = MappedFieldType.Loading.parse(indexMetaData.getSettings().get(SearchService.NORMS_LOADING_KEY), MappedFieldType.Loading.LAZY);
            MapperService mapperService = indexShard.mapperService();
            ObjectHashSet warmUp = new ObjectHashSet();
            for (DocumentMapper docMapper : mapperService.docMappers(false)) {
                for (FieldMapper fieldMapper : docMapper.mappers()) {
                    String indexName = fieldMapper.fieldType().names().indexName();
                    MappedFieldType.Loading normsLoading = fieldMapper.fieldType().normsLoading();
                    if (normsLoading == null) {
                        normsLoading = defaultLoading;
                    }
                    if (fieldMapper.fieldType().indexOptions() == IndexOptions.NONE || fieldMapper.fieldType().omitNorms() || normsLoading != MappedFieldType.Loading.EAGER) continue;
                    warmUp.add((Object)indexName);
                }
            }
            final CountDownLatch latch = new CountDownLatch(1);
            threadPool.executor(this.executor()).execute(new Runnable((ObjectSet)warmUp, context, indexShard, latch){
                final /* synthetic */ ObjectSet val$warmUp;
                final /* synthetic */ IndicesWarmer.WarmerContext val$context;
                final /* synthetic */ IndexShard val$indexShard;
                final /* synthetic */ CountDownLatch val$latch;
                {
                    this.val$warmUp = objectSet;
                    this.val$context = warmerContext;
                    this.val$indexShard = indexShard;
                    this.val$latch = countDownLatch;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (ObjectCursor stringObjectCursor : this.val$warmUp) {
                            String indexName = (String)stringObjectCursor.value;
                            long start = System.nanoTime();
                            for (LeafReaderContext ctx : this.val$context.searcher().reader().leaves()) {
                                NumericDocValues values = ctx.reader().getNormValues(indexName);
                                if (values == null) continue;
                                values.get(0);
                            }
                            if (!this.val$indexShard.warmerService().logger().isTraceEnabled()) continue;
                            this.val$indexShard.warmerService().logger().trace("warmed norms for [{}], took [{}]", indexName, TimeValue.timeValueNanos(System.nanoTime() - start));
                        }
                    }
                    catch (Throwable t) {
                        this.val$indexShard.warmerService().logger().warn("failed to warm-up norms", t, new Object[0]);
                    }
                    finally {
                        this.val$latch.countDown();
                    }
                }
            });
            return new IndicesWarmer.TerminationHandle(){

                @Override
                public void awaitTermination() throws InterruptedException {
                    latch.await();
                }
            };
        }

        @Override
        public IndicesWarmer.TerminationHandle warmTopReader(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext context, ThreadPool threadPool) {
            return IndicesWarmer.TerminationHandle.NO_WAIT;
        }
    }

    class SearchSettingsListener
    implements NodeSettingsService.Listener {
        SearchSettingsListener() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue maybeNewDefaultSearchTimeout = settings.getAsTime(SearchService.DEFAULT_SEARCH_TIMEOUT, SearchService.this.defaultSearchTimeout);
            if (!maybeNewDefaultSearchTimeout.equals(SearchService.this.defaultSearchTimeout)) {
                SearchService.this.logger.info("updating [{}] from [{}] to [{}]", SearchService.DEFAULT_SEARCH_TIMEOUT, SearchService.this.defaultSearchTimeout, maybeNewDefaultSearchTimeout);
                SearchService.this.defaultSearchTimeout = maybeNewDefaultSearchTimeout;
            }
        }
    }
}

