/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.util.ExtensionPoint;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.core.BinaryFieldMapper;
import org.elasticsearch.index.mapper.core.BooleanFieldMapper;
import org.elasticsearch.index.mapper.core.ByteFieldMapper;
import org.elasticsearch.index.mapper.core.CompletionFieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.FloatFieldMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.ShortFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TokenCountFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.geo.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.internal.VersionFieldMapper;
import org.elasticsearch.index.mapper.ip.IpFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.AndQueryParser;
import org.elasticsearch.index.query.BoolQueryParser;
import org.elasticsearch.index.query.BoostingQueryParser;
import org.elasticsearch.index.query.CommonTermsQueryParser;
import org.elasticsearch.index.query.ConstantScoreQueryParser;
import org.elasticsearch.index.query.DisMaxQueryParser;
import org.elasticsearch.index.query.ExistsQueryParser;
import org.elasticsearch.index.query.FQueryFilterParser;
import org.elasticsearch.index.query.FieldMaskingSpanQueryParser;
import org.elasticsearch.index.query.FilteredQueryParser;
import org.elasticsearch.index.query.FuzzyQueryParser;
import org.elasticsearch.index.query.GeoBoundingBoxQueryParser;
import org.elasticsearch.index.query.GeoDistanceQueryParser;
import org.elasticsearch.index.query.GeoDistanceRangeQueryParser;
import org.elasticsearch.index.query.GeoPolygonQueryParser;
import org.elasticsearch.index.query.GeoShapeQueryParser;
import org.elasticsearch.index.query.GeohashCellQuery;
import org.elasticsearch.index.query.HasChildQueryParser;
import org.elasticsearch.index.query.HasParentQueryParser;
import org.elasticsearch.index.query.IdsQueryParser;
import org.elasticsearch.index.query.IndicesQueryParser;
import org.elasticsearch.index.query.LimitQueryParser;
import org.elasticsearch.index.query.MatchAllQueryParser;
import org.elasticsearch.index.query.MatchQueryParser;
import org.elasticsearch.index.query.MissingQueryParser;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.MultiMatchQueryParser;
import org.elasticsearch.index.query.NestedQueryParser;
import org.elasticsearch.index.query.NotQueryParser;
import org.elasticsearch.index.query.OrQueryParser;
import org.elasticsearch.index.query.PrefixQueryParser;
import org.elasticsearch.index.query.QueryFilterParser;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryStringQueryParser;
import org.elasticsearch.index.query.RangeQueryParser;
import org.elasticsearch.index.query.RegexpQueryParser;
import org.elasticsearch.index.query.ScriptQueryParser;
import org.elasticsearch.index.query.SimpleQueryStringParser;
import org.elasticsearch.index.query.SpanContainingQueryParser;
import org.elasticsearch.index.query.SpanFirstQueryParser;
import org.elasticsearch.index.query.SpanMultiTermQueryParser;
import org.elasticsearch.index.query.SpanNearQueryParser;
import org.elasticsearch.index.query.SpanNotQueryParser;
import org.elasticsearch.index.query.SpanOrQueryParser;
import org.elasticsearch.index.query.SpanTermQueryParser;
import org.elasticsearch.index.query.SpanWithinQueryParser;
import org.elasticsearch.index.query.TemplateQueryParser;
import org.elasticsearch.index.query.TermQueryParser;
import org.elasticsearch.index.query.TermsQueryParser;
import org.elasticsearch.index.query.TypeQueryParser;
import org.elasticsearch.index.query.WildcardQueryParser;
import org.elasticsearch.index.query.WrapperQueryParser;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryParser;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.analysis.HunspellService;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.indices.cache.request.IndicesRequestCache;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;
import org.elasticsearch.indices.flush.SyncedFlushService;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.indices.query.IndicesQueriesRegistry;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySource;
import org.elasticsearch.indices.recovery.RecoveryTarget;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.indices.ttl.IndicesTTLService;

public class IndicesModule
extends AbstractModule {
    private final ExtensionPoint.ClassSet<QueryParser> queryParsers = new ExtensionPoint.ClassSet<QueryParser>("query_parser", QueryParser.class, (Class<?>[])new Class[0]);
    private final ExtensionPoint.InstanceMap<String, Dictionary> hunspellDictionaries = new ExtensionPoint.InstanceMap<String, Dictionary>("hunspell_dictionary", String.class, Dictionary.class, (Class<?>[])new Class[0]);
    private final Map<String, Mapper.TypeParser> mapperParsers = new LinkedHashMap<String, Mapper.TypeParser>();
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();

    public IndicesModule() {
        this.registerBuiltinQueryParsers();
        this.registerBuiltInMappers();
        this.registerBuiltInMetadataMappers();
    }

    private void registerBuiltinQueryParsers() {
        this.registerQueryParser(MatchQueryParser.class);
        this.registerQueryParser(MultiMatchQueryParser.class);
        this.registerQueryParser(NestedQueryParser.class);
        this.registerQueryParser(HasChildQueryParser.class);
        this.registerQueryParser(HasParentQueryParser.class);
        this.registerQueryParser(DisMaxQueryParser.class);
        this.registerQueryParser(IdsQueryParser.class);
        this.registerQueryParser(MatchAllQueryParser.class);
        this.registerQueryParser(QueryStringQueryParser.class);
        this.registerQueryParser(BoostingQueryParser.class);
        this.registerQueryParser(BoolQueryParser.class);
        this.registerQueryParser(TermQueryParser.class);
        this.registerQueryParser(TermsQueryParser.class);
        this.registerQueryParser(FuzzyQueryParser.class);
        this.registerQueryParser(RegexpQueryParser.class);
        this.registerQueryParser(RangeQueryParser.class);
        this.registerQueryParser(PrefixQueryParser.class);
        this.registerQueryParser(WildcardQueryParser.class);
        this.registerQueryParser(FilteredQueryParser.class);
        this.registerQueryParser(ConstantScoreQueryParser.class);
        this.registerQueryParser(SpanTermQueryParser.class);
        this.registerQueryParser(SpanNotQueryParser.class);
        this.registerQueryParser(SpanWithinQueryParser.class);
        this.registerQueryParser(SpanContainingQueryParser.class);
        this.registerQueryParser(FieldMaskingSpanQueryParser.class);
        this.registerQueryParser(SpanFirstQueryParser.class);
        this.registerQueryParser(SpanNearQueryParser.class);
        this.registerQueryParser(SpanOrQueryParser.class);
        this.registerQueryParser(MoreLikeThisQueryParser.class);
        this.registerQueryParser(WrapperQueryParser.class);
        this.registerQueryParser(IndicesQueryParser.class);
        this.registerQueryParser(CommonTermsQueryParser.class);
        this.registerQueryParser(SpanMultiTermQueryParser.class);
        this.registerQueryParser(FunctionScoreQueryParser.class);
        this.registerQueryParser(SimpleQueryStringParser.class);
        this.registerQueryParser(TemplateQueryParser.class);
        this.registerQueryParser(TypeQueryParser.class);
        this.registerQueryParser(LimitQueryParser.class);
        this.registerQueryParser(ScriptQueryParser.class);
        this.registerQueryParser(GeoDistanceQueryParser.class);
        this.registerQueryParser(GeoDistanceRangeQueryParser.class);
        this.registerQueryParser(GeoBoundingBoxQueryParser.class);
        this.registerQueryParser(GeohashCellQuery.Parser.class);
        this.registerQueryParser(GeoPolygonQueryParser.class);
        this.registerQueryParser(QueryFilterParser.class);
        this.registerQueryParser(FQueryFilterParser.class);
        this.registerQueryParser(AndQueryParser.class);
        this.registerQueryParser(OrQueryParser.class);
        this.registerQueryParser(NotQueryParser.class);
        this.registerQueryParser(ExistsQueryParser.class);
        this.registerQueryParser(MissingQueryParser.class);
        if (ShapesAvailability.JTS_AVAILABLE) {
            this.registerQueryParser(GeoShapeQueryParser.class);
        }
    }

    private void registerBuiltInMappers() {
        this.registerMapper("byte", new ByteFieldMapper.TypeParser());
        this.registerMapper("short", new ShortFieldMapper.TypeParser());
        this.registerMapper("integer", new IntegerFieldMapper.TypeParser());
        this.registerMapper("long", new LongFieldMapper.TypeParser());
        this.registerMapper("float", new FloatFieldMapper.TypeParser());
        this.registerMapper("double", new DoubleFieldMapper.TypeParser());
        this.registerMapper("boolean", new BooleanFieldMapper.TypeParser());
        this.registerMapper("binary", new BinaryFieldMapper.TypeParser());
        this.registerMapper("date", new DateFieldMapper.TypeParser());
        this.registerMapper("ip", new IpFieldMapper.TypeParser());
        this.registerMapper("string", new StringFieldMapper.TypeParser());
        this.registerMapper("token_count", new TokenCountFieldMapper.TypeParser());
        this.registerMapper("object", new ObjectMapper.TypeParser());
        this.registerMapper("nested", new ObjectMapper.TypeParser());
        this.registerMapper("multi_field", TypeParsers.multiFieldConverterTypeParser);
        this.registerMapper("completion", new CompletionFieldMapper.TypeParser());
        this.registerMapper("geo_point", new GeoPointFieldMapper.TypeParser());
        if (ShapesAvailability.JTS_AVAILABLE) {
            this.registerMapper("geo_shape", new GeoShapeFieldMapper.TypeParser());
        }
    }

    private void registerBuiltInMetadataMappers() {
        this.registerMetadataMapper("_uid", new UidFieldMapper.TypeParser());
        this.registerMetadataMapper("_id", new IdFieldMapper.TypeParser());
        this.registerMetadataMapper("_routing", new RoutingFieldMapper.TypeParser());
        this.registerMetadataMapper("_index", new IndexFieldMapper.TypeParser());
        this.registerMetadataMapper("_source", new SourceFieldMapper.TypeParser());
        this.registerMetadataMapper("_type", new TypeFieldMapper.TypeParser());
        this.registerMetadataMapper("_all", new AllFieldMapper.TypeParser());
        this.registerMetadataMapper("_timestamp", new TimestampFieldMapper.TypeParser());
        this.registerMetadataMapper("_ttl", new TTLFieldMapper.TypeParser());
        this.registerMetadataMapper("_version", new VersionFieldMapper.TypeParser());
        this.registerMetadataMapper("_parent", new ParentFieldMapper.TypeParser());
    }

    public void registerQueryParser(Class<? extends QueryParser> queryParser) {
        this.queryParsers.registerExtension(queryParser);
    }

    public void registerHunspellDictionary(String name, Dictionary dictionary) {
        this.hunspellDictionaries.registerExtension(name, dictionary);
    }

    public synchronized void registerMapper(String type, Mapper.TypeParser parser) {
        if (this.mapperParsers.containsKey(type)) {
            throw new IllegalArgumentException("A mapper is already registered for type [" + type + "]");
        }
        this.mapperParsers.put(type, parser);
    }

    public synchronized void registerMetadataMapper(String name, MetadataFieldMapper.TypeParser parser) {
        if (this.metadataMapperParsers.containsKey(name)) {
            throw new IllegalArgumentException("A mapper is already registered for metadata mapper [" + name + "]");
        }
        this.metadataMapperParsers.put(name, parser);
    }

    @Override
    protected void configure() {
        this.bindQueryParsersExtension();
        this.bindHunspellExtension();
        this.bindMapperExtension();
        this.bind(IndicesLifecycle.class).to(InternalIndicesLifecycle.class).asEagerSingleton();
        this.bind(IndicesService.class).asEagerSingleton();
        this.bind(RecoverySettings.class).asEagerSingleton();
        this.bind(RecoveryTarget.class).asEagerSingleton();
        this.bind(RecoverySource.class).asEagerSingleton();
        this.bind(IndicesStore.class).asEagerSingleton();
        this.bind(IndicesClusterStateService.class).asEagerSingleton();
        this.bind(IndexingMemoryController.class).asEagerSingleton();
        this.bind(SyncedFlushService.class).asEagerSingleton();
        this.bind(IndicesQueryCache.class).asEagerSingleton();
        this.bind(IndicesRequestCache.class).asEagerSingleton();
        this.bind(IndicesFieldDataCache.class).asEagerSingleton();
        this.bind(TransportNodesListShardStoreMetaData.class).asEagerSingleton();
        this.bind(IndicesTTLService.class).asEagerSingleton();
        this.bind(IndicesWarmer.class).asEagerSingleton();
        this.bind(UpdateHelper.class).asEagerSingleton();
        this.bind(MetaDataIndexUpgradeService.class).asEagerSingleton();
        this.bind(IndicesFieldDataCacheListener.class).asEagerSingleton();
    }

    public synchronized MapperRegistry getMapperRegistry() {
        if (this.metadataMapperParsers.containsKey("_field_names")) {
            throw new IllegalStateException("Metadata mapper [_field_names] is already registered");
        }
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(this.metadataMapperParsers);
        metadataMapperParsers.put("_field_names", new FieldNamesFieldMapper.TypeParser());
        return new MapperRegistry(this.mapperParsers, metadataMapperParsers);
    }

    protected void bindMapperExtension() {
        this.bind(MapperRegistry.class).toInstance(this.getMapperRegistry());
    }

    protected void bindQueryParsersExtension() {
        this.queryParsers.bind(this.binder());
        this.bind(IndicesQueriesRegistry.class).asEagerSingleton();
    }

    protected void bindHunspellExtension() {
        this.hunspellDictionaries.bind(this.binder());
        this.bind(HunspellService.class).asEagerSingleton();
        this.bind(IndicesAnalysisService.class).asEagerSingleton();
    }
}

