/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.termvectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.memory.MemoryIndex;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.termvectors.TermVectorsFilter;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.action.termvectors.dfs.DfsOnlyRequest;
import org.elasticsearch.action.termvectors.dfs.DfsOnlyResponse;
import org.elasticsearch.action.termvectors.dfs.TransportDfsOnlyAction;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.dfs.AggregatedDfs;

public class ShardTermVectorsService
extends AbstractIndexShardComponent {
    private IndexShard indexShard;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final TransportDfsOnlyAction dfsAction;

    @Inject
    public ShardTermVectorsService(ShardId shardId, IndexSettingsService indexSettingsService, MappingUpdatedAction mappingUpdatedAction, TransportDfsOnlyAction dfsAction) {
        super(shardId, indexSettingsService.getSettings());
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.dfsAction = dfsAction;
    }

    public ShardTermVectorsService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    public TermVectorsResponse getTermVectors(TermVectorsRequest request, String concreteIndex) {
        TermVectorsResponse termVectorsResponse;
        block18: {
            termVectorsResponse = new TermVectorsResponse(concreteIndex, request.type(), request.id());
            Term uidTerm = new Term("_uid", Uid.createUidAsBytes(request.type(), request.id()));
            Engine.GetResult get = this.indexShard.get(new Engine.Get(request.realtime(), uidTerm).version(request.version()).versionType(request.versionType()));
            Fields termVectorsByField = null;
            boolean docFromTranslog = get.source() != null;
            AggregatedDfs dfs = null;
            TermVectorsFilter termVectorsFilter = null;
            if (docFromTranslog) {
                request.doc(get.source().source, false);
                termVectorsResponse.setDocVersion(get.version());
            }
            if (request.selectedFields() != null) {
                this.handleFieldWildcards(request);
            }
            Engine.Searcher searcher = this.indexShard.acquireSearcher("term_vector");
            try {
                Fields topLevelFields = MultiFields.getFields((IndexReader)(get.searcher() != null ? get.searcher().reader() : searcher.reader()));
                Versions.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
                if (request.doc() != null) {
                    termVectorsByField = this.generateTermVectorsFromDoc(request, !docFromTranslog);
                    if (topLevelFields == null) {
                        topLevelFields = termVectorsByField;
                    }
                    termVectorsResponse.setArtificial(!docFromTranslog);
                    termVectorsResponse.setExists(true);
                } else if (docIdAndVersion != null) {
                    termVectorsByField = docIdAndVersion.context.reader().getTermVectors(docIdAndVersion.docId);
                    Set<String> selectedFields = request.selectedFields();
                    if (selectedFields == null && request.perFieldAnalyzer() != null) {
                        selectedFields = this.getFieldsToGenerate(request.perFieldAnalyzer(), termVectorsByField);
                    }
                    if (selectedFields != null) {
                        termVectorsByField = this.addGeneratedTermVectors(get, termVectorsByField, request, selectedFields);
                    }
                    termVectorsResponse.setDocVersion(docIdAndVersion.version);
                    termVectorsResponse.setExists(true);
                } else {
                    termVectorsResponse.setExists(false);
                }
                if (termVectorsByField == null) break block18;
                if (this.useDfs(request)) {
                    dfs = this.getAggregatedDfs(termVectorsByField, request);
                }
                if (request.filterSettings() != null) {
                    termVectorsFilter = new TermVectorsFilter(termVectorsByField, topLevelFields, request.selectedFields(), dfs);
                    termVectorsFilter.setSettings(request.filterSettings());
                    try {
                        termVectorsFilter.selectBestTerms();
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("failed to select best terms", (Throwable)e, new Object[0]);
                    }
                }
                termVectorsResponse.setFields(termVectorsByField, request.selectedFields(), request.getFlags(), topLevelFields, dfs, termVectorsFilter);
            }
            catch (Throwable ex) {
                throw new ElasticsearchException("failed to execute term vector request", ex, new Object[0]);
            }
            finally {
                searcher.close();
                get.release();
            }
        }
        return termVectorsResponse;
    }

    private void handleFieldWildcards(TermVectorsRequest request) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String pattern : request.selectedFields()) {
            fieldNames.addAll(this.indexShard.mapperService().simpleMatchToIndexNames(pattern));
        }
        request.selectedFields(fieldNames.toArray(Strings.EMPTY_ARRAY));
    }

    private boolean isValidField(MappedFieldType fieldType) {
        if (!(fieldType instanceof StringFieldMapper.StringFieldType)) {
            return false;
        }
        return fieldType.indexOptions() != IndexOptions.NONE;
    }

    private Fields addGeneratedTermVectors(Engine.GetResult get, Fields termVectorsByField, TermVectorsRequest request, Set<String> selectedFields) throws IOException {
        HashSet<String> validFields = new HashSet<String>();
        for (String field : selectedFields) {
            MappedFieldType fieldType = this.indexShard.mapperService().smartNameFieldType(field);
            if (!this.isValidField(fieldType) || fieldType.storeTermVectors() && (request.perFieldAnalyzer() == null || !request.perFieldAnalyzer().containsKey(field))) continue;
            validFields.add(field);
        }
        if (validFields.isEmpty()) {
            return termVectorsByField;
        }
        GetResult getResult = this.indexShard.getService().get(get, request.id(), request.type(), validFields.toArray(Strings.EMPTY_ARRAY), null, false);
        Fields generatedTermVectors = this.generateTermVectors(getResult.getFields().values(), request.offsets(), request.perFieldAnalyzer(), validFields);
        if (termVectorsByField == null) {
            return generatedTermVectors;
        }
        return this.mergeFields(termVectorsByField, generatedTermVectors);
    }

    private Analyzer getAnalyzerAtField(String field, @Nullable Map<String, String> perFieldAnalyzer) {
        MapperService mapperService = this.indexShard.mapperService();
        NamedAnalyzer analyzer = perFieldAnalyzer != null && perFieldAnalyzer.containsKey(field) ? mapperService.analysisService().analyzer(perFieldAnalyzer.get(field).toString()) : mapperService.smartNameFieldType(field).indexAnalyzer();
        if (analyzer == null) {
            analyzer = mapperService.analysisService().defaultIndexAnalyzer();
        }
        return analyzer;
    }

    private Set<String> getFieldsToGenerate(Map<String, String> perAnalyzerField, Fields fieldsObject) {
        HashSet<String> selectedFields = new HashSet<String>();
        for (String fieldName : fieldsObject) {
            if (!perAnalyzerField.containsKey(fieldName)) continue;
            selectedFields.add(fieldName);
        }
        return selectedFields;
    }

    private Fields generateTermVectors(Collection<GetField> getFields, boolean withOffsets, @Nullable Map<String, String> perFieldAnalyzer, Set<String> fields) throws IOException {
        MemoryIndex index = new MemoryIndex(withOffsets);
        for (GetField getField : getFields) {
            String field = getField.getName();
            if (!fields.contains(field)) continue;
            Analyzer analyzer = this.getAnalyzerAtField(field, perFieldAnalyzer);
            for (Object text : getField.getValues()) {
                index.addField(field, text.toString(), analyzer);
            }
        }
        return MultiFields.getFields((IndexReader)index.createSearcher().getIndexReader());
    }

    private Fields generateTermVectorsFromDoc(TermVectorsRequest request, boolean doAllFields) throws Throwable {
        ParsedDocument parsedDocument = this.parseDocument(this.indexShard.shardId().getIndex(), request.type(), request.doc());
        ParseContext.Document doc = parsedDocument.rootDoc();
        HashSet<String> seenFields = new HashSet<String>();
        HashSet<GetField> getFields = new HashSet<GetField>();
        for (IndexableField field : doc.getFields()) {
            MappedFieldType fieldType = this.indexShard.mapperService().smartNameFieldType(field.name());
            if (!this.isValidField(fieldType) || request.selectedFields() == null && !doAllFields && !fieldType.storeTermVectors() || request.selectedFields() != null && !request.selectedFields().contains(field.name()) || seenFields.contains(field.name())) continue;
            seenFields.add(field.name());
            String[] values = doc.getValues(field.name());
            getFields.add(new GetField(field.name(), Arrays.asList((Object[])values)));
        }
        return this.generateTermVectors(getFields, request.offsets(), request.perFieldAnalyzer(), seenFields);
    }

    private ParsedDocument parseDocument(String index, String type, BytesReference doc) throws Throwable {
        MapperService mapperService = this.indexShard.mapperService();
        DocumentMapperForType docMapper = mapperService.documentMapperWithAutoCreate(type);
        ParsedDocument parsedDocument = docMapper.getDocumentMapper().parse(SourceToParse.source(doc).index(index).type(type).flyweight(true));
        if (docMapper.getMapping() != null) {
            parsedDocument.addDynamicMappingsUpdate(docMapper.getMapping());
        }
        if (parsedDocument.dynamicMappingsUpdate() != null) {
            this.mappingUpdatedAction.updateMappingOnMasterSynchronously(index, type, parsedDocument.dynamicMappingsUpdate());
        }
        return parsedDocument;
    }

    private Fields mergeFields(Fields fields1, Fields fields2) throws IOException {
        Terms terms;
        ParallelFields parallelFields = new ParallelFields();
        for (String fieldName : fields2) {
            terms = fields2.terms(fieldName);
            if (terms == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        for (String fieldName : fields1) {
            if (parallelFields.fields.containsKey(fieldName) || (terms = fields1.terms(fieldName)) == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        return parallelFields;
    }

    private boolean useDfs(TermVectorsRequest request) {
        return request.dfs() && (request.fieldStatistics() || request.termStatistics());
    }

    private AggregatedDfs getAggregatedDfs(Fields termVectorsFields, TermVectorsRequest request) throws IOException {
        DfsOnlyRequest dfsOnlyRequest = new DfsOnlyRequest(termVectorsFields, new String[]{request.index()}, new String[]{request.type()}, request.selectedFields());
        DfsOnlyResponse response = (DfsOnlyResponse)this.dfsAction.execute(dfsOnlyRequest).actionGet();
        return response.getDfs();
    }

    private static final class ParallelFields
    extends Fields {
        final Map<String, Terms> fields = new TreeMap<String, Terms>();

        ParallelFields() {
        }

        void addField(String fieldName, Terms terms) {
            this.fields.put(fieldName, terms);
        }

        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        public Terms terms(String field) {
            return this.fields.get(field);
        }

        public int size() {
            return this.fields.size();
        }
    }
}

