/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanTermQueryBuilder
extends SpanQueryBuilder
implements BoostableQueryBuilder<SpanTermQueryBuilder> {
    private final String name;
    private final Object value;
    private float boost = -1.0f;
    private String queryName;

    public SpanTermQueryBuilder(String name, String value) {
        this(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, int value) {
        this(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, long value) {
        this(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, float value) {
        this(name, Float.valueOf(value));
    }

    public SpanTermQueryBuilder(String name, double value) {
        this(name, (Object)value);
    }

    private SpanTermQueryBuilder(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public SpanTermQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public SpanTermQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("span_term");
        if (this.boost == -1.0f && this.queryName != null) {
            builder.field(this.name, this.value);
        } else {
            builder.startObject(this.name);
            builder.field("value", this.value);
            if (this.boost != -1.0f) {
                builder.field("boost", this.boost);
            }
            if (this.queryName != null) {
                builder.field("_name", this.queryName);
            }
            builder.endObject();
        }
        builder.endObject();
    }
}

