/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class NotQueryParser
implements QueryParser {
    public static final String NAME = "not";
    private static final ParseField QUERY_FIELD = new ParseField("filter", "query");

    @Inject
    public NotQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query query = null;
        boolean queryFound = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    query = parseContext.parseInnerFilter();
                    queryFound = true;
                    continue;
                }
                queryFound = true;
                query = parseContext.parseInnerFilter(currentFieldName);
                continue;
            }
            if (!token.isValue()) continue;
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[not] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext, "filter is required when using `not` query", new Object[0]);
        }
        if (query == null) {
            return null;
        }
        Query notQuery = Queries.not(query);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, notQuery);
        }
        return notQuery;
    }
}

