/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Query;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.XContentStructure;

public class IndicesQueryParser
implements QueryParser {
    public static final String NAME = "indices";
    private static final ParseField QUERY_FIELD = new ParseField("query", "filter");
    private static final ParseField NO_MATCH_QUERY = new ParseField("no_match_query", "no_match_filter");
    @Nullable
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public IndicesQueryParser(@Nullable ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        Query noMatchQuery = null;
        boolean queryFound = false;
        boolean indicesFound = false;
        boolean currentIndexMatchesIndices = false;
        String queryName = null;
        String currentFieldName = null;
        XContentStructure.InnerQuery innerQuery = null;
        XContentStructure.InnerQuery innerNoMatchQuery = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, QUERY_FIELD)) {
                    innerQuery = new XContentStructure.InnerQuery(parseContext, null);
                    queryFound = true;
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, NO_MATCH_QUERY)) {
                    innerNoMatchQuery = new XContentStructure.InnerQuery(parseContext, null);
                    continue;
                }
                throw new QueryParsingException(parseContext, "[indices] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (NAME.equals(currentFieldName)) {
                    if (indicesFound) {
                        throw new QueryParsingException(parseContext, "[indices] indices or index already specified", new Object[0]);
                    }
                    indicesFound = true;
                    ArrayList<String> indices = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        String value = parser.textOrNull();
                        if (value == null) {
                            throw new QueryParsingException(parseContext, "[indices] no value specified for 'indices' entry", new Object[0]);
                        }
                        indices.add(value);
                    }
                    currentIndexMatchesIndices = this.matchesIndices(parseContext.index().name(), indices.toArray(new String[indices.size()]));
                    continue;
                }
                throw new QueryParsingException(parseContext, "[indices] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if ("index".equals(currentFieldName)) {
                if (indicesFound) {
                    throw new QueryParsingException(parseContext, "[indices] indices or index already specified", new Object[0]);
                }
                indicesFound = true;
                currentIndexMatchesIndices = this.matchesIndices(parseContext.index().name(), parser.text());
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, NO_MATCH_QUERY)) {
                String type = parser.text();
                if ("all".equals(type)) {
                    noMatchQuery = Queries.newMatchAllQuery();
                    continue;
                }
                if (!"none".equals(type)) continue;
                noMatchQuery = Queries.newMatchNoDocsQuery();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext, "[indices] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queryFound) {
            throw new QueryParsingException(parseContext, "[indices] requires 'query' element", new Object[0]);
        }
        if (!indicesFound) {
            throw new QueryParsingException(parseContext, "[indices] requires 'indices' or 'index' element", new Object[0]);
        }
        Query chosenQuery = currentIndexMatchesIndices ? innerQuery.asQuery(new String[0]) : (noMatchQuery != null ? noMatchQuery : (innerNoMatchQuery == null ? Queries.newMatchAllQuery() : innerNoMatchQuery.asQuery(new String[0])));
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, chosenQuery);
        }
        return chosenQuery;
    }

    protected boolean matchesIndices(String currentIndex, String ... indices) {
        String[] concreteIndices;
        for (String index : concreteIndices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), indices)) {
            if (!Regex.simpleMatch(index, currentIndex)) continue;
            return true;
        }
        return false;
    }
}

