/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.support.QueryInnerHitBuilder;

public class HasChildQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<HasChildQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private String childType;
    private float boost = 1.0f;
    private String scoreMode;
    private Integer minChildren;
    private Integer maxChildren;
    private Integer shortCircuitCutoff;
    private String queryName;
    private QueryInnerHitBuilder innerHit = null;

    public HasChildQueryBuilder(String type, QueryBuilder queryBuilder) {
        this.childType = type;
        this.queryBuilder = queryBuilder;
    }

    @Override
    public HasChildQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public HasChildQueryBuilder scoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Deprecated
    public HasChildQueryBuilder scoreType(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    public HasChildQueryBuilder minChildren(int minChildren) {
        this.minChildren = minChildren;
        return this;
    }

    public HasChildQueryBuilder maxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
        return this;
    }

    public HasChildQueryBuilder setShortCircuitCutoff(int shortCircuitCutoff) {
        this.shortCircuitCutoff = shortCircuitCutoff;
        return this;
    }

    public HasChildQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public HasChildQueryBuilder innerHit(QueryInnerHitBuilder innerHit) {
        this.innerHit = innerHit;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("has_child");
        builder.field("query");
        this.queryBuilder.toXContent(builder, params);
        builder.field("child_type", this.childType);
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.scoreMode != null) {
            builder.field("score_mode", this.scoreMode);
        }
        if (this.minChildren != null) {
            builder.field("min_children", this.minChildren);
        }
        if (this.maxChildren != null) {
            builder.field("max_children", this.maxChildren);
        }
        if (this.shortCircuitCutoff != null) {
            builder.field("short_circuit_cutoff", this.shortCircuitCutoff);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        if (this.innerHit != null) {
            builder.startObject("inner_hits");
            builder.value(this.innerHit);
            builder.endObject();
        }
        builder.endObject();
    }
}

