/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class BoostingQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<BoostingQueryBuilder> {
    private QueryBuilder positiveQuery;
    private QueryBuilder negativeQuery;
    private float negativeBoost = -1.0f;
    private float boost = -1.0f;

    public BoostingQueryBuilder positive(QueryBuilder positiveQuery) {
        this.positiveQuery = positiveQuery;
        return this;
    }

    public BoostingQueryBuilder negative(QueryBuilder negativeQuery) {
        this.negativeQuery = negativeQuery;
        return this;
    }

    public BoostingQueryBuilder negativeBoost(float negativeBoost) {
        this.negativeBoost = negativeBoost;
        return this;
    }

    @Override
    public BoostingQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.positiveQuery == null) {
            throw new IllegalArgumentException("boosting query requires positive query to be set");
        }
        if (this.negativeQuery == null) {
            throw new IllegalArgumentException("boosting query requires negative query to be set");
        }
        if (this.negativeBoost == -1.0f) {
            throw new IllegalArgumentException("boosting query requires negativeBoost to be set");
        }
        builder.startObject("boosting");
        builder.field("positive");
        this.positiveQuery.toXContent(builder, params);
        builder.field("negative");
        this.negativeQuery.toXContent(builder, params);
        builder.field("negative_boost", this.negativeBoost);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

