/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class GetStats
implements Streamable,
ToXContent {
    private long existsCount;
    private long existsTimeInMillis;
    private long missingCount;
    private long missingTimeInMillis;
    private long current;

    public GetStats() {
    }

    public GetStats(long existsCount, long existsTimeInMillis, long missingCount, long missingTimeInMillis, long current) {
        this.existsCount = existsCount;
        this.existsTimeInMillis = existsTimeInMillis;
        this.missingCount = missingCount;
        this.missingTimeInMillis = missingTimeInMillis;
        this.current = current;
    }

    public void add(GetStats stats) {
        if (stats == null) {
            return;
        }
        this.current += stats.current;
        this.addTotals(stats);
    }

    public void addTotals(GetStats stats) {
        if (stats == null) {
            return;
        }
        this.existsCount += stats.existsCount;
        this.existsTimeInMillis += stats.existsTimeInMillis;
        this.missingCount += stats.missingCount;
        this.missingTimeInMillis += stats.missingTimeInMillis;
        this.current += stats.current;
    }

    public long getCount() {
        return this.existsCount + this.missingCount;
    }

    public long getTimeInMillis() {
        return this.existsTimeInMillis + this.missingTimeInMillis;
    }

    public TimeValue getTime() {
        return new TimeValue(this.getTimeInMillis());
    }

    public long getExistsCount() {
        return this.existsCount;
    }

    public long getExistsTimeInMillis() {
        return this.existsTimeInMillis;
    }

    public TimeValue getExistsTime() {
        return new TimeValue(this.existsTimeInMillis);
    }

    public long getMissingCount() {
        return this.missingCount;
    }

    public long getMissingTimeInMillis() {
        return this.missingTimeInMillis;
    }

    public TimeValue getMissingTime() {
        return new TimeValue(this.missingTimeInMillis);
    }

    public long current() {
        return this.current;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.GET);
        builder.field(Fields.TOTAL, this.getCount());
        builder.timeValueField(Fields.TIME_IN_MILLIS, Fields.TIME, this.getTimeInMillis());
        builder.field(Fields.EXISTS_TOTAL, this.existsCount);
        builder.timeValueField(Fields.EXISTS_TIME_IN_MILLIS, Fields.EXISTS_TIME, this.existsTimeInMillis);
        builder.field(Fields.MISSING_TOTAL, this.missingCount);
        builder.timeValueField(Fields.MISSING_TIME_IN_MILLIS, Fields.MISSING_TIME, this.missingTimeInMillis);
        builder.field(Fields.CURRENT, this.current);
        builder.endObject();
        return builder;
    }

    public static GetStats readGetStats(StreamInput in) throws IOException {
        GetStats stats = new GetStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.existsCount = in.readVLong();
        this.existsTimeInMillis = in.readVLong();
        this.missingCount = in.readVLong();
        this.missingTimeInMillis = in.readVLong();
        this.current = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.existsCount);
        out.writeVLong(this.existsTimeInMillis);
        out.writeVLong(this.missingCount);
        out.writeVLong(this.missingTimeInMillis);
        out.writeVLong(this.current);
    }

    static final class Fields {
        static final XContentBuilderString GET = new XContentBuilderString("get");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TIME = new XContentBuilderString("getTime");
        static final XContentBuilderString TIME_IN_MILLIS = new XContentBuilderString("time_in_millis");
        static final XContentBuilderString EXISTS_TOTAL = new XContentBuilderString("exists_total");
        static final XContentBuilderString EXISTS_TIME = new XContentBuilderString("exists_time");
        static final XContentBuilderString EXISTS_TIME_IN_MILLIS = new XContentBuilderString("exists_time_in_millis");
        static final XContentBuilderString MISSING_TOTAL = new XContentBuilderString("missing_total");
        static final XContentBuilderString MISSING_TIME = new XContentBuilderString("missing_time");
        static final XContentBuilderString MISSING_TIME_IN_MILLIS = new XContentBuilderString("missing_time_in_millis");
        static final XContentBuilderString CURRENT = new XContentBuilderString("current");

        Fields() {
        }
    }
}

