/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVNumericIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public abstract class DocValuesIndexFieldData {
    protected final Index index;
    protected final MappedFieldType.Names fieldNames;
    protected final FieldDataType fieldDataType;
    protected final ESLogger logger;

    public DocValuesIndexFieldData(Index index, MappedFieldType.Names fieldNames, FieldDataType fieldDataType) {
        this.index = index;
        this.fieldNames = fieldNames;
        this.fieldDataType = fieldDataType;
        this.logger = Loggers.getLogger(this.getClass());
    }

    public final MappedFieldType.Names getFieldNames() {
        return this.fieldNames;
    }

    public final FieldDataType getFieldDataType() {
        return this.fieldDataType;
    }

    public final void clear() {
    }

    public final void clear(IndexReader reader) {
    }

    public final Index index() {
        return this.index;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private static final Set<String> BINARY_INDEX_FIELD_NAMES = ImmutableSet.of((Object)"_uid", (Object)"_id");
        private static final Set<String> NUMERIC_INDEX_FIELD_NAMES = ImmutableSet.of((Object)"_timestamp");
        private IndexNumericFieldData.NumericType numericType;

        public Builder numericType(IndexNumericFieldData.NumericType type) {
            this.numericType = type;
            return this;
        }

        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            MappedFieldType.Names fieldNames = fieldType.names();
            Settings fdSettings = fieldType.fieldDataType().getSettings();
            Map<String, Settings> filter = fdSettings.getGroups("filter");
            if (filter != null && !filter.isEmpty()) {
                throw new IllegalArgumentException("Doc values field data doesn't support filters [" + fieldNames.fullName() + "]");
            }
            if (BINARY_INDEX_FIELD_NAMES.contains(fieldNames.indexName())) {
                assert (this.numericType == null);
                return new BinaryDVIndexFieldData(index, fieldNames, fieldType.fieldDataType());
            }
            if (this.numericType != null) {
                if ("_timestamp".equals(fieldNames.indexName()) || Version.indexCreated(indexSettings).onOrAfter(Version.V_1_4_0_Beta1)) {
                    return new SortedNumericDVIndexFieldData(index, fieldNames, this.numericType, fieldType.fieldDataType());
                }
                return new BinaryDVNumericIndexFieldData(index, fieldNames, this.numericType, fieldType.fieldDataType());
            }
            return new SortedSetDVOrdinalsIndexFieldData(index, cache, indexSettings, fieldNames, breakerService, fieldType.fieldDataType());
        }
    }
}

