/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.el.GreekLowerCaseFilter;
import org.apache.lucene.analysis.ga.IrishLowerCaseFilter;
import org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class LowerCaseTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final String lang;

    @Inject
    public LowerCaseTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.lang = settings.get("language", null);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.lang == null) {
            return new LowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("greek")) {
            return new GreekLowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("irish")) {
            return new IrishLowerCaseFilter(tokenStream);
        }
        if (this.lang.equalsIgnoreCase("turkish")) {
            return new TurkishLowerCaseFilter(tokenStream);
        }
        throw new IllegalArgumentException("language [" + this.lang + "] not support for lower case");
    }
}

