/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.index.Index;

public class MetaStateService
extends AbstractComponent {
    static final String FORMAT_SETTING = "gateway.format";
    static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final String INDEX_STATE_FILE_PREFIX = "state-";
    private final NodeEnvironment nodeEnv;
    private final XContentType format;
    private final ToXContent.Params formatParams;
    private final ToXContent.Params gatewayModeFormatParams;
    private final MetaDataStateFormat<IndexMetaData> indexStateFormat;
    private final MetaDataStateFormat<MetaData> globalStateFormat;

    @Inject
    public MetaStateService(Settings settings, NodeEnvironment nodeEnv) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.format = XContentType.fromRestContentType(settings.get(FORMAT_SETTING, "smile"));
        if (this.format == XContentType.SMILE) {
            HashMap params = Maps.newHashMap();
            params.put("binary", "true");
            this.formatParams = new ToXContent.MapParams(params);
            HashMap gatewayModeParams = Maps.newHashMap();
            gatewayModeParams.put("binary", "true");
            gatewayModeParams.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
            this.gatewayModeFormatParams = new ToXContent.MapParams(gatewayModeParams);
        } else {
            this.formatParams = ToXContent.EMPTY_PARAMS;
            HashMap gatewayModeParams = Maps.newHashMap();
            gatewayModeParams.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
            this.gatewayModeFormatParams = new ToXContent.MapParams(gatewayModeParams);
        }
        this.indexStateFormat = MetaStateService.indexStateFormat(this.format, this.formatParams);
        this.globalStateFormat = MetaStateService.globalStateFormat(this.format, this.gatewayModeFormatParams);
    }

    MetaData loadFullState() throws Exception {
        MetaData globalMetaData = this.loadGlobalState();
        MetaData.Builder metaDataBuilder = globalMetaData != null ? MetaData.builder(globalMetaData) : MetaData.builder();
        Set<String> indices = this.nodeEnv.findAllIndices();
        for (String index : indices) {
            IndexMetaData indexMetaData = this.loadIndexState(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] failed to find metadata for existing index location", index);
                continue;
            }
            metaDataBuilder.put(indexMetaData, false);
        }
        return metaDataBuilder.build();
    }

    @Nullable
    IndexMetaData loadIndexState(String index) throws IOException {
        return this.indexStateFormat.loadLatestState(this.logger, this.nodeEnv.indexPaths(new Index(index)));
    }

    MetaData loadGlobalState() throws IOException {
        MetaData globalState = this.globalStateFormat.loadLatestState(this.logger, this.nodeEnv.nodeDataPaths());
        if (globalState != null) {
            return MetaData.addDefaultUnitsIfNeeded(this.logger, globalState);
        }
        return null;
    }

    void writeIndex(String reason, IndexMetaData indexMetaData, @Nullable IndexMetaData previousIndexMetaData) throws Exception {
        this.logger.trace("[{}] writing state, reason [{}]", indexMetaData.getIndex(), reason);
        try {
            this.indexStateFormat.write(indexMetaData, indexMetaData.getVersion(), this.nodeEnv.indexPaths(new Index(indexMetaData.getIndex())));
        }
        catch (Throwable ex) {
            this.logger.warn("[{}]: failed to write index state", ex, indexMetaData.getIndex());
            throw new IOException("failed to write state for [" + indexMetaData.getIndex() + "]", ex);
        }
    }

    void writeGlobalState(String reason, MetaData metaData) throws Exception {
        this.logger.trace("[_global] writing state, reason [{}]", reason);
        try {
            this.globalStateFormat.write(metaData, metaData.version(), this.nodeEnv.nodeDataPaths());
        }
        catch (Throwable ex) {
            this.logger.warn("[_global]: failed to write global state", ex, new Object[0]);
            throw new IOException("failed to write global state", ex);
        }
    }

    static MetaDataStateFormat<MetaData> globalStateFormat(XContentType format, final ToXContent.Params formatParams) {
        return new MetaDataStateFormat<MetaData>(format, GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, MetaData state) throws IOException {
                MetaData.Builder.toXContent(state, builder, formatParams);
            }

            @Override
            public MetaData fromXContent(XContentParser parser) throws IOException {
                return MetaData.Builder.fromXContent(parser);
            }
        };
    }

    static MetaDataStateFormat<IndexMetaData> indexStateFormat(XContentType format, final ToXContent.Params formatParams) {
        return new MetaDataStateFormat<IndexMetaData>(format, INDEX_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, IndexMetaData state) throws IOException {
                IndexMetaData.Builder.toXContent(state, builder, formatParams);
            }

            @Override
            public IndexMetaData fromXContent(XContentParser parser) throws IOException {
                return IndexMetaData.Builder.fromXContent(parser);
            }
        };
    }
}

