/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.slf4j;

import org.elasticsearch.common.logging.support.AbstractESLogger;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;

public class Slf4jESLogger
extends AbstractESLogger {
    private final Logger logger;
    private final LocationAwareLogger lALogger;
    private final String FQCN = AbstractESLogger.class.getName();

    public Slf4jESLogger(String prefix, Logger logger) {
        super(prefix);
        this.logger = logger;
        this.lALogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
    }

    @Override
    public void setLevel(String level) {
    }

    @Override
    public String getLevel() {
        return null;
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    protected void internalTrace(String msg) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 0, msg, null, null);
        } else {
            this.logger.trace(msg);
        }
    }

    @Override
    protected void internalTrace(String msg, Throwable cause) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 0, msg, null, cause);
        } else {
            this.logger.trace(msg);
        }
    }

    @Override
    protected void internalDebug(String msg) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 10, msg, null, null);
        } else {
            this.logger.debug(msg);
        }
    }

    @Override
    protected void internalDebug(String msg, Throwable cause) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 10, msg, null, cause);
        } else {
            this.logger.debug(msg);
        }
    }

    @Override
    protected void internalInfo(String msg) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 20, msg, null, null);
        } else {
            this.logger.info(msg);
        }
    }

    @Override
    protected void internalInfo(String msg, Throwable cause) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 20, msg, null, cause);
        } else {
            this.logger.info(msg, cause);
        }
    }

    @Override
    protected void internalWarn(String msg) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 30, msg, null, null);
        } else {
            this.logger.warn(msg);
        }
    }

    @Override
    protected void internalWarn(String msg, Throwable cause) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 30, msg, null, cause);
        } else {
            this.logger.warn(msg);
        }
    }

    @Override
    protected void internalError(String msg) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 40, msg, null, null);
        } else {
            this.logger.error(msg);
        }
    }

    @Override
    protected void internalError(String msg, Throwable cause) {
        if (this.lALogger != null) {
            this.lALogger.log(null, this.FQCN, 40, msg, null, cause);
        } else {
            this.logger.error(msg);
        }
    }

    protected Logger logger() {
        return this.logger;
    }
}

