/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.service;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.ProcessClusterEventTimeoutException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.PendingClusterTask;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.PrioritizedEsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.PrioritizedRunnable;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class InternalClusterService
extends AbstractLifecycleComponent<ClusterService>
implements ClusterService {
    public static final String SETTING_CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD = "cluster.service.slow_task_logging_threshold";
    public static final String SETTING_CLUSTER_SERVICE_RECONNECT_INTERVAL = "cluster.service.reconnect_interval";
    public static final String UPDATE_THREAD_NAME = "clusterService#updateTask";
    private final ThreadPool threadPool;
    private final DiscoveryService discoveryService;
    private final OperationRouting operationRouting;
    private final TransportService transportService;
    private final NodeSettingsService nodeSettingsService;
    private final DiscoveryNodeService discoveryNodeService;
    private final Version version;
    private final TimeValue reconnectInterval;
    private TimeValue slowTaskLoggingThreshold;
    private volatile PrioritizedEsThreadPoolExecutor updateTasksExecutor;
    private final Collection<ClusterStateListener> priorityClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> clusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Collection<ClusterStateListener> lastClusterStateListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Map<ClusterStateTaskExecutor, List<UpdateTask>> updateTasksPerExecutor = new HashMap<ClusterStateTaskExecutor, List<UpdateTask>>();
    private final Collection<ClusterStateListener> postAppliedListeners = new CopyOnWriteArrayList<ClusterStateListener>();
    private final Iterable<ClusterStateListener> preAppliedListeners = Iterables.concat(this.priorityClusterStateListeners, this.clusterStateListeners, this.lastClusterStateListeners);
    private final LocalNodeMasterListeners localNodeMasterListeners;
    private final Queue<NotifyTimeout> onGoingTimeouts = ConcurrentCollections.newQueue();
    private volatile ClusterState clusterState;
    private final ClusterBlocks.Builder initialBlocks;
    private volatile ScheduledFuture reconnectToNodes;

    @Inject
    public InternalClusterService(Settings settings, DiscoveryService discoveryService, OperationRouting operationRouting, TransportService transportService, NodeSettingsService nodeSettingsService, ThreadPool threadPool, ClusterName clusterName, DiscoveryNodeService discoveryNodeService, Version version) {
        super(settings);
        this.operationRouting = operationRouting;
        this.transportService = transportService;
        this.discoveryService = discoveryService;
        this.threadPool = threadPool;
        this.nodeSettingsService = nodeSettingsService;
        this.discoveryNodeService = discoveryNodeService;
        this.version = version;
        this.clusterState = ClusterState.builder(clusterName).build();
        this.nodeSettingsService.setClusterService(this);
        this.nodeSettingsService.addListener(new ApplySettings());
        this.reconnectInterval = this.settings.getAsTime(SETTING_CLUSTER_SERVICE_RECONNECT_INTERVAL, TimeValue.timeValueSeconds(10L));
        this.slowTaskLoggingThreshold = this.settings.getAsTime(SETTING_CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD, TimeValue.timeValueSeconds(30L));
        this.localNodeMasterListeners = new LocalNodeMasterListeners(threadPool);
        this.initialBlocks = ClusterBlocks.builder().addGlobalBlock(discoveryService.getNoMasterBlock());
    }

    public NodeSettingsService settingsService() {
        return this.nodeSettingsService;
    }

    @Override
    public void addInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.addGlobalBlock(block);
    }

    @Override
    public void removeInitialStateBlock(ClusterBlock block) throws IllegalStateException {
        if (this.lifecycle.started()) {
            throw new IllegalStateException("can't set initial block when started");
        }
        this.initialBlocks.removeGlobalBlock(block);
    }

    @Override
    protected void doStart() {
        this.add(this.localNodeMasterListeners);
        this.clusterState = ClusterState.builder(this.clusterState).blocks(this.initialBlocks).build();
        this.updateTasksExecutor = EsExecutors.newSinglePrioritizing(UPDATE_THREAD_NAME, EsExecutors.daemonThreadFactory(this.settings, UPDATE_THREAD_NAME));
        this.reconnectToNodes = this.threadPool.schedule(this.reconnectInterval, "generic", new ReconnectToNodes());
        Map<String, String> nodeAttributes = this.discoveryNodeService.buildAttributes();
        String nodeId = DiscoveryService.generateNodeId(this.settings);
        TransportAddress publishAddress = this.transportService.boundAddress().publishAddress();
        DiscoveryNode localNode = new DiscoveryNode(this.settings.get("name"), nodeId, publishAddress, nodeAttributes, this.version);
        DiscoveryNodes.Builder nodeBuilder = DiscoveryNodes.builder().put(localNode).localNodeId(localNode.id());
        this.clusterState = ClusterState.builder(this.clusterState).nodes(nodeBuilder).blocks(this.initialBlocks).build();
        this.transportService.setLocalNode(localNode);
    }

    @Override
    protected void doStop() {
        FutureUtils.cancel(this.reconnectToNodes);
        for (NotifyTimeout onGoingTimeout : this.onGoingTimeouts) {
            onGoingTimeout.cancel();
            onGoingTimeout.listener.onClose();
        }
        ThreadPool.terminate(this.updateTasksExecutor, 10L, TimeUnit.SECONDS);
        this.remove(this.localNodeMasterListeners);
    }

    @Override
    protected void doClose() {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.clusterState.getNodes().localNode();
    }

    @Override
    public OperationRouting operationRouting() {
        return this.operationRouting;
    }

    @Override
    public ClusterState state() {
        return this.clusterState;
    }

    @Override
    public void addFirst(ClusterStateListener listener) {
        this.priorityClusterStateListeners.add(listener);
    }

    @Override
    public void addLast(ClusterStateListener listener) {
        this.lastClusterStateListeners.add(listener);
    }

    @Override
    public void add(ClusterStateListener listener) {
        this.clusterStateListeners.add(listener);
    }

    @Override
    public void remove(ClusterStateListener listener) {
        this.clusterStateListeners.remove(listener);
        this.priorityClusterStateListeners.remove(listener);
        this.lastClusterStateListeners.remove(listener);
        this.postAppliedListeners.remove(listener);
        Iterator it = this.onGoingTimeouts.iterator();
        while (it.hasNext()) {
            NotifyTimeout timeout = (NotifyTimeout)it.next();
            if (!timeout.listener.equals(listener)) continue;
            timeout.cancel();
            it.remove();
        }
    }

    @Override
    public void add(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.add(listener);
    }

    @Override
    public void remove(LocalNodeMasterListener listener) {
        this.localNodeMasterListeners.remove(listener);
    }

    @Override
    public void add(final @Nullable TimeValue timeout, final TimeoutClusterStateListener listener) {
        if (this.lifecycle.stoppedOrClosed()) {
            listener.onClose();
            return;
        }
        try {
            this.updateTasksExecutor.execute(new SourcePrioritizedRunnable(Priority.HIGH, "_add_listener_"){

                @Override
                public void run() {
                    if (timeout != null) {
                        NotifyTimeout notifyTimeout = new NotifyTimeout(listener, timeout);
                        notifyTimeout.future = InternalClusterService.this.threadPool.schedule(timeout, "generic", notifyTimeout);
                        InternalClusterService.this.onGoingTimeouts.add(notifyTimeout);
                    }
                    InternalClusterService.this.postAppliedListeners.add(listener);
                    listener.postAdded();
                }
            });
        }
        catch (EsRejectedExecutionException e) {
            if (this.lifecycle.stoppedOrClosed()) {
                listener.onClose();
            }
            throw e;
        }
    }

    @Override
    public void submitStateUpdateTask(String source, ClusterStateUpdateTask updateTask) {
        this.submitStateUpdateTask(source, updateTask, updateTask, updateTask, updateTask);
    }

    @Override
    public <T> void submitStateUpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
        this.innerSubmitStateUpdateTask(source, task, config, executor, InternalClusterService.safe(listener, this.logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void innerSubmitStateUpdateTask(final String source, T task, final ClusterStateTaskConfig config, ClusterStateTaskExecutor executor, final SafeClusterStateTaskListener listener) {
        block9: {
            if (!this.lifecycle.started()) {
                return;
            }
            try {
                final UpdateTask<T> updateTask = new UpdateTask<T>(source, task, config, executor, listener);
                Map<ClusterStateTaskExecutor, List<UpdateTask>> map = this.updateTasksPerExecutor;
                synchronized (map) {
                    List<UpdateTask> updateTasksForExecutor = this.updateTasksPerExecutor.get(executor);
                    if (updateTasksForExecutor == null) {
                        this.updateTasksPerExecutor.put(executor, new ArrayList());
                    }
                    this.updateTasksPerExecutor.get(executor).add(updateTask);
                }
                if (config.timeout() != null) {
                    this.updateTasksExecutor.execute(updateTask, this.threadPool.scheduler(), config.timeout(), new Runnable(){

                        @Override
                        public void run() {
                            InternalClusterService.this.threadPool.generic().execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (!updateTask.processed.getAndSet(true)) {
                                        listener.onFailure(source, new ProcessClusterEventTimeoutException(config.timeout(), source));
                                    }
                                }
                            });
                        }
                    });
                } else {
                    this.updateTasksExecutor.execute(updateTask);
                }
            }
            catch (EsRejectedExecutionException e) {
                if (this.lifecycle.stoppedOrClosed()) break block9;
                throw e;
            }
        }
    }

    @Override
    public List<PendingClusterTask> pendingTasks() {
        PrioritizedEsThreadPoolExecutor.Pending[] pendings = this.updateTasksExecutor.getPending();
        ArrayList<PendingClusterTask> pendingClusterTasks = new ArrayList<PendingClusterTask>(pendings.length);
        for (PrioritizedEsThreadPoolExecutor.Pending pending : pendings) {
            long timeInQueue;
            String source;
            Object task = pending.task;
            if (task == null) continue;
            if (task instanceof SourcePrioritizedRunnable) {
                SourcePrioritizedRunnable runnable = (SourcePrioritizedRunnable)task;
                source = runnable.source();
                timeInQueue = runnable.getAgeInMillis();
            } else {
                assert (false) : "expected SourcePrioritizedRunnable got " + task.getClass();
                source = "unknown [" + task.getClass() + "]";
                timeInQueue = 0L;
            }
            pendingClusterTasks.add(new PendingClusterTask(pending.insertionOrder, pending.priority, new Text(source), timeInQueue, pending.executing));
        }
        return pendingClusterTasks;
    }

    @Override
    public int numberOfPendingTasks() {
        return this.updateTasksExecutor.getNumberOfPendingTasks();
    }

    @Override
    public TimeValue getMaxTaskWaitTime() {
        return this.updateTasksExecutor.getMaxTaskWaitTime();
    }

    public boolean assertClusterStateThread() {
        assert (Thread.currentThread().getName().contains(UPDATE_THREAD_NAME)) : "not called from the cluster state update thread";
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void runTasksForExecutor(ClusterStateTaskExecutor<T> executor) {
        StringBuilder sb;
        ClusterStateTaskExecutor.BatchResult<Object> batchResult;
        ArrayList<UpdateTask> toExecute = new ArrayList<UpdateTask>();
        ArrayList<String> sources = new ArrayList<String>();
        Map<ClusterStateTaskExecutor, List<UpdateTask>> map = this.updateTasksPerExecutor;
        synchronized (map) {
            List<UpdateTask> pending = this.updateTasksPerExecutor.remove(executor);
            if (pending != null) {
                for (UpdateTask updateTask : pending) {
                    if (!updateTask.processed.getAndSet(true)) {
                        this.logger.trace("will process [{}]", updateTask.source);
                        toExecute.add(updateTask);
                        sources.add(updateTask.source);
                        continue;
                    }
                    this.logger.trace("skipping [{}], already processed", updateTask.source);
                }
            }
        }
        if (toExecute.isEmpty()) {
            return;
        }
        String source = Strings.collectionToCommaDelimitedString(sources);
        if (!this.lifecycle.started()) {
            this.logger.debug("processing [{}]: ignoring, cluster_service not started", source);
            return;
        }
        this.logger.debug("processing [{}]: execute", source);
        ClusterState previousClusterState = this.clusterState;
        if (!previousClusterState.nodes().localNodeMaster() && executor.runOnlyOnMaster()) {
            this.logger.debug("failing [{}]: local node is no longer master", source);
            for (UpdateTask<Object> updateTask : toExecute) {
                updateTask.listener.onNoLongerMaster(updateTask.source);
            }
            return;
        }
        long l = System.nanoTime();
        ArrayList inputs = new ArrayList();
        for (UpdateTask updateTask : toExecute) {
            inputs.add(updateTask.task);
        }
        try {
            batchResult = executor.execute(previousClusterState, inputs);
        }
        catch (Throwable e) {
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - l)));
            if (this.logger.isTraceEnabled()) {
                StringBuilder sb2 = new StringBuilder("failed to execute cluster state update in ").append(executionTime).append(", state:\nversion [").append(previousClusterState.version()).append("], source [").append(source).append("]\n");
                sb2.append(previousClusterState.nodes().prettyPrint());
                sb2.append(previousClusterState.routingTable().prettyPrint());
                sb2.append(previousClusterState.getRoutingNodes().prettyPrint());
                this.logger.trace(sb2.toString(), e, new Object[0]);
            }
            this.warnAboutSlowTaskIfNeeded(executionTime, source);
            batchResult = ClusterStateTaskExecutor.BatchResult.builder().failures(inputs, e).build(previousClusterState);
        }
        assert (batchResult.executionResults != null);
        assert (batchResult.executionResults.size() == toExecute.size()) : String.format(Locale.ROOT, "expected [%d] task result%s but was [%d]", toExecute.size(), toExecute.size() == 1 ? "" : "s", batchResult.executionResults.size());
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            for (UpdateTask updateTask : toExecute) {
                assert (batchResult.executionResults.containsKey(updateTask.task)) : "missing task result for [" + updateTask.task + "]";
            }
        }
        ClusterState newClusterState = batchResult.resultingState;
        final ArrayList proccessedListeners = new ArrayList();
        for (final UpdateTask updateTask : toExecute) {
            assert (batchResult.executionResults.containsKey(updateTask.task)) : "missing " + updateTask.task.toString();
            ClusterStateTaskExecutor.TaskResult executionResult = batchResult.executionResults.get(updateTask.task);
            executionResult.handle(new Runnable(){

                @Override
                public void run() {
                    proccessedListeners.add(updateTask);
                }
            }, new ClusterStateTaskExecutor.TaskResult.FailureConsumer(){

                @Override
                public void accept(Throwable ex) {
                    InternalClusterService.this.logger.debug("cluster state update task [{}] failed", ex, updateTask.source);
                    updateTask.listener.onFailure(updateTask.source, ex);
                }
            });
        }
        if (previousClusterState == newClusterState) {
            for (UpdateTask task : proccessedListeners) {
                if (task.listener instanceof AckedClusterStateTaskListener) {
                    ((AckedClusterStateTaskListener)task.listener).onAllNodesAcked(null);
                }
                task.listener.clusterStateProcessed(task.source, previousClusterState, newClusterState);
            }
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - l)));
            this.logger.debug("processing [{}]: took {} no change in cluster_state", source, executionTime);
            this.warnAboutSlowTaskIfNeeded(executionTime, source);
            return;
        }
        try {
            String summary;
            ArrayList<AckCountDownListener> ackListeners = new ArrayList<AckCountDownListener>();
            if (newClusterState.nodes().localNodeMaster()) {
                ClusterState.Builder builder = ClusterState.builder(newClusterState).incrementVersion();
                if (previousClusterState.routingTable() != newClusterState.routingTable()) {
                    builder.routingTable(RoutingTable.builder(newClusterState.routingTable()).version(newClusterState.routingTable().version() + 1L).build());
                }
                if (previousClusterState.metaData() != newClusterState.metaData()) {
                    builder.metaData(MetaData.builder(newClusterState.metaData()).version(newClusterState.metaData().version() + 1L));
                }
                newClusterState = builder.build();
                for (UpdateTask task : proccessedListeners) {
                    if (!(task.listener instanceof AckedClusterStateTaskListener)) continue;
                    AckedClusterStateTaskListener ackedListener = (AckedClusterStateTaskListener)task.listener;
                    if (ackedListener.ackTimeout() == null || ackedListener.ackTimeout().millis() == 0L) {
                        ackedListener.onAckTimeout();
                        continue;
                    }
                    try {
                        ackListeners.add(new AckCountDownListener(ackedListener, newClusterState.version(), newClusterState.nodes(), this.threadPool));
                    }
                    catch (EsRejectedExecutionException ex) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Couldn't schedule timeout thread - node might be shutting down", ex, new Object[0]);
                        }
                        ackedListener.onAckTimeout();
                    }
                }
            }
            DelegetingAckListener ackListener = new DelegetingAckListener(ackListeners);
            newClusterState.status(ClusterState.ClusterStateStatus.BEING_APPLIED);
            if (this.logger.isTraceEnabled()) {
                sb = new StringBuilder("cluster state updated, source [").append(source).append("]\n");
                sb.append(newClusterState.prettyPrint());
                this.logger.trace(sb.toString(), new Object[0]);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("cluster state updated, version [{}], source [{}]", newClusterState.version(), source);
            }
            ClusterChangedEvent clusterChangedEvent = new ClusterChangedEvent(source, newClusterState, previousClusterState);
            DiscoveryNodes.Delta nodesDelta = clusterChangedEvent.nodesDelta();
            if (nodesDelta.hasChanges() && this.logger.isInfoEnabled() && (summary = nodesDelta.shortSummary()).length() > 0) {
                this.logger.info("{}, reason: {}", summary, source);
            }
            for (DiscoveryNode node : nodesDelta.addedNodes()) {
                if (!this.nodeRequiresConnection(node)) continue;
                try {
                    this.transportService.connectToNode(node);
                }
                catch (Throwable e) {
                    this.logger.warn("failed to connect to node [" + node + "]", e, new Object[0]);
                }
            }
            if (newClusterState.nodes().localNodeMaster()) {
                this.logger.debug("publishing cluster state version [{}]", newClusterState.version());
                this.discoveryService.publish(clusterChangedEvent, ackListener);
            }
            this.clusterState = newClusterState;
            this.logger.debug("set local cluster state to version {}", newClusterState.version());
            for (ClusterStateListener listener : this.preAppliedListeners) {
                try {
                    listener.clusterChanged(clusterChangedEvent);
                }
                catch (Exception ex) {
                    this.logger.warn("failed to notify ClusterStateListener", ex, new Object[0]);
                }
            }
            for (DiscoveryNode node : nodesDelta.removedNodes()) {
                try {
                    this.transportService.disconnectFromNode(node);
                }
                catch (Throwable e) {
                    this.logger.warn("failed to disconnect to node [" + node + "]", e, new Object[0]);
                }
            }
            newClusterState.status(ClusterState.ClusterStateStatus.APPLIED);
            for (ClusterStateListener listener : this.postAppliedListeners) {
                try {
                    listener.clusterChanged(clusterChangedEvent);
                }
                catch (Exception ex) {
                    this.logger.warn("failed to notify ClusterStateListener", ex, new Object[0]);
                }
            }
            if (newClusterState.nodes().localNodeMaster()) {
                try {
                    ackListener.onNodeAck(newClusterState.nodes().localNode(), null);
                }
                catch (Throwable t) {
                    this.logger.debug("error while processing ack for master node [{}]", t, newClusterState.nodes().localNode());
                }
            }
            for (UpdateTask task : proccessedListeners) {
                task.listener.clusterStateProcessed(task.source, previousClusterState, newClusterState);
            }
            executor.clusterStatePublished(newClusterState);
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - l)));
            this.logger.debug("processing [{}]: took {} done applying updated cluster_state (version: {}, uuid: {})", source, executionTime, newClusterState.version(), newClusterState.stateUUID());
            this.warnAboutSlowTaskIfNeeded(executionTime, source);
        }
        catch (Throwable t) {
            TimeValue executionTime = TimeValue.timeValueMillis(Math.max(0L, TimeValue.nsecToMSec(System.nanoTime() - l)));
            sb = new StringBuilder("failed to apply updated cluster state in ").append(executionTime).append(":\nversion [").append(newClusterState.version()).append("], uuid [").append(newClusterState.stateUUID()).append("], source [").append(source).append("]\n");
            sb.append(newClusterState.nodes().prettyPrint());
            sb.append(newClusterState.routingTable().prettyPrint());
            sb.append(newClusterState.getRoutingNodes().prettyPrint());
            this.logger.warn(sb.toString(), t, new Object[0]);
        }
    }

    private static SafeClusterStateTaskListener safe(ClusterStateTaskListener listener, ESLogger logger) {
        if (listener instanceof AckedClusterStateTaskListener) {
            return new SafeAckedClusterStateTaskListener((AckedClusterStateTaskListener)listener, logger);
        }
        return new SafeClusterStateTaskListener(listener, logger);
    }

    private void warnAboutSlowTaskIfNeeded(TimeValue executionTime, String source) {
        if (executionTime.getMillis() > this.slowTaskLoggingThreshold.getMillis()) {
            this.logger.warn("cluster state update task [{}] took {} above the warn threshold of {}", source, executionTime, this.slowTaskLoggingThreshold);
        }
    }

    private boolean nodeRequiresConnection(DiscoveryNode node) {
        return this.localNode().shouldConnectTo(node);
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue slowTaskLoggingThreshold = settings.getAsTime(InternalClusterService.SETTING_CLUSTER_SERVICE_SLOW_TASK_LOGGING_THRESHOLD, InternalClusterService.this.slowTaskLoggingThreshold);
            InternalClusterService.this.slowTaskLoggingThreshold = slowTaskLoggingThreshold;
        }
    }

    private static class AckCountDownListener
    implements Discovery.AckListener {
        private static final ESLogger logger = Loggers.getLogger(AckCountDownListener.class);
        private final AckedClusterStateTaskListener ackedTaskListener;
        private final CountDown countDown;
        private final DiscoveryNodes nodes;
        private final long clusterStateVersion;
        private final Future<?> ackTimeoutCallback;
        private Throwable lastFailure;

        AckCountDownListener(AckedClusterStateTaskListener ackedTaskListener, long clusterStateVersion, DiscoveryNodes nodes, ThreadPool threadPool) {
            this.ackedTaskListener = ackedTaskListener;
            this.clusterStateVersion = clusterStateVersion;
            this.nodes = nodes;
            int countDown = 0;
            for (DiscoveryNode node : nodes) {
                if (!ackedTaskListener.mustAck(node)) continue;
                ++countDown;
            }
            countDown = Math.max(1, countDown);
            logger.trace("expecting {} acknowledgements for cluster_state update (version: {})", countDown, clusterStateVersion);
            this.countDown = new CountDown(countDown);
            this.ackTimeoutCallback = threadPool.schedule(ackedTaskListener.ackTimeout(), "generic", new Runnable(){

                @Override
                public void run() {
                    AckCountDownListener.this.onTimeout();
                }
            });
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Throwable t) {
            if (!this.ackedTaskListener.mustAck(node) && !node.equals(this.nodes.masterNode())) {
                return;
            }
            if (t == null) {
                logger.trace("ack received from node [{}], cluster_state update (version: {})", node, this.clusterStateVersion);
            } else {
                this.lastFailure = t;
                logger.debug("ack received from node [{}], cluster_state update (version: {})", t, node, this.clusterStateVersion);
            }
            if (this.countDown.countDown()) {
                logger.trace("all expected nodes acknowledged cluster_state update (version: {})", this.clusterStateVersion);
                FutureUtils.cancel(this.ackTimeoutCallback);
                this.ackedTaskListener.onAllNodesAcked(this.lastFailure);
            }
        }

        @Override
        public void onTimeout() {
            if (this.countDown.fastForward()) {
                logger.trace("timeout waiting for acknowledgement for cluster_state update (version: {})", this.clusterStateVersion);
                this.ackedTaskListener.onAckTimeout();
            }
        }
    }

    private static class DelegetingAckListener
    implements Discovery.AckListener {
        private final List<Discovery.AckListener> listeners;

        private DelegetingAckListener(List<Discovery.AckListener> listeners) {
            this.listeners = listeners;
        }

        @Override
        public void onNodeAck(DiscoveryNode node, @Nullable Throwable t) {
            for (Discovery.AckListener listener : this.listeners) {
                listener.onNodeAck(node, t);
            }
        }

        @Override
        public void onTimeout() {
            throw new UnsupportedOperationException("no timeout delegation");
        }
    }

    private static class OffMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OffMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.offMaster();
        }
    }

    private static class OnMasterRunnable
    implements Runnable {
        private final LocalNodeMasterListener listener;

        private OnMasterRunnable(LocalNodeMasterListener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            this.listener.onMaster();
        }
    }

    private static class LocalNodeMasterListeners
    implements ClusterStateListener {
        private final List<LocalNodeMasterListener> listeners = new CopyOnWriteArrayList<LocalNodeMasterListener>();
        private final ThreadPool threadPool;
        private volatile boolean master = false;

        private LocalNodeMasterListeners(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void clusterChanged(ClusterChangedEvent event) {
            if (!this.master && event.localNodeMaster()) {
                this.master = true;
                for (LocalNodeMasterListener listener : this.listeners) {
                    Executor executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OnMasterRunnable(listener));
                }
                return;
            }
            if (this.master && !event.localNodeMaster()) {
                this.master = false;
                for (LocalNodeMasterListener listener : this.listeners) {
                    Executor executor = this.threadPool.executor(listener.executorName());
                    executor.execute(new OffMasterRunnable(listener));
                }
            }
        }

        private void add(LocalNodeMasterListener listener) {
            this.listeners.add(listener);
        }

        private void remove(LocalNodeMasterListener listener) {
            this.listeners.remove(listener);
        }

        private void clear() {
            this.listeners.clear();
        }
    }

    private class ReconnectToNodes
    implements Runnable {
        private ConcurrentMap<DiscoveryNode, Integer> failureCount = ConcurrentCollections.newConcurrentMap();

        private ReconnectToNodes() {
        }

        @Override
        public void run() {
            for (DiscoveryNode node : InternalClusterService.this.clusterState.nodes()) {
                if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                    return;
                }
                if (!InternalClusterService.this.nodeRequiresConnection(node) || !InternalClusterService.this.clusterState.nodes().nodeExists(node.id()) || InternalClusterService.this.transportService.nodeConnected(node)) continue;
                try {
                    InternalClusterService.this.transportService.connectToNode(node);
                }
                catch (Exception e) {
                    if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                        return;
                    }
                    if (!InternalClusterService.this.clusterState.nodes().nodeExists(node.id())) continue;
                    Integer nodeFailureCount = (Integer)this.failureCount.get(node);
                    nodeFailureCount = nodeFailureCount == null ? Integer.valueOf(1) : Integer.valueOf(nodeFailureCount + 1);
                    if (nodeFailureCount % 6 == 0) {
                        nodeFailureCount = 0;
                        InternalClusterService.this.logger.warn("failed to reconnect to node {}", e, node);
                    }
                    this.failureCount.put(node, nodeFailureCount);
                }
            }
            DiscoveryNodes nodes = InternalClusterService.this.clusterState.nodes();
            Iterator failedNodesIt = this.failureCount.keySet().iterator();
            while (failedNodesIt.hasNext()) {
                DiscoveryNode failedNode = (DiscoveryNode)failedNodesIt.next();
                if (nodes.nodeExists(failedNode.id())) continue;
                failedNodesIt.remove();
            }
            if (InternalClusterService.this.lifecycle.started()) {
                InternalClusterService.this.reconnectToNodes = InternalClusterService.this.threadPool.schedule(InternalClusterService.this.reconnectInterval, "generic", this);
            }
        }
    }

    class NotifyTimeout
    implements Runnable {
        final TimeoutClusterStateListener listener;
        final TimeValue timeout;
        volatile ScheduledFuture future;

        NotifyTimeout(TimeoutClusterStateListener listener, TimeValue timeout) {
            this.listener = listener;
            this.timeout = timeout;
        }

        public void cancel() {
            FutureUtils.cancel(this.future);
        }

        @Override
        public void run() {
            if (this.future != null && this.future.isCancelled()) {
                return;
            }
            if (InternalClusterService.this.lifecycle.stoppedOrClosed()) {
                this.listener.onClose();
            } else {
                this.listener.onTimeout(this.timeout);
            }
        }
    }

    class UpdateTask<T>
    extends SourcePrioritizedRunnable {
        public final T task;
        public final ClusterStateTaskConfig config;
        public final ClusterStateTaskExecutor<T> executor;
        public final ClusterStateTaskListener listener;
        public final AtomicBoolean processed;

        UpdateTask(String source, T task, ClusterStateTaskConfig config, ClusterStateTaskExecutor<T> executor, ClusterStateTaskListener listener) {
            super(config.priority(), source);
            this.processed = new AtomicBoolean();
            this.task = task;
            this.config = config;
            this.executor = executor;
            this.listener = listener;
        }

        @Override
        public void run() {
            InternalClusterService.this.runTasksForExecutor(this.executor);
        }
    }

    private static class SafeAckedClusterStateTaskListener
    extends SafeClusterStateTaskListener
    implements AckedClusterStateTaskListener {
        private final AckedClusterStateTaskListener listener;
        private final ESLogger logger;

        public SafeAckedClusterStateTaskListener(AckedClusterStateTaskListener listener, ESLogger logger) {
            super(listener, logger);
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public boolean mustAck(DiscoveryNode discoveryNode) {
            return this.listener.mustAck(discoveryNode);
        }

        @Override
        public void onAllNodesAcked(@Nullable Throwable t) {
            try {
                this.listener.onAllNodesAcked(t);
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying on all nodes acked [{}]", e, t);
            }
        }

        @Override
        public void onAckTimeout() {
            try {
                this.listener.onAckTimeout();
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying on ack timeout", e, new Object[0]);
            }
        }

        @Override
        public TimeValue ackTimeout() {
            return this.listener.ackTimeout();
        }
    }

    private static class SafeClusterStateTaskListener
    implements ClusterStateTaskListener {
        private final ClusterStateTaskListener listener;
        private final ESLogger logger;

        public SafeClusterStateTaskListener(ClusterStateTaskListener listener, ESLogger logger) {
            this.listener = listener;
            this.logger = logger;
        }

        @Override
        public void onFailure(String source, Throwable t) {
            try {
                this.listener.onFailure(source, t);
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener notifying of failure [{}] from [{}]", e, t, source);
            }
        }

        @Override
        public void onNoLongerMaster(String source) {
            try {
                this.listener.onNoLongerMaster(source);
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying no longer master from [{}]", e, source);
            }
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            try {
                this.listener.clusterStateProcessed(source, oldState, newState);
            }
            catch (Exception e) {
                this.logger.error("exception thrown by listener while notifying of cluster state processed from [{}], old cluster state:\n{}\nnew cluster state:\n{}", e, source, oldState.prettyPrint(), newState.prettyPrint());
            }
        }
    }

    static abstract class SourcePrioritizedRunnable
    extends PrioritizedRunnable {
        protected final String source;

        public SourcePrioritizedRunnable(Priority priority, String source) {
            super(priority);
            this.source = source;
        }

        public String source() {
            return this.source;
        }
    }
}

