/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationExplanation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.index.shard.ShardId;

public class RoutingAllocation {
    private final AllocationDeciders deciders;
    private final RoutingNodes routingNodes;
    private final DiscoveryNodes nodes;
    private final AllocationExplanation explanation = new AllocationExplanation();
    private final ClusterInfo clusterInfo;
    private Map<ShardId, Set<String>> ignoredShardToNodes = null;
    private boolean ignoreDisable = false;
    private boolean debugDecision = false;
    private boolean hasPendingAsyncFetch = false;
    private final long currentNanoTime;

    public RoutingAllocation(AllocationDeciders deciders, RoutingNodes routingNodes, DiscoveryNodes nodes, ClusterInfo clusterInfo, long currentNanoTime) {
        this.deciders = deciders;
        this.routingNodes = routingNodes;
        this.nodes = nodes;
        this.clusterInfo = clusterInfo;
        this.currentNanoTime = currentNanoTime;
    }

    public long getCurrentNanoTime() {
        return this.currentNanoTime;
    }

    public AllocationDeciders deciders() {
        return this.deciders;
    }

    public RoutingTable routingTable() {
        return this.routingNodes.routingTable();
    }

    public RoutingNodes routingNodes() {
        return this.routingNodes;
    }

    public MetaData metaData() {
        return this.routingNodes.metaData();
    }

    public DiscoveryNodes nodes() {
        return this.nodes;
    }

    public ClusterInfo clusterInfo() {
        return this.clusterInfo;
    }

    public AllocationExplanation explanation() {
        return this.explanation;
    }

    public void ignoreDisable(boolean ignoreDisable) {
        this.ignoreDisable = ignoreDisable;
    }

    public boolean ignoreDisable() {
        return this.ignoreDisable;
    }

    public void debugDecision(boolean debug) {
        this.debugDecision = debug;
    }

    public boolean debugDecision() {
        return this.debugDecision;
    }

    public void addIgnoreShardForNode(ShardId shardId, String nodeId) {
        Set<String> nodes;
        if (this.ignoredShardToNodes == null) {
            this.ignoredShardToNodes = new HashMap<ShardId, Set<String>>();
        }
        if ((nodes = this.ignoredShardToNodes.get(shardId)) == null) {
            nodes = new HashSet<String>();
            this.ignoredShardToNodes.put(shardId, nodes);
        }
        nodes.add(nodeId);
    }

    public boolean shouldIgnoreShardForNode(ShardId shardId, String nodeId) {
        if (this.ignoredShardToNodes == null) {
            return false;
        }
        Set<String> nodes = this.ignoredShardToNodes.get(shardId);
        return nodes != null && nodes.contains(nodeId);
    }

    public Set<String> getIgnoreNodes(ShardId shardId) {
        if (this.ignoredShardToNodes == null) {
            return ImmutableSet.of();
        }
        Set<String> ignore = this.ignoredShardToNodes.get(shardId);
        if (ignore == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(ignore);
    }

    public Decision decision(Decision decision, String deciderLabel, String reason, Object ... params) {
        if (this.debugDecision()) {
            return Decision.single(decision.type(), deciderLabel, reason, params);
        }
        return decision;
    }

    public boolean hasPendingAsyncFetch() {
        return this.hasPendingAsyncFetch;
    }

    public void setHasPendingAsyncFetch() {
        this.hasPendingAsyncFetch = true;
    }

    public static class Result {
        private final boolean changed;
        private final RoutingTable routingTable;
        private RoutingExplanations explanations = new RoutingExplanations();

        public Result(boolean changed, RoutingTable routingTable) {
            this.changed = changed;
            this.routingTable = routingTable;
        }

        public Result(boolean changed, RoutingTable routingTable, RoutingExplanations explanations) {
            this.changed = changed;
            this.routingTable = routingTable;
            this.explanations = explanations;
        }

        public boolean changed() {
            return this.changed;
        }

        public RoutingTable routingTable() {
            return this.routingTable;
        }

        public RoutingExplanations explanations() {
            return this.explanations;
        }
    }
}

