/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.transport.TransportAddressSerializers;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DiscoveryNode
implements Streamable,
ToXContent {
    public static final Version MINIMUM_DISCOVERY_NODE_VERSION = Version.CURRENT.minimumCompatibilityVersion();
    public static final List<DiscoveryNode> EMPTY_LIST = Collections.emptyList();
    private String nodeName = "";
    private String nodeId;
    private String hostName;
    private String hostAddress;
    private TransportAddress address;
    private ImmutableMap<String, String> attributes;
    private Version version = Version.CURRENT;

    public static boolean localNode(Settings settings) {
        if (settings.get("node.local") != null) {
            return settings.getAsBoolean("node.local", (Boolean)false);
        }
        if (settings.get("node.mode") != null) {
            String nodeMode = settings.get("node.mode");
            if ("local".equals(nodeMode)) {
                return true;
            }
            if ("network".equals(nodeMode)) {
                return false;
            }
            throw new IllegalArgumentException("unsupported node.mode [" + nodeMode + "]. Should be one of [local, network].");
        }
        return false;
    }

    public static boolean nodeRequiresLocalStorage(Settings settings) {
        return settings.getAsBoolean("node.client", (Boolean)false) == false && (settings.getAsBoolean("node.data", (Boolean)true) != false || settings.getAsBoolean("node.master", (Boolean)true) != false);
    }

    public static boolean clientNode(Settings settings) {
        String client = settings.get("node.client");
        return Booleans.isExplicitTrue(client);
    }

    public static boolean masterNode(Settings settings) {
        String master = settings.get("node.master");
        if (master == null) {
            return !DiscoveryNode.clientNode(settings);
        }
        return Booleans.isExplicitTrue(master);
    }

    public static boolean dataNode(Settings settings) {
        String data = settings.get("node.data");
        if (data == null) {
            return !DiscoveryNode.clientNode(settings);
        }
        return Booleans.isExplicitTrue(data);
    }

    DiscoveryNode() {
    }

    public DiscoveryNode(String nodeId, TransportAddress address, Version version) {
        this("", nodeId, address, (Map<String, String>)ImmutableMap.of(), version);
    }

    public DiscoveryNode(String nodeName, String nodeId, TransportAddress address, Map<String, String> attributes, Version version) {
        this(nodeName, nodeId, address.getHost(), address.getAddress(), address, attributes, version);
    }

    public DiscoveryNode(String nodeName, String nodeId, String hostName, String hostAddress, TransportAddress address, Map<String, String> attributes, Version version) {
        if (nodeName != null) {
            this.nodeName = nodeName.intern();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            builder.put((Object)entry.getKey().intern(), (Object)entry.getValue().intern());
        }
        this.attributes = builder.build();
        this.nodeId = nodeId.intern();
        this.hostName = hostName.intern();
        this.hostAddress = hostAddress.intern();
        this.address = address;
        this.version = version;
    }

    public boolean shouldConnectTo(DiscoveryNode otherNode) {
        return !this.clientNode() || !otherNode.clientNode();
    }

    public TransportAddress address() {
        return this.address;
    }

    public TransportAddress getAddress() {
        return this.address();
    }

    public String id() {
        return this.nodeId;
    }

    public String getId() {
        return this.id();
    }

    public String name() {
        return this.nodeName;
    }

    public String getName() {
        return this.name();
    }

    public ImmutableMap<String, String> attributes() {
        return this.attributes;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes();
    }

    public boolean dataNode() {
        String data = (String)this.attributes.get((Object)"data");
        if (data == null) {
            return !this.clientNode();
        }
        return Booleans.parseBooleanExact(data);
    }

    public boolean isDataNode() {
        return this.dataNode();
    }

    public boolean clientNode() {
        String client = (String)this.attributes.get((Object)"client");
        return client != null && Booleans.parseBooleanExact(client) != false;
    }

    public boolean isClientNode() {
        return this.clientNode();
    }

    public boolean masterNode() {
        String master = (String)this.attributes.get((Object)"master");
        if (master == null) {
            return !this.clientNode();
        }
        return Booleans.parseBooleanExact(master);
    }

    public boolean isMasterNode() {
        return this.masterNode();
    }

    public Version version() {
        return this.version;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public Version getVersion() {
        return this.version;
    }

    public static DiscoveryNode readNode(StreamInput in) throws IOException {
        DiscoveryNode node = new DiscoveryNode();
        node.readFrom(in);
        return node;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.nodeName = in.readString().intern();
        this.nodeId = in.readString().intern();
        this.hostName = in.readString().intern();
        this.hostAddress = in.readString().intern();
        this.address = TransportAddressSerializers.addressFromStream(in);
        int size = in.readVInt();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < size; ++i) {
            builder.put((Object)in.readString().intern(), (Object)in.readString().intern());
        }
        this.attributes = builder.build();
        this.version = Version.readVersion(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.nodeName);
        out.writeString(this.nodeId);
        out.writeString(this.hostName);
        out.writeString(this.hostAddress);
        TransportAddressSerializers.addressToStream(out, this.address);
        out.writeVInt(this.attributes.size());
        for (Map.Entry entry : this.attributes.entrySet()) {
            out.writeString((String)entry.getKey());
            out.writeString((String)entry.getValue());
        }
        Version.writeVersion(this.version, out);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiscoveryNode)) {
            return false;
        }
        DiscoveryNode other = (DiscoveryNode)obj;
        return this.nodeId.equals(other.nodeId);
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.nodeName.length() > 0) {
            sb.append('{').append(this.nodeName).append('}');
        }
        if (this.nodeId != null) {
            sb.append('{').append(this.nodeId).append('}');
        }
        if (Strings.hasLength(this.hostName)) {
            sb.append('{').append(this.hostName).append('}');
        }
        if (this.address != null) {
            sb.append('{').append(this.address).append('}');
        }
        if (!this.attributes.isEmpty()) {
            sb.append(this.attributes);
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.id(), XContentBuilder.FieldCaseConversion.NONE);
        builder.field("name", this.name());
        builder.field("transport_address", this.address().toString());
        builder.startObject("attributes");
        for (Map.Entry attr : this.attributes().entrySet()) {
            builder.field((String)attr.getKey(), (String)attr.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

