/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.get.MultiGetShardRequest;
import org.elasticsearch.action.get.MultiGetShardResponse;
import org.elasticsearch.action.get.TransportShardMultiGetAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportMultiGetAction
extends HandledTransportAction<MultiGetRequest, MultiGetResponse> {
    private final ClusterService clusterService;
    private final TransportShardMultiGetAction shardAction;

    @Inject
    public TransportMultiGetAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportShardMultiGetAction shardAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "indices:data/read/mget", threadPool, transportService, actionFilters, indexNameExpressionResolver, MultiGetRequest.class);
        this.clusterService = clusterService;
        this.shardAction = shardAction;
    }

    @Override
    protected void doExecute(MultiGetRequest request, final ActionListener<MultiGetResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        final AtomicArray<MultiGetItemResponse> responses = new AtomicArray<MultiGetItemResponse>(request.items.size());
        HashMap<ShardId, MultiGetShardRequest> shardRequests = new HashMap<ShardId, MultiGetShardRequest>();
        for (int i = 0; i < request.items.size(); ++i) {
            MultiGetRequest.Item item = request.items.get(i);
            if (!clusterState.metaData().hasConcreteIndex(item.index())) {
                responses.set(i, new MultiGetItemResponse(null, new MultiGetResponse.Failure(item.index(), item.type(), item.id(), new IndexNotFoundException(item.index()))));
                continue;
            }
            item.routing(clusterState.metaData().resolveIndexRouting(item.routing(), item.index()));
            String concreteSingleIndex = this.indexNameExpressionResolver.concreteSingleIndex(clusterState, item);
            if (item.routing() == null && clusterState.getMetaData().routingRequired(concreteSingleIndex, item.type())) {
                responses.set(i, new MultiGetItemResponse(null, new MultiGetResponse.Failure(concreteSingleIndex, item.type(), item.id(), new IllegalArgumentException("routing is required for [" + concreteSingleIndex + "]/[" + item.type() + "]/[" + item.id() + "]"))));
                continue;
            }
            ShardId shardId = this.clusterService.operationRouting().getShards(clusterState, concreteSingleIndex, item.type(), item.id(), item.routing(), null).shardId();
            MultiGetShardRequest shardRequest = (MultiGetShardRequest)shardRequests.get(shardId);
            if (shardRequest == null) {
                shardRequest = new MultiGetShardRequest(request, shardId.index().name(), shardId.id());
                shardRequests.put(shardId, shardRequest);
            }
            shardRequest.add(i, item);
        }
        if (shardRequests.size() == 0) {
            listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
        }
        final AtomicInteger counter = new AtomicInteger(shardRequests.size());
        for (final MultiGetShardRequest shardRequest : shardRequests.values()) {
            this.shardAction.execute(shardRequest, new ActionListener<MultiGetShardResponse>(){

                @Override
                public void onResponse(MultiGetShardResponse response) {
                    for (int i = 0; i < response.locations.size(); ++i) {
                        responses.set(response.locations.get(i), new MultiGetItemResponse(response.responses.get(i), response.failures.get(i)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    for (int i = 0; i < shardRequest.locations.size(); ++i) {
                        MultiGetRequest.Item item = shardRequest.items.get(i);
                        responses.set(shardRequest.locations.get(i), new MultiGetItemResponse(null, new MultiGetResponse.Failure(shardRequest.index(), item.type(), item.id(), e)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new MultiGetResponse(responses.toArray(new MultiGetItemResponse[responses.length()])));
                }
            });
        }
    }
}

