/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsIndices;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsNodes;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentFactory;

public class ClusterStatsResponse
extends BaseNodesResponse<ClusterStatsNodeResponse>
implements ToXContent {
    ClusterStatsNodes nodesStats;
    ClusterStatsIndices indicesStats;
    String clusterUUID;
    ClusterHealthStatus status;
    long timestamp;

    ClusterStatsResponse() {
    }

    public ClusterStatsResponse(long timestamp, ClusterName clusterName, String clusterUUID, ClusterStatsNodeResponse[] nodes) {
        super(clusterName, null);
        this.timestamp = timestamp;
        this.clusterUUID = clusterUUID;
        this.nodesStats = new ClusterStatsNodes(nodes);
        this.indicesStats = new ClusterStatsIndices(nodes);
        for (ClusterStatsNodeResponse response : nodes) {
            if (response.clusterStatus() == null) continue;
            this.status = response.clusterStatus();
            break;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ClusterHealthStatus getStatus() {
        return this.status;
    }

    public ClusterStatsNodes getNodesStats() {
        return this.nodesStats;
    }

    public ClusterStatsIndices getIndicesStats() {
        return this.indicesStats;
    }

    public ClusterStatsNodeResponse[] getNodes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, ClusterStatsNodeResponse> getNodesMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClusterStatsNodeResponse getAt(int position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ClusterStatsNodeResponse> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.timestamp = in.readVLong();
        this.status = null;
        if (in.readBoolean()) {
            this.status = ClusterHealthStatus.fromValue(in.readByte());
        }
        this.clusterUUID = in.readString();
        this.nodesStats = ClusterStatsNodes.readNodeStats(in);
        this.indicesStats = ClusterStatsIndices.readIndicesStats(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.timestamp);
        if (this.status == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.status.value());
        }
        out.writeString(this.clusterUUID);
        this.nodesStats.writeTo(out);
        this.indicesStats.writeTo(out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("timestamp", this.getTimestamp());
        builder.field(Fields.CLUSTER_NAME, this.getClusterName().value());
        if (params.paramAsBoolean("output_uuid", false)) {
            builder.field(Fields.UUID, this.clusterUUID);
        }
        if (this.status != null) {
            builder.field(Fields.STATUS, this.status.name().toLowerCase(Locale.ROOT));
        }
        builder.startObject(Fields.INDICES);
        this.indicesStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.NODES);
        this.nodesStats.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }
        catch (IOException e) {
            return "{ \"error\" : \"" + e.getMessage() + "\"}";
        }
    }

    static final class Fields {
        static final XContentBuilderString NODES = new XContentBuilderString("nodes");
        static final XContentBuilderString INDICES = new XContentBuilderString("indices");
        static final XContentBuilderString UUID = new XContentBuilderString("uuid");
        static final XContentBuilderString CLUSTER_NAME = new XContentBuilderString("cluster_name");
        static final XContentBuilderString STATUS = new XContentBuilderString("status");

        Fields() {
        }
    }
}

