/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.io;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.SpatialContextFactory;
import com.spatial4j.core.io.ShapeWriter;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Locale;

@Deprecated
public class LegacyShapeWriter
implements ShapeWriter {
    final SpatialContext ctx;

    public LegacyShapeWriter(SpatialContext ctx, SpatialContextFactory factory) {
        this.ctx = ctx;
    }

    public static String writeShape(Shape shape) {
        return LegacyShapeWriter.writeShape(shape, LegacyShapeWriter.makeNumberFormat(6));
    }

    public static String writeShape(Shape shape, NumberFormat nf) {
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return nf.format(point.getX()) + " " + nf.format(point.getY());
        }
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            return nf.format(rect.getMinX()) + " " + nf.format(rect.getMinY()) + " " + nf.format(rect.getMaxX()) + " " + nf.format(rect.getMaxY());
        }
        if (shape instanceof Circle) {
            Circle c = (Circle)shape;
            return "Circle(" + nf.format(c.getCenter().getX()) + " " + nf.format(c.getCenter().getY()) + " " + "d=" + nf.format(c.getRadius()) + ")";
        }
        return shape.toString();
    }

    public static NumberFormat makeNumberFormat(int fractionDigits) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(fractionDigits);
        nf.setMinimumFractionDigits(0);
        return nf;
    }

    @Override
    public String getFormatName() {
        return "LEGACY";
    }

    @Override
    public void write(Writer output, Shape shape) throws IOException {
        output.append(LegacyShapeWriter.writeShape(shape));
    }

    @Override
    public String toString(Shape shape) {
        return LegacyShapeWriter.writeShape(shape);
    }
}

