/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet.filters.invoker;

import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.concurrent.ConcurrentLFUCache;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.HttpOnlyCookieServletResponse;
import com.liferay.portal.kernel.servlet.NonSerializableObjectRequestWrapper;
import com.liferay.portal.kernel.servlet.SanitizedServletResponse;
import com.liferay.portal.kernel.servlet.ServletVersionDetector;
import com.liferay.portal.kernel.servlet.filters.invoker.Dispatcher;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterHelper;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InvokerFilter
extends BasePortalLifecycle
implements Filter {
    private static final String _SECURE_RESPONSE = String.valueOf(InvokerFilter.class.getName()) + "SECURE_RESPONSE";
    private static Log _log = LogFactoryUtil.getLog(InvokerFilter.class);
    private String _contextPath;
    private Dispatcher _dispatcher;
    private ConcurrentLFUCache<String, InvokerFilterChain> _filterChains;
    private FilterConfig _filterConfig;
    private int _invokerFilterChainSize;
    private InvokerFilterHelper _invokerFilterHelper;
    private int _invokerFilterURIMaxLength;

    public void destroy() {
        this.portalDestroy();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String uri = this.getURI(request);
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestURL = this.getURL(request);
        if (requestURL.length() > this._invokerFilterURIMaxLength) {
            response.sendError(414);
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(7);
                sb.append("Rejected ");
                sb.append(StringUtil.shorten(uri, this._invokerFilterURIMaxLength));
                sb.append(" because it has more than ");
                sb.append(this._invokerFilterURIMaxLength);
                sb.append(" characters");
                _log.warn(sb.toString());
            }
            return;
        }
        request = this.handleNonSerializableRequest(request);
        if (ServletVersionDetector.is3_0()) {
            response = HttpOnlyCookieServletResponse.getHttpOnlyCookieServletResponse(response);
        }
        response = this.secureResponseHeaders(request, response);
        request.setAttribute("INVOKER_FILTER_URI", (Object)uri);
        try {
            InvokerFilterChain invokerFilterChain = this.getInvokerFilterChain(request, uri, filterChain);
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            invokerFilterChain.setContextClassLoader(contextClassLoader);
            invokerFilterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            request.removeAttribute("INVOKER_FILTER_URI");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
        ServletContext servletContext = this._filterConfig.getServletContext();
        this._contextPath = ContextPathUtil.getContextPath(servletContext);
        boolean registerPortalLifecycle = GetterUtil.getBoolean(this._filterConfig.getInitParameter("register-portal-lifecycle"), true);
        if (registerPortalLifecycle) {
            this.registerPortalLifecycle();
        } else {
            try {
                this.doPortalInit();
            }
            catch (Exception e) {
                _log.error(e, e);
                throw new ServletException((Throwable)e);
            }
        }
    }

    protected void clearFilterChainsCache() {
        if (this._filterChains != null) {
            this._filterChains.clear();
        }
    }

    @Override
    protected void doPortalDestroy() {
        ServletContext servletContext = this._filterConfig.getServletContext();
        InvokerFilterHelper invokerFilterHelper = (InvokerFilterHelper)servletContext.getAttribute(InvokerFilterHelper.class.getName());
        if (invokerFilterHelper != null) {
            servletContext.removeAttribute(InvokerFilterHelper.class.getName());
            invokerFilterHelper.destroy();
        }
    }

    @Override
    protected void doPortalInit() throws Exception {
        this._invokerFilterChainSize = GetterUtil.getInteger(PropsUtil.get("invoker.filter.chain.cache.size"));
        if (this._invokerFilterChainSize > 0) {
            this._filterChains = new ConcurrentLFUCache(this._invokerFilterChainSize);
        }
        this._invokerFilterURIMaxLength = GetterUtil.getInteger(PropsUtil.get("invoker.filter.uri.max.length"));
        ServletContext servletContext = this._filterConfig.getServletContext();
        InvokerFilterHelper invokerFilterHelper = (InvokerFilterHelper)servletContext.getAttribute(InvokerFilterHelper.class.getName());
        if (invokerFilterHelper == null) {
            invokerFilterHelper = new InvokerFilterHelper();
            servletContext.setAttribute(InvokerFilterHelper.class.getName(), (Object)invokerFilterHelper);
            invokerFilterHelper.readLiferayFilterWebXML(servletContext, "/WEB-INF/liferay-web.xml");
        }
        this._invokerFilterHelper = invokerFilterHelper;
        this._invokerFilterHelper.addInvokerFilter(this);
        String dispatcher = GetterUtil.getString(this._filterConfig.getInitParameter("dispatcher"));
        if (dispatcher.equals("ERROR")) {
            this._dispatcher = Dispatcher.ERROR;
        } else if (dispatcher.equals("FORWARD")) {
            this._dispatcher = Dispatcher.FORWARD;
        } else if (dispatcher.equals("INCLUDE")) {
            this._dispatcher = Dispatcher.INCLUDE;
        } else if (dispatcher.equals("REQUEST")) {
            this._dispatcher = Dispatcher.REQUEST;
        } else {
            throw new IllegalArgumentException("Invalid dispatcher " + dispatcher);
        }
    }

    protected InvokerFilterChain getInvokerFilterChain(HttpServletRequest request, String uri, FilterChain filterChain) {
        if (this._filterChains == null) {
            return this._invokerFilterHelper.createInvokerFilterChain(request, this._dispatcher, uri, filterChain);
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(InvokerFilter.class.getName());
        String key = String.valueOf(cacheKeyGenerator.getCacheKey(uri));
        InvokerFilterChain invokerFilterChain = this._filterChains.get(key);
        if (invokerFilterChain == null) {
            invokerFilterChain = this._invokerFilterHelper.createInvokerFilterChain(request, this._dispatcher, uri, filterChain);
            this._filterChains.put(key, invokerFilterChain);
        }
        return invokerFilterChain.clone(filterChain);
    }

    protected String getURI(HttpServletRequest request) {
        String uri = null;
        uri = this._dispatcher == Dispatcher.ERROR ? (String)request.getAttribute("javax.servlet.error.request_uri") : (this._dispatcher == Dispatcher.INCLUDE ? (String)request.getAttribute("javax.servlet.include.request_uri") : request.getRequestURI());
        if (Validator.isNotNull(this._contextPath) && !this._contextPath.equals("/") && uri.startsWith(this._contextPath)) {
            uri = uri.substring(this._contextPath.length());
        }
        return HttpUtil.normalizePath(uri);
    }

    protected String getURL(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        if (requestURL == null) {
            return "";
        }
        String queryString = request.getQueryString();
        if (!Validator.isBlank(queryString)) {
            requestURL.append("?");
            requestURL.append(request.getQueryString());
        }
        return requestURL.toString();
    }

    protected HttpServletRequest handleNonSerializableRequest(HttpServletRequest request) {
        if (ServerDetector.isWebLogic() && !NonSerializableObjectRequestWrapper.isWrapped(request)) {
            request = new NonSerializableObjectRequestWrapper((HttpServletRequest)request);
        }
        return request;
    }

    protected HttpServletResponse secureResponseHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (!GetterUtil.getBoolean(request.getAttribute(_SECURE_RESPONSE), true)) {
            return response;
        }
        request.setAttribute(_SECURE_RESPONSE, (Object)Boolean.FALSE);
        return SanitizedServletResponse.getSanitizedServletResponse(request, response);
    }
}

