/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security;

import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.util.GetterUtil;
import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SecureRandomUtil {
    private static final int _BUFFER_SIZE;
    private static final int _MIN_BUFFER_SIZE = 1024;
    private static final byte[] _bytes;
    private static final AtomicInteger _index;
    private static final Random _random;
    private static final AtomicBoolean _reloadingFlag;
    private static long _gapSeed;

    static {
        _index = new AtomicInteger();
        _random = new SecureRandom();
        _reloadingFlag = new AtomicBoolean();
        int bufferSize = GetterUtil.getInteger(System.getProperty(String.valueOf(SecureRandomUtil.class.getName()) + ".buffer.size"));
        if (bufferSize < 1024) {
            bufferSize = 1024;
        }
        _BUFFER_SIZE = bufferSize;
        _bytes = new byte[_BUFFER_SIZE];
        _random.nextBytes(_bytes);
        _gapSeed = _random.nextLong();
    }

    public static boolean nextBoolean() {
        byte b = SecureRandomUtil.nextByte();
        return b >= 0;
    }

    public static byte nextByte() {
        int index = _index.getAndIncrement();
        if (index < _BUFFER_SIZE) {
            return _bytes[index];
        }
        return (byte)SecureRandomUtil._reload();
    }

    public static double nextDouble() {
        int index = _index.getAndAdd(8);
        if (index + 7 < _BUFFER_SIZE) {
            return BigEndianCodec.getDouble(_bytes, index);
        }
        return Double.longBitsToDouble(SecureRandomUtil._reload());
    }

    public static float nextFloat() {
        int index = _index.getAndAdd(4);
        if (index + 3 < _BUFFER_SIZE) {
            return BigEndianCodec.getFloat(_bytes, index);
        }
        return Float.intBitsToFloat((int)SecureRandomUtil._reload());
    }

    public static int nextInt() {
        int index = _index.getAndAdd(4);
        if (index + 3 < _BUFFER_SIZE) {
            return BigEndianCodec.getInt(_bytes, index);
        }
        return (int)SecureRandomUtil._reload();
    }

    public static long nextLong() {
        int index = _index.getAndAdd(8);
        if (index + 7 < _BUFFER_SIZE) {
            return BigEndianCodec.getLong(_bytes, index);
        }
        return SecureRandomUtil._reload();
    }

    private static long _reload() {
        long l;
        if (_reloadingFlag.compareAndSet(false, true)) {
            _random.nextBytes(_bytes);
            _index.set(0);
            _reloadingFlag.set(false);
        }
        int offset = _index.get() % (_BUFFER_SIZE - 7);
        _gapSeed = l = BigEndianCodec.getLong(_bytes, offset) ^ _gapSeed;
        return l;
    }
}

