/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortletBagPool {
    private static PortletBagPool _instance = new PortletBagPool();
    private Map<String, PortletBag> _portletBagPool = new ConcurrentHashMap<String, PortletBag>();

    public static PortletBag get(String portletId) {
        PortalRuntimePermission.checkPortletBagPool(portletId);
        return _instance._get(portletId);
    }

    public static void put(String portletId, PortletBag portletBag) {
        PortalRuntimePermission.checkPortletBagPool(portletId);
        _instance._put(portletId, portletBag);
    }

    public static PortletBag remove(String portletId) {
        PortalRuntimePermission.checkPortletBagPool(portletId);
        return _instance._remove(portletId);
    }

    public static void reset() {
        PortalRuntimePermission.checkPortletBagPool("<<ALL PORTLETS>>");
        _instance._reset();
    }

    private PortletBagPool() {
    }

    private PortletBag _get(String portletId) {
        return this._portletBagPool.get(portletId);
    }

    private void _put(String portletId, PortletBag portletBag) {
        this._portletBagPool.put(portletId, portletBag);
    }

    private PortletBag _remove(String portletId) {
        return this._portletBagPool.remove(portletId);
    }

    private void _reset() {
        this._portletBagPool.clear();
    }
}

