/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.nio.intraband.BaseAsyncDatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.cache.IntrabandPortalCacheManager;
import com.liferay.portal.kernel.nio.intraband.cache.PortalCacheActionType;
import java.io.Serializable;
import java.net.URL;
import java.util.Collection;

public class PortalCacheDatagramReceiveHandler
extends BaseAsyncDatagramReceiveHandler {
    @Override
    protected void doReceive(RegistrationReference registrationReference, Datagram datagram) throws Exception {
        Deserializer deserializer = new Deserializer(datagram.getDataByteBuffer());
        PortalCacheActionType portalCacheActionType = PortalCacheActionType.values()[deserializer.readInt()];
        PortalCacheManager portalCacheManager = IntrabandPortalCacheManager.getPortalCacheManager();
        switch (portalCacheActionType) {
            case DESTROY: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                portalCache.destroy();
                break;
            }
            case GET: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                Object key = deserializer.readObject();
                Serializable value = (Serializable)portalCache.get(key);
                this._sendResponse(registrationReference, datagram, value);
                break;
            }
            case GET_BULK: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                Collection keys = (Collection)deserializer.readObject();
                Object values = portalCache.get(keys);
                this._sendResponse(registrationReference, datagram, (Serializable)values);
                break;
            }
            case PUT: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                Object key = deserializer.readObject();
                Object value = deserializer.readObject();
                portalCache.put(key, value);
                break;
            }
            case PUT_TTL: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                Object key = deserializer.readObject();
                Object value = deserializer.readObject();
                int ttl = deserializer.readInt();
                portalCache.put(key, value, ttl);
                break;
            }
            case RECONFIGURE: {
                portalCacheManager.reconfigureCaches(new URL(deserializer.readString()));
                break;
            }
            case REMOVE: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                Object key = deserializer.readObject();
                portalCache.remove(key);
                break;
            }
            case REMOVE_ALL: {
                PortalCache portalCache = portalCacheManager.getCache(deserializer.readString());
                portalCache.removeAll();
                break;
            }
            default: {
                throw new PortalCacheException("Unsupported portal cache action type " + (Object)((Object)portalCacheActionType));
            }
        }
    }

    private void _sendResponse(RegistrationReference registrationReference, Datagram datagram, Serializable result) {
        Serializer serializer = new Serializer();
        serializer.writeObject(result);
        Intraband intraband = registrationReference.getIntraband();
        intraband.sendDatagram(registrationReference, Datagram.createResponseDatagram(datagram, serializer.toByteBuffer()));
    }
}

