/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.memory;

import com.liferay.portal.kernel.memory.PoolAction;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class SoftReferencePool<V, P> {
    public static final int DEFAULT_IDLE_SIZE = 8;
    private int _maxIdleSize;
    private PoolAction<V, P> _poolAction;
    private ReferenceQueue<V> _referenceQueue = new ReferenceQueue();
    private Queue<SoftReference<? extends V>> _softReferences = new ConcurrentLinkedQueue<SoftReference<? extends V>>();
    private boolean _useWeakCounter;
    private AtomicInteger _weakCounter;

    public SoftReferencePool(PoolAction<V, P> poolAction) {
        this(poolAction, 8);
    }

    public SoftReferencePool(PoolAction<V, P> poolAction, int maxIdleSize) {
        this(poolAction, maxIdleSize, true);
    }

    public SoftReferencePool(PoolAction<V, P> poolAction, int maxIdleSize, boolean useWeakCounter) {
        this._poolAction = poolAction;
        this._maxIdleSize = maxIdleSize;
        this._useWeakCounter = useWeakCounter;
        if (this._useWeakCounter) {
            this._weakCounter = new AtomicInteger();
        }
    }

    public V borrowObject(P parameter) {
        SoftReference<V> softReference;
        V value;
        do {
            if ((softReference = this._softReferences.poll()) == null) {
                return this._poolAction.onCreate(parameter);
            }
            if (!this._useWeakCounter) continue;
            this._weakCounter.getAndDecrement();
        } while ((value = softReference.get()) == null);
        return this._poolAction.onBorrow(value, parameter);
    }

    /*
     * Unable to fully structure code
     */
    public void returnObject(V value) {
        block4: {
            if (this._getCount() >= this._maxIdleSize) ** GOTO lbl13
            softReference = new SoftReference(value, this._referenceQueue);
            this._poolAction.onReturn(value);
            this._softReferences.offer(softReference);
            if (!this._useWeakCounter) break block4;
            this._weakCounter.getAndIncrement();
            break block4;
lbl-1000:
            // 1 sources

            {
                if (this._softReferences.poll() == null || !this._useWeakCounter) continue;
                this._weakCounter.getAndDecrement();
lbl13:
                // 3 sources

                ** while (this._getCount() > this._maxIdleSize)
            }
        }
        softReference = null;
        while ((softReference = (SoftReference)this._referenceQueue.poll()) != null) {
            if (!this._softReferences.remove(softReference) || !this._useWeakCounter) continue;
            this._weakCounter.getAndDecrement();
        }
    }

    private int _getCount() {
        if (this._useWeakCounter) {
            return this._weakCounter.get();
        }
        return this._softReferences.size();
    }
}

