/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.contrib.dualwrites;

import com.google.common.util.concurrent.ListenableFuture;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.WriteAheadLog;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.contrib.dualwrites.DualKeyspaceMetadata;
import com.netflix.astyanax.contrib.dualwrites.DualWritesColumnListMutation;
import com.netflix.astyanax.contrib.dualwrites.DualWritesStrategy;
import com.netflix.astyanax.contrib.dualwrites.WriteMetadata;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class DualWritesMutationBatch
implements MutationBatch {
    private final DualKeyspaceMetadata dualKeyspaceMetadata;
    private final MutationBatch primary;
    private final MutationBatch secondary;
    private final DualWritesStrategy writeExecutionStrategy;
    private final AtomicReference<List<WriteMetadata>> writeMetada = new AtomicReference(new ArrayList());

    public DualWritesMutationBatch(DualKeyspaceMetadata dualKSMetadata, MutationBatch primaryMB, MutationBatch secondaryMB, DualWritesStrategy strategy) {
        this.dualKeyspaceMetadata = dualKSMetadata;
        this.primary = primaryMB;
        this.secondary = secondaryMB;
        this.writeExecutionStrategy = strategy;
    }

    public MutationBatch getPrimary() {
        return this.primary;
    }

    public MutationBatch getSecondary() {
        return this.secondary;
    }

    public OperationResult<Void> execute() throws ConnectionException {
        return this.writeExecutionStrategy.wrapExecutions(this.primary, this.secondary, (Collection<WriteMetadata>)this.writeMetada.get()).execute();
    }

    public ListenableFuture<OperationResult<Void>> executeAsync() throws ConnectionException {
        return this.writeExecutionStrategy.wrapExecutions(this.primary, this.secondary, (Collection<WriteMetadata>)this.writeMetada.get()).executeAsync();
    }

    public <K, C> ColumnListMutation<C> withRow(ColumnFamily<K, C> columnFamily, K rowKey) {
        this.writeMetada.get().add(new WriteMetadata(this.dualKeyspaceMetadata, columnFamily.getName(), rowKey.toString()));
        ColumnListMutation clmPrimary = this.primary.withRow(columnFamily, rowKey);
        ColumnListMutation clmSecondary = this.secondary.withRow(columnFamily, rowKey);
        return new DualWritesColumnListMutation(clmPrimary, clmSecondary);
    }

    public <K> void deleteRow(Iterable<? extends ColumnFamily<K, ?>> columnFamilies, K rowKey) {
        for (ColumnFamily<K, ?> cf : columnFamilies) {
            this.writeMetada.get().add(new WriteMetadata(this.dualKeyspaceMetadata, cf.getName(), rowKey.toString()));
        }
        this.primary.deleteRow(columnFamilies, rowKey);
        this.secondary.deleteRow(columnFamilies, rowKey);
    }

    public void discardMutations() {
        this.primary.discardMutations();
        this.secondary.discardMutations();
        this.writeMetada.set(new ArrayList());
    }

    public void mergeShallow(MutationBatch other) {
        this.primary.mergeShallow(other);
        this.secondary.mergeShallow(other);
    }

    public boolean isEmpty() {
        return this.primary.isEmpty();
    }

    public int getRowCount() {
        return this.primary.getRowCount();
    }

    public Map<ByteBuffer, Set<String>> getRowKeys() {
        return this.primary.getRowKeys();
    }

    public MutationBatch pinToHost(Host host) {
        this.primary.pinToHost(host);
        this.secondary.pinToHost(host);
        return this;
    }

    public MutationBatch setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.primary.setConsistencyLevel(consistencyLevel);
        this.secondary.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public MutationBatch withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.primary.withConsistencyLevel(consistencyLevel);
        this.secondary.withConsistencyLevel(consistencyLevel);
        return this;
    }

    public MutationBatch withRetryPolicy(RetryPolicy retry) {
        this.primary.withRetryPolicy(retry);
        this.secondary.withRetryPolicy(retry);
        return this;
    }

    public MutationBatch usingWriteAheadLog(WriteAheadLog manager) {
        this.primary.usingWriteAheadLog(manager);
        return this;
    }

    public MutationBatch lockCurrentTimestamp() {
        this.primary.lockCurrentTimestamp();
        this.secondary.lockCurrentTimestamp();
        return this;
    }

    public MutationBatch setTimeout(long timeout) {
        this.primary.setTimeout(timeout);
        this.secondary.setTimeout(timeout);
        return this;
    }

    public MutationBatch setTimestamp(long timestamp) {
        this.primary.setTimestamp(timestamp);
        this.secondary.setTimestamp(timestamp);
        return this;
    }

    public MutationBatch withTimestamp(long timestamp) {
        this.primary.withTimestamp(timestamp);
        this.secondary.withTimestamp(timestamp);
        return this;
    }

    public MutationBatch withAtomicBatch(boolean condition) {
        this.primary.withAtomicBatch(condition);
        this.secondary.withAtomicBatch(condition);
        return this;
    }

    public ByteBuffer serialize() throws Exception {
        this.secondary.serialize();
        return this.primary.serialize();
    }

    public void deserialize(ByteBuffer data) throws Exception {
        ByteBuffer clone = DualWritesMutationBatch.clone(data);
        this.primary.deserialize(data);
        this.secondary.deserialize(clone);
    }

    public MutationBatch withCaching(boolean condition) {
        this.primary.withCaching(condition);
        this.secondary.withCaching(condition);
        return this;
    }

    private static ByteBuffer clone(ByteBuffer original) {
        ByteBuffer clone = ByteBuffer.allocate(original.capacity());
        original.rewind();
        clone.put(original);
        original.rewind();
        clone.flip();
        return clone;
    }
}

