/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.socialnetworking.socialdataindexer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.codehaus.jackson.map.ObjectMapper;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.socialnetworking.social_data_indexing_common.ex.BulkInsertionFailedException;
import org.gcube.socialnetworking.social_data_indexing_common.utils.ElasticSearchRunningCluster;
import org.gcube.socialnetworking.socialdataindexer.SocialDataIndexerPluginDeclaration;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialDataIndexerPlugin
extends Plugin<SocialDataIndexerPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(SocialDataIndexerPlugin.class);
    private String clusterName;
    private List<String> hostsToContact;
    private List<Integer> portNumbers;
    private TransportClient client;
    private DatabookStore store;
    private int count = 0;

    public SocialDataIndexerPlugin(SocialDataIndexerPluginDeclaration pluginDeclaration) {
        super((PluginDeclaration)pluginDeclaration);
        logger.debug("Constructor");
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        try {
            logger.info("Reading scope from ScopeProvider");
            String scope = ScopeProvider.instance.get();
            logger.info("Scope read is " + scope);
            this.store = new DBCassandraAstyanaxImpl(scope.replaceFirst("/", ""));
            ElasticSearchRunningCluster elasticCluster = new ElasticSearchRunningCluster(scope.replaceFirst("/", ""));
            this.clusterName = elasticCluster.getClusterName();
            this.hostsToContact = elasticCluster.getHosts();
            this.portNumbers = elasticCluster.getPorts();
            logger.info("Creating elasticsearch client connection for hosts = " + this.hostsToContact + ", ports = " + this.portNumbers + " and  cluster's name = " + this.clusterName);
            Settings settings = Settings.settingsBuilder().put("cluster.name", this.clusterName).put("client.transport.sniff", true).build();
            this.client = TransportClient.builder().settings(settings).build();
            int reachableHosts = 0;
            for (int i = 0; i < this.hostsToContact.size(); ++i) {
                try {
                    this.client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(this.hostsToContact.get(i)), this.portNumbers.get(i).intValue()));
                    ++reachableHosts;
                    continue;
                }
                catch (UnknownHostException e) {
                    logger.error("Error while adding " + this.hostsToContact.get(i) + ":" + this.portNumbers.get(i) + " as host to be contacted.");
                }
            }
            if (reachableHosts == 0) {
                logger.error("Unable to reach elasticsearch cluster. Exiting ...");
                return;
            }
            logger.info("Connection to ElasticSearch cluster done. Synchronization starts running...");
            long init = System.currentTimeMillis();
            List vreIds = this.store.getAllVREIds();
            for (String vreID : vreIds) {
                try {
                    List feeds = this.store.getAllFeedsByVRE(vreID);
                    this.addEnhancedFeedsInBulk(feeds, init);
                    logger.info("Number of indexed feeds is " + feeds.size() + " for vre " + vreID);
                }
                catch (Exception e) {
                    logger.error("Exception while saving feeds/comments into the index for vre " + vreID, (Throwable)e);
                }
            }
            logger.info("Inserted " + this.count + " docs into the index");
            this.client.admin().indices().prepareRefresh(new String[0]).execute().actionGet();
            this.deleteDocumentsWithTimestampLowerThan(init);
            long end = System.currentTimeMillis();
            logger.info("Synchronization thread ends running. It took " + (end - init) + " milliseconds  that is " + (double)(end - init) / 60000.0 + " minutes.");
        }
        catch (Exception e) {
            logger.error("Error while synchronizing data.", (Throwable)e);
            throw e;
        }
        finally {
            if (this.client != null) {
                logger.info("Closing connection to elasticsearch cluster. " + this.client.toString());
                this.client.close();
            }
            if (this.store != null) {
                logger.info("Closing connection to cassandra nodes. " + this.store.toString());
                this.store.closeConnection();
            }
        }
    }

    private void addEnhancedFeedsInBulk(List<Feed> feeds, long init) throws BulkInsertionFailedException {
        logger.debug("Starting bulk insert enhanced feeds operation");
        BulkProcessor bulkProcessor = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                logger.debug("Going to execute new bulk composed of {} actions", (Object)request.numberOfActions());
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                logger.debug("Executed bulk composed of {} actions", (Object)request.numberOfActions());
                if (response.hasFailures()) {
                    logger.warn("There was failures while executing bulk", (Object)response.buildFailureMessage());
                    if (logger.isDebugEnabled()) {
                        for (BulkItemResponse item : response.getItems()) {
                            if (!item.isFailed()) continue;
                            logger.debug("Error for {}/{}/{} for {} operation: {}", new Object[]{item.getIndex(), item.getType(), item.getId(), item.getOpType(), item.getFailureMessage()});
                        }
                    }
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                logger.error("Error executing bulk", failure);
                if (failure instanceof NoNodeAvailableException) {
                    throw new RuntimeException("No node available. Exiting...");
                }
            }
        }).setBulkActions(1000).setBulkSize(new ByteSizeValue(5L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)5L)).setConcurrentRequests(0).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)50L), (int)8)).build();
        for (Feed feed : feeds) {
            String enhFeedUUID = null;
            try {
                String json = this.enhanceAndConvertToJson(feed);
                enhFeedUUID = feed.getKey();
                IndexRequest ind = new IndexRequest("social", "enhanced_feeds", enhFeedUUID).timestamp(String.valueOf(init)).source(json);
                bulkProcessor.add(ind);
                ++this.count;
            }
            catch (Exception e) {
                logger.error("Skip inserting feed with id " + enhFeedUUID, (Throwable)e);
            }
        }
        try {
            bulkProcessor.awaitClose(60000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrupted while waiting for awaitClose()", (Throwable)e);
        }
    }

    private String enhanceAndConvertToJson(Feed feed) throws Exception {
        boolean isMultiFileUpload = feed.isMultiFileUpload();
        ArrayList attachments = new ArrayList();
        if (isMultiFileUpload) {
            logger.debug("Retrieving attachments for feed with id=" + feed.getKey());
            attachments = (ArrayList)this.store.getAttachmentsByFeedId(feed.getKey());
        }
        ArrayList<Comment> comments = this.getAllCommentsByFeed(feed.getKey());
        EnhancedFeed enFeed = new EnhancedFeed(feed, false, false, comments, attachments);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)enFeed);
    }

    private ArrayList<Comment> getAllCommentsByFeed(String feedid) {
        ArrayList toReturn = (ArrayList)this.store.getAllCommentByFeed(feedid);
        Collections.sort(toReturn);
        return toReturn;
    }

    public void deleteDocumentsWithTimestampLowerThan(long timestamp) {
        logger.debug("Removing docs with timestamp lower than " + timestamp);
        BoolQueryBuilder filter = QueryBuilders.boolQuery();
        filter.must((QueryBuilder)QueryBuilders.matchAllQuery());
        filter.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"_timestamp").gte(0).lt(timestamp));
        SearchResponse scrollResp = (SearchResponse)this.client.prepareSearch(new String[]{"social"}).setSize(100).setScroll(new TimeValue(60000L)).setQuery((QueryBuilder)filter).execute().actionGet();
        int deleteDocs = 0;
        do {
            for (SearchHit hit : scrollResp.getHits().getHits()) {
                String docID = hit.getId();
                DeleteResponse response = (DeleteResponse)this.client.prepareDelete("social", "enhanced_feeds", docID).get();
                if (!response.isFound()) continue;
                ++deleteDocs;
            }
        } while ((scrollResp = (SearchResponse)this.client.prepareSearchScroll(scrollResp.getScrollId()).setScroll(new TimeValue(60000L)).execute().actionGet()).getHits().getHits().length != 0);
        logger.debug("No more hits to delete");
        logger.info("Number of delete documents is " + deleteDocs);
    }

    protected void onStop() throws Exception {
        logger.debug("onStop()");
        Thread.currentThread().interrupt();
    }
}

