package org.gcube.social_networking.rest;

import java.rmi.ServerException;
import java.util.HashMap;
import java.util.List;

import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.idm.client.IdmClientFactory;
import org.gcube.idm.client.IdmMeClient;
import org.gcube.idm.client.IdmUsersClient;
import org.gcube.idm.client.SearchUsersParams;
import org.gcube.idm.client.model.UserInfo;
import org.gcube.idm.common.models.IdmFullUser;
import org.gcube.idm.common.models.IdmUser;
import org.gcube.social_networking.utils.InfrastructureUtils;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

@Path("/idm")
@RequestHeaders({
        @RequestHeader(name = "Authorization", description = "Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")
})
public class IdmRest {

    @GET
    @Path("/me")
    @Produces({ MediaType.APPLICATION_JSON })
    public Response test() throws ServerException {

        IdmClientFactory factory = IdmClientFactory.getSingleton();

        String token = InfrastructureUtils.getAccessToken();

        IdmMeClient client = factory.meClient(token);

        UserInfo user = client.getMe();

        HashMap<String, Object> resp = new HashMap<String, Object>();

        resp.put("result", user);

        try {
            String jsonData = new ObjectMapper().writeValueAsString(resp);
            return Response.ok(jsonData).build();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path("/{username}/")
    @Produces({ MediaType.APPLICATION_JSON })
    public Response getUser(
            @PathParam("username") String username) throws ServerException {

        IdmClientFactory factory = IdmClientFactory.getSingleton();

        String token = InfrastructureUtils.getAccessToken();

        IdmUsersClient client = factory.userClient(token);

        UserInfo user = client.getUser(username);

        HashMap<String, Object> resp = new HashMap<String, Object>();

        resp.put("result", user);

        try {
            String jsonData = new ObjectMapper().writeValueAsString(resp);
            return Response.ok(jsonData).build();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }



    @GET
    @Path("/{search}/")
    @Produces({ MediaType.APPLICATION_JSON })
    public Response searchUsers(
            @QueryParam("format") @DefaultValue("username") IdmUser.USERS_REPR format,
            @QueryParam("exact") @DefaultValue("true") Boolean exact,
            @QueryParam("username") String username,
            @QueryParam("firstName") String firstName,
            @QueryParam("lastName") String lastName,
            @QueryParam("email") String email,
            @QueryParam("first") @DefaultValue("0") int firstResult,
            @QueryParam("max") @DefaultValue("100") int maxResults,
            @QueryParam("enabled") @DefaultValue("true") Boolean enabled

    ) throws ServerException {

        IdmClientFactory factory = IdmClientFactory.getSingleton();

        String token = InfrastructureUtils.getAccessToken();

        IdmUsersClient client = factory.userClient(token);

        SearchUsersParams params = new SearchUsersParams();

        if (exact != null)
            params.exact = exact;

        if (username != null)
            params.username = username;

        if (firstName != null)
            params.firstName = firstName;

        if (lastName != null)
            params.lastName = lastName;

        if (email != null)
            params.email = email;

        if (enabled != null)
            params.enabled = enabled;

        Object resp = null;

        if (format.equals(IdmUser.USERS_REPR.compact)) {
            List<IdmUser> users = client.searchUsers(firstResult, maxResults, params);
            resp = users;
        }

        if (format.equals(IdmUser.USERS_REPR.full)) {
            List<IdmFullUser> users = client.searchFullUsers(firstResult, maxResults, params);
            resp = users;
        }

        if (format.equals(IdmUser.USERS_REPR.username)) {
            List<String> users = client.searchUsernames(firstResult, maxResults, params);
            resp = users;
        }

        if (format.equals(IdmUser.USERS_REPR.email)) {
            List<String> users = client.searchEmails(firstResult, maxResults, params);
            resp = users;
        }



        try

        {
            String jsonData = new ObjectMapper().writeValueAsString(resp);
            return Response.ok(jsonData).build();
        } catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

}
